/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.CommonProfilUtils;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.Document;
import com.geolocsystems.prismandroid.model.IUtilisateur;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.tri.EvenementTri;
import com.geolocsystems.prismandroid.model.evenements.tri.EvenementTriListe;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampImages;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampVehiculeEnCause;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineCentreBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineDelegationBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineList;
import com.geolocsystems.prismbirtbean.SyntheseAccidentologieBean;
import com.geolocsystems.prismbirtbean.SyntheseAccidentologieLineBean;
import com.geolocsystems.prismbirtbean.SyntheseTBDelaiDureeInterventionBean;
import com.geolocsystems.prismbirtbean.SyntheseTBDelaiDureeInterventionLineBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IDocumentDAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.McigDAOJDBC;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.Utils;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.IEvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJavaSituation;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJavaSituationDDP;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentral.maincourante.CommentaireComposantFactory2;
import com.geolocsystems.prismcentraldata.util.PrismCodeEvenementGenerator;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.localisation.pr.LocalisantPr;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Nombre;
import gls.outils.sql.SQL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.postgis.LineString;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class EvenementsDAOJDBC
implements IEvenementsDAO {
    private DAOFactory daoFactory;
    private IReferentielDAO referentiel;
    private IUserDAO user;
    private IMcigDAO mcig;
    private NumberFormat nf;
    private static final String REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_SELECT = "SELECT SUM(CAST((CASE WHEN (tues.valeur is null OR tues.valeur = '') THEN '0' ELSE tues.valeur END) AS INTEGER)) as nbtues, (SUM(CAST((CASE WHEN (legers.valeur is null OR legers.valeur = '') THEN '0' ELSE legers.valeur END) AS INTEGER)) +  SUM(CAST((CASE WHEN (graves.valeur is null OR graves.valeur = '') THEN '0' ELSE graves.valeur END) AS INTEGER))) AS nbblesses, date_part('month',e2.sta) as mois ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_FROM = "FROM evenement e2 LEFT JOIN prism.attribut_evenement tues ON tues.champ = ? AND e2.k_eventid = tues.k_eventid LEFT JOIN prism.attribut_evenement legers ON legers.champ = ? AND e2.k_eventid = legers.k_eventid LEFT JOIN prism.attribut_evenement graves ON graves.champ = ? AND e2.k_eventid = graves.k_eventid ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_WHERE = " WHERE (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_GROUPBY = "GROUP BY mois ORDER BY mois ASC ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_SELECT = "SELECT count(e2.vnm) as nb, ae.valeur as nature, date_part('month',e2.sta) as mois ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_FROM = "FROM attribut_evenement ae, evenement e2 ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_WHERE = "WHERE ae.champ = ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_GROUPBY = " GROUP BY mois, valeur ORDER BY mois ASC";
    private static final String REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_SELECT = "SELECT count(e2.vnm) as nb, ae.valeur as valeur, date_part('month',e2.sta) as mois ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_FROM = "FROM attribut_evenement ae, evenement e2 ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_WHERE = "WHERE ae.champ = ? AND ae.valeur is not null AND ae.valeur <> '' AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_GROUPBY = " GROUP BY mois, valeur ORDER BY mois ASC";
    private static final String REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_SELECT = "SELECT ST_Transform(e2.listecoordonnees,4326) as geom, ae.valeur as nature ";
    private static final String REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_FROM = "FROM attribut_evenement ae, evenement e2 ";
    private static final String REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_WHERE = "WHERE ae.champ = ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_GROUPBY = " ORDER BY nature ASC";
    private static final String REQUETE_DUREEDELAI_INTERVENTION_SELECT = "SELECT avg(CASE WHEN aedepart.valeur is not null AND aedepart.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) ELSE null END) ELSE null END) as tempmoyen, avg(CASE WHEN aedeclen.valeur is not null AND aedeclen.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) ELSE null END) ELSE null END) as delaimoyen, max(CASE WHEN aedepart.valeur is not null AND aedepart.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) ELSE null END) ELSE null END) as tempmax, max(CASE WHEN aedeclen.valeur is not null AND aedeclen.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) ELSE null END) ELSE null END) as delaimax, min(CASE WHEN aedepart.valeur is not null AND aedepart.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aedepart.valeur as timestamp), CAST(aearrivee.valeur as timestamp)) ELSE null END) ELSE null END) as tempmin, min(CASE WHEN aedeclen.valeur is not null AND aedeclen.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '' THEN (CASE WHEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) >= '00:00:00' AND AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) < 'XXDELAIXX' THEN AGE(CAST(aearrivee.valeur as timestamp), CAST(aedeclen.valeur as timestamp)) ELSE null END) ELSE null END) as delaimin, ";
    private static final String REQUETE_DUREEDELAI_INTERVENTION_FROM = " FROM evenement e2   JOIN prism.attribut_evenement aedepart ON aedepart.champ = 'dateDepartSite' AND e2.k_eventid = aedepart.k_eventid JOIN prism.attribut_evenement aearrivee ON aearrivee.champ = 'dateArriveeSite' AND e2.k_eventid = aearrivee.k_eventid JOIN prism.attribut_evenement aedeclen ON aedeclen.champ = 'dateDeclenchementIntervention' AND e2.k_eventid = aedeclen.k_eventid ";
    private static final String REQUETE_DUREEDELAI_INTERVENTION_WHERE = "  WHERE  (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where  \t\tnature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) \t\tAND e.sta BETWEEN ? AND ? AND e.can <> 'Y'\t\tGROUP BY e.snm, e.erf)   AND ((aedepart.valeur is not null AND aedepart.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '')  OR (aedeclen.valeur is not null AND aedeclen.valeur <> '' AND aearrivee.valeur is not null AND aearrivee.valeur <> '')) ";
    private static final String REQUETE_DUREEDELAI_INTERVENTION_GROUPBY = " GROUP BY colonne ORDER BY colonne ASC ";
    private static final String REQUETE_NB_EVENEMENT_NATURE_JOURNEE = "select count(*) as nb from prism.evenement  where nature = ? and cei = ? and date_trunc('day',to_timestamp(?/1000)) = date_trunc('day',sta) and not code_evenement is null and vnm=1 ";
    private static final String REQUETE_NB_EVENEMENT_NATURE_JOURNEE_CEI_NULL = "select count(*) as nb from prism.evenement  where nature = ? and cei is null and date_trunc('day',to_timestamp(?/1000)) = date_trunc('day',sta) and not code_evenement is null and vnm=1 ";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_SELECT = "SELECT count(DISTINCT(e.snm,e.erf)) as nb, date_part('month',e.sta) as mois, np.libelle, e.nature from prism.nature_perso np,prism.evenement e ";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_WHERE = " WHERE e.nature = np.code AND np.code_module_metier = ? AND e.sta BETWEEN ? AND ? AND e.can <> 'Y'";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_GROUPBY = " GROUP BY mois, e.nature, np.libelle ORDER BY e.nature ASC, mois ASC";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_AXE_SELECT = "SELECT count(DISTINCT(e.snm,e.erf)) as nb, route, np.libelle, e.nature from prism.nature_perso np,prism.evenement e ";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_AXE_WHERE = " WHERE e.nature = np.code AND np.code_module_metier = ? AND e.sta BETWEEN ? AND ? AND e.can <> 'Y'";
    private static final String REQUETE_NB_ACCIDENT_ET_INTERVENTION_AXE_GROUPBY = " GROUP BY route, e.nature, np.libelle ORDER BY e.nature ASC, route ASC";
    private static final String REQUETE_NB_TUES_SELECT = "SELECT count(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 ";
    private static final String REQUETE_NB_TUES_WHERE = " WHERE ae.champ = ? AND ae.valeur like ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND e.sta BETWEEN ? AND ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_NB_TUES_GROUPBY = " GROUP BY mois ORDER BY mois ASC";
    private static final String REQUETE_NB_TUES_CORPORELS_AXE_SELECT = "SELECT count(valeur) as nb, route FROM attribut_evenement ae, evenement e2 ";
    private static final String REQUETE_NB_TUES_CORPORELS_AXE_WHERE = " WHERE ae.champ = ? AND ae.valeur like ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND e.sta BETWEEN ? AND ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) ";
    private static final String REQUETE_NB_TUES_CORPORELS_AXE_GROUPBY = " GROUP BY route ORDER BY route ASC";
    private static final String REQUETE_NB_APPELS_DEBUT = "SELECT DISTINCT(valeur), COUNT(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 WHERE (ae.champ = 'emetteur' OR ae.champ = 'declenchementIntervention') AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND e.sta BETWEEN ? AND ? AND e.can <> 'Y'";
    private static final String REQUETE_NB_APPELS_FIN = " GROUP BY e.snm, e.erf) GROUP BY valeur, mois ORDER BY mois, valeur ASC";
    private static final String REQUETE_NB_ARRETES = "SELECT DISTINCT(valeur), COUNT(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 WHERE ae.champ = 'emetteur' AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND date_part('year',e.sta) = ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) GROUP BY valeur, mois ORDER BY mois, valeur ASC";
    private static final String REQUETE_NB_MANIFESTATIONS = "SELECT DISTINCT(valeur), COUNT(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 WHERE ae.champ = 'emetteur' AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND date_part('year',e.sta) = ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) GROUP BY valeur, mois ORDER BY mois, valeur ASC";
    private static final String REQUETE_EVENEMENT_TRI_LISTE = "SELECT * FROM prism.evenement_tri_liste WHERE code_nature = ? ORDER BY ordre_tri DESC";
    private static final String REQUETE_EVENEMENT_TRI_LISTE_COMPLET = "SELECT * FROM prism.evenement_tri_liste ORDER BY code_nature, ordre_tri DESC";
    private static final String REQUETE_GET_PATROUILLE_SEMAINE = "SELECT EXTRACT(ISOYEAR FROM p.debut) as annee, EXTRACT(WEEK FROM p.debut) numSemaine, COUNT(DISTINCT(p.id)) nbPatrouille, u.centre, u.delegation FROM mcig m, utilisateur u, vh.evenement_vh vh , patrouille p WHERE p.type = 0 AND p.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND debut BETWEEN ? AND ? AND (p.fin - p.debut) > INTERVAL '10 minutes' AND vh.id_patrouille = p.id AND u.centre != 'null' AND u.delegation != 'null' AND vh.etat = 1 AND vh.longueur >= 1000 GROUP BY annee, numSemaine, u.centre, u.delegation ORDER BY annee ASC, numSemaine ASC, u.delegation ASC, u.centre ASC";
    private static final String REQUETE_GET_EVENEMENT_SEMAINE_CLOTURES = "SELECT EXTRACT(ISOYEAR FROM e.inp) as annee, EXTRACT(WEEK FROM e.inp) numSemaine, COUNT(DISTINCT(e.snm,e.erf)) nb_evt_clotures,  e2.cei as centre, e2.district as delegation FROM evenement e, evenement e2 WHERE  e.fin = 'Y' AND e.can != 'Y' AND e.inp BETWEEN ? AND ? AND e2.cei != 'null' AND e2.district != 'null' AND e.dob IN (SELECT code FROM nature_perso WHERE code_module_metier = 0 OR code_module_metier = 5)  AND e2.snm = e.snm AND e2.erf = e.erf AND e2.vnm = 1 AND e2.can != 'Y' GROUP BY annee, numSemaine, e2.cei, e2.district ORDER BY annee ASC, numSemaine ASC, e2.district ASC, e2.cei ASC";
    private static final String REQUETE_GET_EVENEMENT_SEMAINE_CREES = "SELECT EXTRACT(ISOYEAR FROM e.sta) as annee, EXTRACT(WEEK FROM e.sta) numSemaine, COUNT(DISTINCT(e.snm,e.erf)) nb_evt_crees, e.cei as centre, e.district as delegation FROM evenement e WHERE  e.vnm = 1 AND e.can != 'Y' AND e.sta BETWEEN ? AND ? AND e.cei != 'null' AND e.district != 'null' AND e.dob IN (SELECT code FROM nature_perso WHERE code_module_metier = 0 OR code_module_metier = 5) GROUP BY annee, numSemaine, e.cei, e.district ORDER BY annee ASC, numSemaine ASC, e.district ASC, e.cei ASC";
    private static final String REQUETE_GET_PATROUILLES_FROM_KEVENTID = "SELECT p.id, p.debut, p.fin, p.equipier, e.k_eventid FROM patrouille p, evenement e WHERE e.k_eventid = ANY(?) AND e.id_patrouille = p.id";
    private String champsCloture;
    private String valeursCloture;
    private String champsUrgence;
    private String valeursUrgence;
    private String champsProgramme;
    private String valeursProgramme;
    private boolean clotureDefinitiveActivee;

    public EvenementsDAOJDBC(DAOFactory daoFactory, IReferentielDAO referentiel, IUserDAO user, IMcigDAO mcig) {
        this.daoFactory = daoFactory;
        this.referentiel = referentiel;
        this.user = user;
        this.mcig = mcig;
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(0);
        this.nf.setMaximumFractionDigits(0);
        this.nf.setMinimumIntegerDigits(3);
        this.champsCloture = (String)referentiel.getConfiguration().get((Object)"evenement.champ.cloture.nom");
        this.valeursCloture = (String)referentiel.getConfiguration().get((Object)"evenement.champ.cloture.valeur");
        this.champsProgramme = (String)referentiel.getConfiguration().get((Object)"evenement.champ.programme.nom");
        this.valeursProgramme = (String)referentiel.getConfiguration().get((Object)"evenement.champ.programme.valeur");
        this.champsUrgence = (String)referentiel.getConfiguration().get((Object)"evenement.champ.urgence.nom");
        this.valeursUrgence = (String)referentiel.getConfiguration().get((Object)"evenement.champ.urgence.valeur");
        this.clotureDefinitiveActivee = referentiel.getConfiguration().getBoolean("evenement.champ.cloture.definitive", true);
        this.verificationCodeEvenement();
    }

    private List<FiltreJavaSituation> getFiltresSituation(IBusinessService.EvenementFiltre f) {
        ArrayList<FiltreJavaSituation> filtresSituation = new ArrayList<FiltreJavaSituation>();
        if (f.ddp > -1) {
            filtresSituation.add((FiltreJavaSituation)new FiltreJavaSituationDDP(this.referentiel.getNatureMap(), f.ddp == 1, "oui"));
        }
        return filtresSituation;
    }

    private String getTablesEvenements() {
        String from = " FROM prism.evenement evt  JOIN prism.utilisateur u ON evt.id_utilisateur=u.id_utilisateur  JOIN prism.utilisateur u2 ON evt.id_createur=u2.id_utilisateur  JOIN prism.nature_perso n ON evt.nature=n.code ";
        if (this.isDynamicUA()) {
            from = from + " LEFT OUTER JOIN prism.centre_rattachement c1 on c1.nom = evt.cei LEFT OUTER JOIN prism.centre_rattachement c2 on c2.nom = u.centre ";
        }
        return from;
    }

    @Override
    public List<Situation> getEvenements(IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) throws DAOException {
        List<Situation> list;
        block8: {
            Connection connection = this.daoFactory.getConnection();
            try {
                list = this.getEvenements(connection, filtreSql, filtresJava);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            connection.close();
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Situation> getEvenements(Connection connection, IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) throws DAOException {
        long time1 = new Date().getTime();
        Log.debug("Debut");
        Map<Integer, Map<String, String>> attributs = this.chargerTousAttributs(connection, filtreSql);
        Log.debug("chargerTousAttributs");
        Set<String> publies = this.chargerErfEvenementPubliees(connection);
        Log.debug("chargerErfEvenementPubliees");
        PreparedStatement pstm = null;
        ResultSet rs = null;
        List<FiltreJavaSituation> filtresSituation = this.getFiltresSituation(filtreSql);
        String requete = "SELECT k_eventid as \"id\", snm as \"id_situation\", erf as \"id_reference\",code_evenement, dob as \"code_nature\", vnm as \"version\", sta as \"date_creation\", sto as  \"date_fin\", inp as \"date_version\",ari as \"urgence\", u.sna as \"code_utilisateur\",id_createur as \"id_createur\", erreur, description, fin, can, forevent, cei,district,lnp,nlq,direction,commentaireinterne,donneescomplementaires,programme,positionbretelle,valope,  prdeb,prfin,distanceprdeb,distanceprfin,sens,route,commune,que as \"longueur\", lu,ST_Transform(coordonnees,4326) as coordonnees, ";
        if (filtreSql.photos) {
            requete = requete + "photos, ";
        }
        if (filtreSql.geom) {
            requete = requete + "ST_Transform(listecoordonnees,4326) as geom, ";
        }
        requete = requete + "adresse_debut,adresse_fin,typeevenement, mcig_id " + this.getTablesEvenements() + " WHERE u.mse=? and n.active = '1' ";
        requete = requete + this.getFiltreEvenement(filtreSql);
        requete = requete + " ORDER BY id_situation,date_creation DESC, vnm asc";
        Log.debug("requete : " + requete);
        List<Situation> evenements = null;
        try {
            long time1a = new Date().getTime();
            long time2a = new Date().getTime();
            Log.debug("connexion en " + (time2a - time1a) + " ms");
            pstm = connection.prepareStatement(requete);
            this.miseAJourPreparedStatement(connection, pstm, filtreSql);
            Log.debug("# requete evenements # " + pstm);
            long time2 = new Date().getTime();
            Log.debug("requete cr\u00e9ee en " + (time2 - time1) + " ms");
            long time1b = new Date().getTime();
            rs = pstm.executeQuery();
            long time2b = new Date().getTime();
            Log.debug("execution requete en " + (time2b - time1b) + " ms");
            evenements = new ArrayList<Situation>();
            Situation current = null;
            time1 = new Date().getTime();
            while (rs.next()) {
                Evenement e = new Evenement();
                int keventid = rs.getInt("id");
                e.setkEventid(keventid);
                e.setCodeUtilisateur(rs.getString("code_utilisateur"));
                e.setIdCreateur(rs.getInt("id_createur"));
                Timestamp dateCreation = rs.getTimestamp("date_creation");
                e.setDateCreation(dateCreation.getTime());
                Timestamp dateMaj = rs.getTimestamp("date_version");
                e.setDateMaj(dateMaj.getTime());
                Timestamp dateFin = rs.getTimestamp("date_fin");
                e.setDateFin(dateFin.getTime());
                String err = rs.getString("erreur");
                if (err == null) {
                    e.setEtat(2);
                } else {
                    e.setErreur(err);
                    e.setEtat(3);
                }
                e.setIdReference(rs.getString("id_reference"));
                e.setIdSituation(rs.getString("id_situation"));
                e.setCodeEvenement(rs.getString("code_evenement"));
                e.setNumVersion(rs.getInt("version"));
                e.setCei(rs.getString("cei"));
                e.setDistrict(rs.getString("district"));
                e.setPublie(publies.contains(e.getIdReference()));
                e.setPrevisionnel(!rs.getString("forevent").equals("N"));
                if (filtreSql.photos) {
                    Array photoArray = rs.getArray("photos");
                    if (photoArray != null) {
                        String[] photos = (String[])photoArray.getArray();
                        ArrayList<String> photosList = new ArrayList<String>();
                        photosList.addAll(Arrays.asList(photos));
                        e.setPhotos(photosList);
                    } else {
                        e.setPhotos(new ArrayList());
                    }
                } else {
                    e.setPhotos(new ArrayList());
                }
                e.setTermine("Y".equals(rs.getString("fin")));
                e.setAnnule("Y".equals(rs.getString("can")));
                e.setLu("1".equals(rs.getString("lu")));
                e.setProgramme("1".equals(rs.getString("programme")));
                e.setType(rs.getInt("typeevenement"));
                e.setUrgence(rs.getInt("urgence"));
                e.setTraite(GLS.getBoolean((int)rs.getInt("valope"), (boolean)false));
                MainCourante mainCourante = new MainCourante();
                mainCourante.setId(rs.getString("mcig_id"));
                e.setMainCourante(mainCourante);
                String codeNature = rs.getString("code_nature");
                Nature nat = (Nature)DeepCopy.copy((Object)this.referentiel.getNatureMap().get(codeNature));
                this.chargerChampsEvenement(e, keventid, nat, codeNature, rs, attributs.get(keventid), filtreSql.cible);
                boolean aAjouter = true;
                if (filtresJava != null) {
                    for (FiltreJava filtre : filtresJava) {
                        if (filtre == null || !GLS.estVideOuEgale((String)filtre.getNatureNom(), (String)codeNature) || filtre.accept(e)) continue;
                        aAjouter = false;
                        break;
                    }
                }
                if (!aAjouter) continue;
                if (current == null || !current.getSid().equals(e.getIdSituation())) {
                    if (current != null) {
                        evenements.add(current);
                    }
                    current = new Situation(e.getIdSituation());
                }
                current.addEvenement(e);
            }
            time2 = new Date().getTime();
            Log.debug("recuperation resultats en " + (time2 - time1) + " ms");
            rs.close();
            if (current != null) {
                evenements.add(current);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
                catch (Exception e2) {
                    Log.error("", e2);
                    throw new DAOException(e2);
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        if (filtreSql.evenementAssocies) {
            evenements = this.ajouterEvenementAssocies(connection, evenements, filtreSql, filtresJava);
        }
        if (filtreSql.publies != -1) {
            evenements = this.filtrerPublies(evenements, publies, filtreSql.publies);
        }
        if (filtreSql.route != null && filtreSql.prDeb != null) {
            evenements = this.filtrerPr(evenements, GLS.getInt((String)filtreSql.prDeb), GLS.getInt((String)filtreSql.prFin));
        }
        if (!GLS.estVide((List)filtreSql.categories)) {
            evenements = this.filtrerCategories(evenements, filtreSql.categories);
        }
        if (filtresSituation != null && filtresSituation.size() > 0) {
            evenements = this.filtrerSituations(evenements, filtresSituation);
        }
        System.out.println("filtreSql.operation : " + filtreSql.operation);
        if (filtreSql.operation != null) {
            evenements = this.filtrerOperations(evenements, filtreSql.operation);
        }
        if (filtreSql.recalculAffectationTerritoire) {
            this.recalculAffectationTerritoireEvenement(evenements);
        }
        return evenements;
    }

    private String getNomOperation(Evenement e) {
        ValeurChampTexte champOperation;
        try {
            champOperation = (ValeurChampTexte)MetierCommun.getValeurChamp((Evenement)e, (String)"nomOperation");
        }
        catch (Exception ex) {
            champOperation = null;
        }
        if (champOperation != null && !MetierCommun.estVide((String)champOperation.getValeur())) {
            return champOperation.getValeur();
        }
        return null;
    }

    private void recalculAffectationTerritoireEvenement(List<Situation> evenements) {
        for (Situation s : evenements) {
            for (Evenement evt : s.getEvenements()) {
                Utilisateur u = new Utilisateur();
                InfoTerritoire inf = new InfoTerritoire();
                u.setCentre(evt.getCei());
                u.setDelegation(evt.getDistrict());
                inf.setCentre(evt.getCei());
                inf.setDelegation(evt.getDistrict());
                inf = this.getTerritoireEvenement(evt, evt, (IUtilisateur)u, inf, false);
                evt.setCei(inf.getCentre());
                evt.setDistrict(inf.getDelegation());
            }
        }
    }

    private List<Situation> filtrerOperations(List<Situation> situations, String operation) {
        List<Object> situationsFiltrees = new ArrayList<Situation>();
        HashMap<Integer, String> evtDejaTraite = new HashMap<Integer, String>();
        TreeMap listeOperations = new TreeMap();
        for (Situation s : situations) {
            for (Evenement e : s.getEvenements()) {
                String nomOperation = this.getNomOperation(e);
                if (evtDejaTraite.get(e.getkEventid()) == null) {
                    Situation sit = new Situation(s.getSid(), s.getEvenements());
                    sit.setEvenementPrincipal(e);
                    situationsFiltrees.add(sit);
                    if (!GLS.estVide((String)nomOperation)) {
                        if (!listeOperations.containsKey(nomOperation)) {
                            listeOperations.put(nomOperation, new ArrayList());
                        }
                        ((ArrayList)listeOperations.get(nomOperation)).add(sit);
                    }
                    evtDejaTraite.put(e.getkEventid(), e.getCodeEvenement());
                    continue;
                }
                Log.debug("D\u00e9j\u00e0 dans la liste " + e.getCodeEvenement());
            }
        }
        if (!GLS.estVide((String)operation) && listeOperations.containsKey(operation)) {
            situationsFiltrees = (List)listeOperations.get(operation);
        }
        return situationsFiltrees;
    }

    private List<Situation> filtrerSituations(List<Situation> situations, List<FiltreJavaSituation> filtresSituation) {
        ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
        for (Situation s : situations) {
            if (!this.ajouterSituation(s, filtresSituation)) continue;
            situationsFiltrees.add(s);
        }
        return situationsFiltrees;
    }

    private List<Situation> filtrerPublies(List<Situation> situations, Set<String> publies, int etatPublication) {
        ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
        for (Situation s : situations) {
            Situation s1 = new Situation(s.getSid());
            for (Evenement e : s.getEvenements()) {
                boolean publie = publies.contains(e.getIdReference());
                if ((!publie || etatPublication != 1) && (publie || etatPublication != 0)) continue;
                s1.addEvenement(e);
            }
            if (GLS.estVide((List)s1.getEvenements())) continue;
            situationsFiltrees.add(s1);
        }
        return situationsFiltrees;
    }

    private List<Situation> filtrerPr(List<Situation> situations, int prDebut, int prFin) {
        if (prDebut != -1) {
            boolean prFinValide = prFin != -1 && prFin >= prDebut;
            ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
            for (Situation s : situations) {
                Situation s1 = new Situation(s.getSid());
                for (Evenement e : s.getEvenements()) {
                    if (!prFinValide) {
                        if (e.getLocalisation().getPrDebut() != prDebut) continue;
                        s1.addEvenement(e);
                        continue;
                    }
                    if (e.getLocalisation().getPrDebut() < prDebut || e.getLocalisation().getPrDebut() > prFin) continue;
                    s1.addEvenement(e);
                }
                if (GLS.estVide((List)s1.getEvenements())) continue;
                situationsFiltrees.add(s1);
            }
            return situationsFiltrees;
        }
        return situations;
    }

    private List<Situation> filtrerCategories(List<Situation> situations, List<String> categories) {
        if (!GLS.estVide(categories)) {
            ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
            for (Situation s : situations) {
                Situation s1 = new Situation(s.getSid());
                for (Evenement e : s.getEvenements()) {
                    if (!GLS.estDansLaListe(categories, (Object)e.getLocalisation().getCategorie())) continue;
                    s1.addEvenement(e);
                }
                if (GLS.estVide((List)s1.getEvenements())) continue;
                situationsFiltrees.add(s1);
            }
            return situationsFiltrees;
        }
        return situations;
    }

    private List<String> getNumeroSituation(List<Situation> situations) {
        ArrayList<String> l = new ArrayList<String>();
        for (Situation s : situations) {
            l.add(s.getSid());
        }
        return l;
    }

    private List<Situation> ajouterEvenementAssocies(Connection connection, List<Situation> situations, IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) {
        HashMap<String, Situation> sits = new HashMap<String, Situation>(situations.size());
        ArrayList<String> l = new ArrayList<String>();
        for (Situation s : situations) {
            sits.put(s.getSid(), s);
            l.add(s.getSid());
        }
        IBusinessService.EvenementFiltre f = (IBusinessService.EvenementFiltre)DeepCopy.copy((Object)filtreSql);
        f.evenementAssocies = false;
        f.idSituations = l;
        f.exclureModuleMetierEtNature = true;
        f.ddp = -1;
        f.previsionnels = -1;
        f.annules = 0;
        f.programme = -1;
        f.termines = -1;
        f.dateMin = null;
        f.dateMax = null;
        f.dateInsertion = null;
        f.code = null;
        List<Situation> evenementsAssocies = this.getEvenements(connection, f, filtresJava);
        boolean found = false;
        for (Situation s : evenementsAssocies) {
            Situation s2 = (Situation)sits.get(s.getSid());
            for (Evenement e : s.getEvenements()) {
                found = false;
                for (Evenement e2 : s2.getEvenements()) {
                    if (!e2.getIdReference().equals(e.getIdReference())) continue;
                    found = true;
                }
                if (found) continue;
                e.setEvenementPrincipalHorsFiltre(true);
                s2.addEvenement(e);
            }
        }
        return GLS.getListe(sits.values().iterator());
    }

    private boolean ajouterSituation(Situation s, List<FiltreJavaSituation> filtresSituation) {
        boolean ajouterSituation = true;
        if (filtresSituation != null) {
            for (FiltreJavaSituation filtre : filtresSituation) {
                if (filtre.accept(s)) continue;
                ajouterSituation = false;
                break;
            }
        }
        return ajouterSituation;
    }

    private Set<String> chargerErfEvenementPubliees(Connection connection) {
        HashSet<String> erfs = new HashSet<String>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = connection.prepareStatement("SELECT p.erf FROM prism.publication_evt p");
            rs = pstm.executeQuery();
            while (rs.next()) {
                erfs.add(rs.getString("erf"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return erfs;
    }

    private String getFiltreEvenement(IBusinessService.EvenementFiltre filtreSql) {
        String requete = "";
        String tableEvenement = "";
        String tableNature = "";
        if (filtreSql.idEvenement != null) {
            requete = requete + " AND k_eventid=ANY(?)";
        }
        if (filtreSql.etat != -1) {
            requete = requete + " AND etat=?";
        }
        if (filtreSql.termines == 0) {
            requete = requete + " AND fin IS NULL";
        }
        if (filtreSql.termines == 1) {
            requete = requete + " AND fin='Y'";
        }
        if (filtreSql.annules == 1) {
            requete = requete + " AND can='Y'";
        }
        if (filtreSql.annules == 0) {
            requete = requete + " AND can='N'";
        }
        if (filtreSql.idUtilisateur != -1) {
            requete = requete + " AND u.id_utilisateur=?";
        }
        if (filtreSql.idPatrouille != null) {
            requete = filtreSql.vnmMax ? requete + " AND evt.snm in (select evt2.snm from evenement evt2 WHERE id_patrouille = ?)" : requete + " AND id_patrouille=?";
            if (filtreSql.creeParPatrouille) {
                requete = requete + " AND sta BETWEEN (SELECT debut FROM patrouille WHERE id = ?) AND (SELECT fin FROM patrouille WHERE id = ?)";
            }
        }
        if (filtreSql.exclureModuleMetierEtNature) {
            if (filtreSql.nature != null) {
                requete = requete + " AND " + tableEvenement + "nature!=ANY(?)";
            }
            if (filtreSql.descriptions != null) {
                requete = requete + " AND " + tableEvenement + "phr!=ANY(?)";
            }
            if (!MetierCommun.estVide((List)filtreSql.codeModuleMetier)) {
                requete = requete + " AND " + tableNature + "code_module_metier!=ANY(?)";
            }
        } else {
            if (filtreSql.nature != null) {
                requete = requete + " AND " + tableEvenement + "nature=ANY(?)";
            }
            if (filtreSql.descriptions != null) {
                requete = requete + " AND " + tableEvenement + "phr=ANY(?)";
            }
            if (!MetierCommun.estVide((List)filtreSql.codeModuleMetier)) {
                requete = requete + " AND " + tableNature + "code_module_metier=ANY(?)";
            }
        }
        if (filtreSql.route != null) {
            requete = requete + " AND UPPER(route)=UPPER(?)";
        }
        if (filtreSql.sid != null) {
            requete = requete + " AND snm=?";
        }
        requete = requete + this.getFiltreCei(filtreSql);
        if (filtreSql.erf != null) {
            requete = requete + " AND erf=?";
        }
        if (filtreSql.filtreSurDateSta && filtreSql.etat == -1) {
            if (filtreSql.dateMin != null) {
                requete = requete + " AND sta >= ?";
            }
            if (filtreSql.dateMax != null) {
                requete = requete + " AND sta <= ?";
            }
        } else if (filtreSql.etat == -1 && filtreSql.dateMin != null && filtreSql.dateMax != null) {
            requete = requete + " AND (evt.erf, evt.vnm) IN (SELECT evt2.erf, MAX(evt2.vnm) FROM evenement evt2 WHERE (NOT((evt2.sta > ?) OR (evt2.sto < ?))) GROUP BY evt2.erf)";
        } else {
            if (filtreSql.dateMin != null) {
                requete = requete + " AND sta >= ?";
            }
            if (filtreSql.dateMax != null) {
                requete = requete + " AND sta <= ?";
            }
        }
        if (filtreSql.dateInsertion != null) {
            requete = requete + " AND mst >= ?";
        }
        if (filtreSql.dateMaj != null) {
            requete = requete + " AND inp >= ?";
        }
        if (filtreSql.vnm > 0) {
            requete = requete + " AND vnm = ?";
        }
        if (filtreSql.programme == 1) {
            requete = requete + " AND programme = '1'";
        } else if (filtreSql.programme == 0) {
            requete = requete + " AND programme <> '1'";
        }
        if (filtreSql.idSituations != null) {
            requete = requete + " AND snm=ANY(?)";
        }
        if (filtreSql.idCircuit != null) {
            requete = requete + " AND (not id_patrouille is null and id_patrouille in (select p.id from patrouille p where p.id = id_patrouille and id_circuit = ?)) ";
        }
        if (filtreSql.distance > 0 && filtreSql.point != null && filtreSql.point.getX() != 0.0f && filtreSql.point.getY() != 0.0f) {
            requete = requete + " AND st_distance(coordonnees, st_GeomfromText(?," + ConfigurationFactory.getInstance().get("bdd.projection") + ")) < ? ";
        }
        if (filtreSql.type > 0) {
            requete = requete + " and typeevenement = ? ";
        }
        if (!GLS.estVide((List)filtreSql.code)) {
            requete = requete + " and code_evenement = ANY(?) ";
        }
        if (!GLS.estVide((List)filtreSql.mcigId)) {
            requete = requete + " AND mcig_id=ANY(?)";
        }
        if (!GLS.estVide((List)filtreSql.exclureMcigId)) {
            requete = requete + " AND mcig_id!=ANY(?)";
        }
        if (filtreSql.previsionnels == 0) {
            requete = requete + " AND forevent='N'";
        } else if (filtreSql.previsionnels == 1) {
            requete = requete + " AND forevent='Y'";
        }
        if (!GLS.estVide((List)filtreSql.agents)) {
            requete = requete + " AND evt.erf IN (SELECT evt2.erf FROM evenement evt2 WHERE evt2.id_utilisateur = ANY(?))";
        }
        if (filtreSql.traite == 1) {
            requete = requete + " AND evt.valope = 1 ";
        } else if (filtreSql.traite == 0) {
            requete = requete + " AND evt.valope = 0 ";
        }
        if (filtreSql.astreinteSeulement) {
            String[] regles;
            String periode = this.referentiel.getConfiguration().getString("periode.hors.astreinte");
            for (String regle : regles = periode.split("\\|")) {
                String[] parties = regle.split("]");
                String jours = parties[0];
                String[] heures = parties[1].split(";");
                requete = requete + " AND (EXTRACT(ISODOW FROM sta) != EXTRACT(ISODOW FROM sto) OR";
                requete = requete + " EXTRACT(ISODOW FROM sta) != ALL (ARRAY[" + jours.replace(";", ",") + "]) OR EXTRACT(ISODOW FROM sto) != ALL (ARRAY[" + jours.replace(";", ",") + "]) OR NOT (";
                boolean first = true;
                for (String heure : heures) {
                    if (!first) {
                        requete = requete + " OR ";
                    } else {
                        first = false;
                    }
                    requete = requete + " (EXTRACT(HOUR FROM sta) >= " + heure.split("-")[0] + " AND EXTRACT (HOUR FROM sto) < " + heure.split("-")[1] + ") ";
                }
                requete = requete + "))";
            }
        }
        if (!GLS.estVide((List)filtreSql.contexteCreation)) {
            requete = requete + " AND cfi = ANY(?) ";
        }
        if (!GLS.estVide((List)filtreSql.categorieNature)) {
            requete = requete + " AND n.code_categorie = ANY(?) ";
        }
        if (!GLS.estVide((List)filtreSql.activites)) {
            requete = requete + " AND dob=ANY(?)";
        }
        if (filtreSql.avecPhotos != null) {
            requete = filtreSql.avecPhotos != false ? requete + " AND cardinality(photos) > 0 " : requete + " AND cardinality(photos) = 0 ";
        }
        if (filtreSql.dateFinDepassee) {
            requete = requete + " AND sto < now() ";
        }
        Log.debug("Filtre Evenement : " + filtreSql);
        Log.debug("Requete Evenement : " + requete);
        return requete;
    }

    private boolean isDynamicUA() {
        return this.referentiel.isDynamicUA();
    }

    private String getFiltreCei(IBusinessService.EvenementFiltre filtreSql) {
        String requete = "";
        if (this.isDynamicUA()) {
            if (filtreSql.statistiques) {
                if (filtreSql.delegation != null) {
                    requete = requete + " AND (district=?)";
                }
                if (filtreSql.centre != null) {
                    requete = requete + " AND (c1.path like ? OR (cei is null AND (c1.path like ? OR not district is null)))";
                }
            } else {
                if (filtreSql.delegation != null) {
                    requete = requete + " AND (district=? OR district is null OR u.delegation=?)";
                }
                if (filtreSql.centre != null) {
                    requete = requete + " AND (c1.path like ? OR cei is null OR c1.path like ?)";
                }
            }
        } else if (filtreSql.statistiques) {
            if (filtreSql.delegation != null) {
                requete = requete + " AND (district=?) ";
            }
            if (filtreSql.centre != null) {
                requete = requete + " AND (cei=?) ";
            }
        } else {
            if (filtreSql.delegation != null) {
                requete = requete + " AND (district=? OR district is null OR u.delegation=? OR u2.delegation=?";
                requete = filtreSql.dateInsertion != null && filtreSql.termines == -1 ? requete + " OR (u2.delegation is null and fin='Y'))" : requete + ")";
            }
            if (filtreSql.centre != null) {
                requete = requete + " AND (cei=? OR cei is null OR u.centre=? OR u2.centre=?";
                requete = filtreSql.dateInsertion != null && filtreSql.termines == -1 ? requete + " OR (u2.centre is null and fin='Y'))" : requete + ")";
            }
        }
        if (filtreSql.exclureLocalisationIntervention) {
            requete = " AND (n.code_module_metier = 5 OR (n.code_module_metier <> 5 " + requete + "))";
        }
        return requete;
    }

    private void miseAJourPreparedStatement(Connection connection, PreparedStatement pstm, IBusinessService.EvenementFiltre filtreSql) throws SQLException {
        Array a;
        boolean notStatAndNotDynamicUA;
        Array a2;
        String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
        pstm.setString(1, zr);
        int indexParam = 2;
        if (filtreSql.idEvenement != null) {
            a2 = connection.createArrayOf("int", filtreSql.idEvenement.toArray());
            pstm.setArray(indexParam, a2);
            ++indexParam;
        }
        if (filtreSql.etat != -1) {
            pstm.setInt(indexParam, filtreSql.etat);
            ++indexParam;
        }
        if (filtreSql.idUtilisateur != -1) {
            pstm.setInt(indexParam, filtreSql.idUtilisateur);
            ++indexParam;
        }
        if (filtreSql.idPatrouille != null) {
            pstm.setString(indexParam, filtreSql.idPatrouille);
            ++indexParam;
            if (filtreSql.creeParPatrouille) {
                pstm.setString(indexParam, filtreSql.idPatrouille);
                pstm.setString(++indexParam, filtreSql.idPatrouille);
                ++indexParam;
            }
        }
        if (filtreSql.nature != null) {
            a2 = connection.createArrayOf("text", filtreSql.nature.toArray());
            pstm.setArray(indexParam, a2);
            ++indexParam;
        }
        if (filtreSql.descriptions != null) {
            a2 = connection.createArrayOf("text", filtreSql.descriptions.toArray());
            pstm.setArray(indexParam, a2);
            ++indexParam;
        }
        if (!MetierCommun.estVide((List)filtreSql.codeModuleMetier)) {
            a2 = connection.createArrayOf("int", filtreSql.codeModuleMetier.toArray());
            pstm.setArray(indexParam, a2);
            ++indexParam;
        }
        if (filtreSql.route != null) {
            pstm.setString(indexParam, filtreSql.route);
            ++indexParam;
        }
        if (filtreSql.sid != null) {
            pstm.setString(indexParam, filtreSql.sid);
            ++indexParam;
        }
        boolean bl = notStatAndNotDynamicUA = !filtreSql.statistiques && !this.isDynamicUA();
        if (filtreSql.delegation != null) {
            pstm.setString(indexParam, filtreSql.delegation);
            ++indexParam;
            if (!filtreSql.statistiques) {
                pstm.setString(indexParam, filtreSql.delegation);
                ++indexParam;
            }
            if (notStatAndNotDynamicUA) {
                pstm.setString(indexParam, filtreSql.delegation);
                ++indexParam;
            }
        }
        if (filtreSql.centre != null) {
            String cei = this.isDynamicUA() ? DAOUtil.getValeurFiltreCeiDynamique(filtreSql.centre) : filtreSql.centre;
            pstm.setString(indexParam, cei);
            ++indexParam;
            if (!filtreSql.statistiques) {
                pstm.setString(indexParam, cei);
                ++indexParam;
            }
            if (notStatAndNotDynamicUA) {
                pstm.setString(indexParam, cei);
                ++indexParam;
            }
        }
        if (filtreSql.erf != null) {
            pstm.setString(indexParam, filtreSql.erf);
            ++indexParam;
        }
        if (filtreSql.filtreSurDateSta && filtreSql.etat == -1) {
            if (filtreSql.dateMin != null) {
                pstm.setTimestamp(indexParam, filtreSql.dateMin);
                ++indexParam;
            }
            if (filtreSql.dateMax != null) {
                pstm.setTimestamp(indexParam, filtreSql.dateMax);
                ++indexParam;
            }
        } else if (filtreSql.etat == -1 && filtreSql.dateMin != null && filtreSql.dateMax != null) {
            pstm.setTimestamp(indexParam, filtreSql.dateMax);
            pstm.setTimestamp(++indexParam, filtreSql.dateMin);
            ++indexParam;
        } else {
            if (filtreSql.dateMin != null) {
                pstm.setTimestamp(indexParam, filtreSql.dateMin);
                ++indexParam;
            }
            if (filtreSql.dateMax != null) {
                pstm.setTimestamp(indexParam, filtreSql.dateMax);
                ++indexParam;
            }
        }
        if (filtreSql.dateInsertion != null) {
            pstm.setTimestamp(indexParam, filtreSql.dateInsertion);
            ++indexParam;
        }
        if (filtreSql.dateMaj != null) {
            pstm.setTimestamp(indexParam, filtreSql.dateMaj);
            ++indexParam;
        }
        if (filtreSql.vnm > 0) {
            pstm.setInt(indexParam, filtreSql.vnm);
            ++indexParam;
        }
        if (filtreSql.idSituations != null) {
            a = connection.createArrayOf("text", filtreSql.idSituations.toArray());
            pstm.setArray(indexParam, a);
            ++indexParam;
        }
        if (filtreSql.idCircuit != null) {
            pstm.setInt(indexParam, GLS.getInt((String)filtreSql.idCircuit));
            ++indexParam;
        }
        if (filtreSql.distance > 0 && filtreSql.point != null && filtreSql.point.getX() != 0.0f && filtreSql.point.getY() != 0.0f) {
            pstm.setString(indexParam++, SQL.getGeometryPointUTM((double)filtreSql.point.getX(), (double)filtreSql.point.getY()));
            pstm.setInt(indexParam++, filtreSql.distance);
        }
        if (filtreSql.type > 0) {
            pstm.setInt(indexParam++, filtreSql.type);
        }
        if (!GLS.estVide((List)filtreSql.code)) {
            a = connection.createArrayOf("text", filtreSql.code.toArray());
            pstm.setArray(indexParam++, a);
        }
        if (!GLS.estVide((List)filtreSql.mcigId)) {
            a = connection.createArrayOf("text", filtreSql.mcigId.toArray());
            pstm.setArray(indexParam++, a);
        }
        if (!GLS.estVide((List)filtreSql.exclureMcigId)) {
            a = connection.createArrayOf("text", filtreSql.exclureMcigId.toArray());
            pstm.setArray(indexParam++, a);
        }
        if (!GLS.estVide((List)filtreSql.agents)) {
            a = connection.createArrayOf("int", filtreSql.agents.toArray());
            pstm.setArray(indexParam++, a);
        }
        if (!GLS.estVide((List)filtreSql.contexteCreation)) {
            a = connection.createArrayOf("int", filtreSql.contexteCreation.toArray());
            pstm.setArray(indexParam, a);
            ++indexParam;
        }
        if (!GLS.estVide((List)filtreSql.categorieNature)) {
            a = connection.createArrayOf("text", filtreSql.categorieNature.toArray());
            pstm.setArray(indexParam, a);
            ++indexParam;
        }
        if (!GLS.estVide((List)filtreSql.activites)) {
            a = connection.createArrayOf("text", filtreSql.activites.toArray());
            pstm.setArray(indexParam, a);
            ++indexParam;
        }
    }

    private Map<Integer, Map<String, String>> chargerTousAttributs(Connection connection, IBusinessService.EvenementFiltre filtre) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String requete = "SELECT k_eventid as \"id\",champ,valeur FROM prism.attribut_evenement WHERE k_eventid IN (SELECT k_eventid " + this.getTablesEvenements() + " WHERE u.mse=? and n.active = '1' ";
        requete = requete + this.getFiltreEvenement(filtre);
        requete = requete + " )";
        HashMap<Integer, Map<String, String>> attributs = null;
        try {
            pstm = connection.prepareStatement(requete);
            this.miseAJourPreparedStatement(connection, pstm, filtre);
            Log.debug("# requete charger tous attributs # " + pstm);
            rs = pstm.executeQuery();
            attributs = new HashMap<Integer, Map<String, String>>();
            while (rs.next()) {
                Map<String, String> map;
                int keventid = rs.getInt("id");
                if (attributs.containsKey(keventid)) {
                    map = (Map)attributs.get(keventid);
                } else {
                    map = new HashMap();
                    attributs.put(keventid, map);
                }
                map.put(rs.getString("champ"), rs.getString("valeur"));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return attributs;
    }

    private Map<Integer, Map<String, String>> chargerTousAttributsASynchroniserDatex2(IBusinessService.EvenementFiltre filtre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String requete = "SELECT k_eventid as \"id\",champ,valeur FROM prism.attribut_evenement WHERE k_eventid IN (SELECT k_eventid FROM prism.evenement  JOIN prism.utilisateur ON evenement.id_utilisateur=utilisateur.id_utilisateur WHERE utilisateur.mse=? and evenement.k_eventid in (select k_eventid from datex2.synchro_evenement where zone_routiere = ? order by inp asc)";
        if (filtre.descriptions != null) {
            requete = requete + " AND phr=ANY(?)";
        }
        if (filtre.etat != -1) {
            requete = requete + " AND etat=?";
        }
        if (filtre.termines == 0) {
            requete = requete + " AND fin IS NULL";
        }
        if (filtre.termines == 1) {
            requete = requete + " AND fin='Y'";
        }
        if (filtre.idUtilisateur != -1) {
            requete = requete + " AND utilisateur.id_utilisateur=?";
        }
        if (filtre.nature != null) {
            requete = requete + " AND nature=ANY(?)";
        }
        if (filtre.route != null) {
            requete = requete + " AND UPPER(route)=UPPER(?)";
        }
        if (filtre.sid != null) {
            requete = requete + " AND snm=?";
        }
        if (filtre.delegation != null) {
            requete = requete + " AND district=?";
        }
        if (filtre.centre != null) {
            requete = requete + " AND cei=?";
        }
        if (filtre.erf != null) {
            requete = requete + " AND erf=?";
        }
        if (filtre.dateMin != null) {
            requete = requete + " AND sta >= ?";
        }
        if (filtre.dateMax != null) {
            requete = requete + " AND sta <= ?";
        }
        if (filtre.dateInsertion != null) {
            requete = requete + " AND mst >= ?";
        }
        requete = requete + " )";
        HashMap<Integer, Map<String, String>> attributs = null;
        try {
            Array a;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
            pstm.setString(1, zr);
            pstm.setString(2, zr);
            int indexParam = 3;
            if (filtre.descriptions != null) {
                a = connection.createArrayOf("text", filtre.descriptions.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
            }
            if (filtre.etat != -1) {
                pstm.setInt(indexParam, filtre.etat);
                ++indexParam;
            }
            if (filtre.idUtilisateur != -1) {
                pstm.setInt(indexParam, filtre.idUtilisateur);
                ++indexParam;
            }
            if (filtre.nature != null) {
                a = connection.createArrayOf("text", filtre.nature.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
            }
            if (filtre.route != null) {
                pstm.setString(indexParam, filtre.route);
                ++indexParam;
            }
            if (filtre.sid != null) {
                pstm.setString(indexParam, filtre.sid);
                ++indexParam;
            }
            if (filtre.delegation != null) {
                pstm.setString(indexParam, filtre.delegation);
                ++indexParam;
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam, filtre.centre);
                ++indexParam;
            }
            if (filtre.erf != null) {
                pstm.setString(indexParam, filtre.erf);
                ++indexParam;
            }
            if (filtre.dateMin != null) {
                pstm.setTimestamp(indexParam, filtre.dateMin);
                ++indexParam;
            }
            if (filtre.dateMax != null) {
                pstm.setTimestamp(indexParam, filtre.dateMax);
                ++indexParam;
            }
            if (filtre.dateInsertion != null) {
                pstm.setTimestamp(indexParam, filtre.dateInsertion);
                ++indexParam;
            }
            rs = pstm.executeQuery();
            attributs = new HashMap<Integer, Map<String, String>>();
            while (rs.next()) {
                Map<String, String> map;
                int keventid = rs.getInt("id");
                if (attributs.containsKey(keventid)) {
                    map = (Map)attributs.get(keventid);
                } else {
                    map = new HashMap();
                    attributs.put(keventid, map);
                }
                map.put(rs.getString("champ"), rs.getString("valeur"));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return attributs;
    }

    private static <T> T getValueFromResultSet(ResultSet rs, String columnLabel, T defaultValue) {
        try {
            return (T)rs.getObject(columnLabel);
        }
        catch (SQLException e) {
            return defaultValue;
        }
    }

    private void chargerChampsEvenement(Evenement e, int id, Nature nat, String codeNature, ResultSet rs, Map<String, String> valeurMap, int cible) throws SQLException {
        ValeurNature valeurNature = new ValeurNature();
        valeurNature.setCode(codeNature);
        ArrayList<Object> valeurs = new ArrayList<Object>();
        if (valeurMap == null) {
            valeurMap = new HashMap<String, String>();
        }
        for (Champ c : nat.getChamps()) {
            switch (c.getNom()) {
                case "localisation": {
                    ValeurChampLocalisation loc = (ValeurChampLocalisation)c.parseValeur(valeurMap.get("localisation"));
                    LocalisantPr pr = new LocalisantPr(rs.getString("prdeb"));
                    loc.setPrDebut(pr.getPr());
                    loc.setDeptDebut(String.valueOf(pr.getDepartement()));
                    pr = new LocalisantPr(rs.getString("prfin"));
                    loc.setPrFin(pr.getPr());
                    loc.setDeptFin(String.valueOf(pr.getDepartement()));
                    loc.setDirection(rs.getString("commentaireinterne"));
                    loc.setAbsPrDebut(rs.getInt("distanceprdeb"));
                    loc.setAbsPrFin(rs.getInt("distanceprfin"));
                    loc.setSensPr(rs.getInt("sens"));
                    loc.setAxe(rs.getString("route"));
                    loc.setCommune(rs.getString("commune"));
                    loc.setLongueur(rs.getInt("longueur"));
                    loc.setAdresseDebut(rs.getString("adresse_debut"));
                    loc.setAdresseFin(rs.getString("adresse_fin"));
                    loc.setVoie(rs.getString("lnp"));
                    loc.setAccrochage(GLS.getBoolean((int)rs.getInt("nlq"), (boolean)Boolean.parseBoolean("true")));
                    loc.setComplementLocalisation(GLS.getString((String)rs.getString("direction")));
                    loc.setLocalisationParGps(true);
                    loc.setPointParticulier(rs.getInt("positionbretelle"));
                    try {
                        MapDescription carac = MetierCommun.getCaracteristiquesLocalisation((String)rs.getString("donneescomplementaires"));
                        loc.setTrafic(carac.getString("trafic", ""));
                        loc.setCategorie(carac.getString("categorie", ""));
                    }
                    catch (Exception ex1) {
                        Log.error("ERREUR CONV CARAC GET EVT", ex1);
                    }
                    PGgeometry geom = null;
                    PGgeometry point = null;
                    if (EvenementsDAOJDBC.getValueFromResultSet(rs, "geom", null) != null) {
                        geom = (PGgeometry)rs.getObject("geom");
                    }
                    if (EvenementsDAOJDBC.getValueFromResultSet(rs, "coordonnees", null) != null) {
                        point = (PGgeometry)rs.getObject("coordonnees");
                    }
                    try {
                        if (geom != null) {
                            LineString ls = (LineString)geom.getGeometry();
                            float[] x = new float[ls.getPoints().length];
                            float[] y = new float[ls.getPoints().length];
                            for (int i = 0; i < ls.getPoints().length; ++i) {
                                x[i] = (float)ls.getPoints()[i].getX();
                                y[i] = (float)ls.getPoints()[i].getY();
                                loc.setX(x);
                                loc.setY(y);
                            }
                            if (point == null) {
                                if (ls.getFirstPoint() != null && ls.getLastPoint() != null) {
                                    Position p = new Position();
                                    p.setX((float)ls.getFirstPoint().getX());
                                    p.setY((float)ls.getFirstPoint().getY());
                                    loc.setPositionDebut(p);
                                    p = new Position();
                                    p.setX((float)ls.getLastPoint().getX());
                                    p.setY((float)ls.getLastPoint().getY());
                                    loc.setPositionFin(p);
                                }
                            } else {
                                Point p1 = (Point)point.getGeometry();
                                Position p = new Position();
                                p.setX((float)p1.getX());
                                p.setY((float)p1.getY());
                                p.setAltitude((float)p1.getZ());
                                loc.setPositionDebut(p);
                                if (ls.getLastPoint() != null) {
                                    p = new Position();
                                    p.setX((float)ls.getLastPoint().getX());
                                    p.setY((float)ls.getLastPoint().getY());
                                    loc.setPositionFin(p);
                                }
                            }
                        } else if (point != null) {
                            Point p1 = (Point)point.getGeometry();
                            Position p = new Position();
                            p.setX((float)p1.getX());
                            p.setY((float)p1.getY());
                            p.setAltitude((float)p1.getZ());
                            loc.setPositionDebut(p);
                            loc.setPositionFin(p);
                        } else {
                            float[] x = new float[2];
                            float[] y = new float[2];
                            for (int i = 0; i < x.length; ++i) {
                                x[i] = 0.0f;
                                y[i] = 0.0f;
                                loc.setX(x);
                                loc.setY(y);
                            }
                            Position p = new Position();
                            p.setX(0.0f);
                            p.setY(0.0f);
                            loc.setPositionDebut(p);
                            p.setX(0.0f);
                            p.setY(0.0f);
                            loc.setPositionFin(p);
                        }
                    }
                    catch (Exception ex) {
                        Log.error("ERREUR CONV LOC GET EVT", ex);
                    }
                    valeurs.add(loc);
                    valeurNature.setLocalisation(loc);
                    break;
                }
                case "description": {
                    String valeur = rs.getString("description");
                    ValeurChampCollectionChoixUnique vc = (ValeurChampCollectionChoixUnique)c.parseValeur(valeur);
                    valeurs.add(vc);
                    valeurNature.setDescription(vc);
                    break;
                }
                default: {
                    String[] hashesSplit;
                    String hashes;
                    Log.debug("#CHARGER CHAMPS EVT " + c.getNom() + " -- document =" + c.aDocument() + " images =" + c.aImage());
                    if (c.aImage()) {
                        ValeurChampImages valeurImage = new ValeurChampImages(c.getNom());
                        hashes = valeurMap.get(c.getNom());
                        if (hashes != null) {
                            for (String hash : hashesSplit = hashes.split(";")) {
                                byte[] image = this.daoFactory.getPhotoDAO().getPhoto(hash);
                                valeurImage.addValeur(image);
                            }
                        }
                        valeurs.add(valeurImage);
                    }
                    if (c.aDocument()) {
                        ValeurChampDocuments valeurDocument = new ValeurChampDocuments(c.getNom());
                        hashes = valeurMap.get(c.getNom());
                        Log.debug("#CHARGER CHAMPS EVT ADocument ok - " + hashes);
                        if (hashes != null) {
                            hashesSplit = hashes.split(";");
                            Log.debug("#CHARGER CHAMPS EVT ADocument ok - " + hashesSplit.length);
                            for (String hash : hashesSplit) {
                                Document d = this.daoFactory.getDocumentDAO().getDocument(hash);
                                if (d.getSynchronisation() != 2 && d.getSynchronisation() != cible) {
                                    d.setContenu(null);
                                }
                                valeurDocument.addValeur(d);
                            }
                        }
                        Log.debug("#CHARGER CHAMPS EVT ADocument ok nb -" + valeurDocument.getValeurs().size());
                        valeurs.add(valeurDocument);
                        break;
                    }
                    valeurs.add(this.creerValeursChamp(c, valeurMap, cible));
                }
            }
            valeurNature.setValeurs(valeurs);
            e.setValeurNature(valeurNature);
        }
    }

    private ValeurChamp creerValeursChamp(Champ c, Map<String, String> map, int cible) {
        ValeurChampMultiple retour = null;
        if (c instanceof ChampMultiple) {
            ValeurChampMultiple valeurChampMultiple = new ValeurChampMultiple(c.getNom());
            for (Champ sousChamp : ((ChampMultiple)c).getChamps()) {
                valeurChampMultiple.getValeurs().add(this.creerValeursChamp(sousChamp, map, cible));
            }
            retour = valeurChampMultiple;
        } else {
            try {
                if (c.aImage()) {
                    ValeurChampImages valeurImage = new ValeurChampImages(c.getNom());
                    String hashes = map.get(c.getNom());
                    if (hashes != null) {
                        String[] hashesSplit;
                        for (String hash : hashesSplit = hashes.split(";")) {
                            byte[] image = this.daoFactory.getPhotoDAO().getPhoto(hash);
                            valeurImage.addValeur(image);
                        }
                    }
                    return valeurImage;
                }
                if (c.aDocument()) {
                    ValeurChampDocuments valeurDocument = new ValeurChampDocuments(c.getNom());
                    String hashes = map.get(c.getNom());
                    if (hashes != null) {
                        String[] hashesSplit;
                        for (String hash : hashesSplit = hashes.split(";")) {
                            Document d = this.daoFactory.getDocumentDAO().getDocument(hash);
                            if (d.getSynchronisation() != 2 && d.getSynchronisation() != cible) {
                                d.setContenu(null);
                            }
                            valeurDocument.addValeur(d);
                        }
                    }
                    return valeurDocument;
                }
                String valeur = map.get(c.getNom());
                retour = valeur != null ? c.parseValeur(valeur) : (ValeurChamp)DeepCopy.copy((Object)c.getValeurChamp());
            }
            catch (Exception e) {
                Log.error("", e);
            }
        }
        return retour;
    }

    @Override
    public Evenement getDernierEvenementActif(Evenement evenement) {
        if (evenement != null) {
            return this.getDernierEvenementActif(evenement.getIdSituation(), evenement.getIdReference());
        }
        return null;
    }

    public Evenement getDernierEvenementActif(Connection connection, Evenement evenement) {
        if (evenement != null) {
            return this.getDernierEvenementActif(connection, evenement.getIdSituation(), evenement.getIdReference());
        }
        return null;
    }

    @Override
    public Evenement getDernierEvenementActifAvecRecalculTerritoire(String erf) {
        Evenement evt = this.getDernierEvenementActif(null, erf);
        if (evt != null) {
            Utilisateur u = new Utilisateur();
            InfoTerritoire inf = new InfoTerritoire();
            u.setCentre(evt.getCei());
            u.setDelegation(evt.getDistrict());
            inf.setCentre(evt.getCei());
            inf.setDelegation(evt.getDistrict());
            inf = this.getTerritoireEvenement(evt, evt, (IUtilisateur)u, inf, false);
            evt.setCei(inf.getCentre());
            evt.setDistrict(inf.getDelegation());
        }
        return evt;
    }

    @Override
    public Evenement getDernierEvenementActifAvecRecalculTerritoire(Evenement evt) {
        Evenement dernierActif = this.getDernierEvenementActif(null, evt.getIdReference());
        if (evt != null) {
            Utilisateur u = new Utilisateur();
            InfoTerritoire inf = new InfoTerritoire();
            u.setCentre(evt.getCei());
            u.setDelegation(evt.getDistrict());
            inf.setCentre(evt.getCei());
            inf.setDelegation(evt.getDistrict());
            inf = this.getTerritoireEvenement(evt, dernierActif, (IUtilisateur)u, inf, false);
            evt.setCei(inf.getCentre());
            evt.setDistrict(inf.getDelegation());
        }
        return evt;
    }

    public Evenement getEvenementSuivantParDateMaj(Evenement e) {
        if (e != null) {
            Evenement evenement;
            block9: {
                Connection connection = this.daoFactory.getConnection();
                try {
                    evenement = this.getEvenementSuivantParDateMaj(connection, e);
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new DAOException(ex);
                    }
                }
                connection.close();
            }
            return evenement;
        }
        return null;
    }

    public Evenement getEvenementSuivantParDateMaj(Connection connection, Evenement e) {
        if (e != null) {
            List evts;
            IBusinessService.EvenementFiltre ef = IBusinessService.EvenementFiltre.getVersionActive((String)e.getIdSituation(), (String)e.getIdReference());
            Calendar c = GregorianCalendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            ef.dateMaj = new Timestamp(e.getDateMaj() + 1L);
            ef.etat = -1;
            List<Situation> listeSit = this.getEvenements(connection, ef, null);
            if (listeSit != null && listeSit.size() > 0 && (evts = listeSit.get(0).getEvenements()) != null && !evts.isEmpty()) {
                return (Evenement)evts.get(0);
            }
        }
        return null;
    }

    @Override
    public Evenement getDernierEvenementActif(String idSit, String idEvt) throws DAOException {
        Evenement evenement;
        block8: {
            Connection connection = this.daoFactory.getConnection();
            try {
                evenement = this.getDernierEvenementActif(connection, idSit, idEvt);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            connection.close();
        }
        return evenement;
    }

    public Evenement getDernierEvenementActif(Connection connectionInit, String idSit, String idEvt) {
        List evts;
        List<Situation> listeSit;
        if (!GLS.estVide((String)idEvt) && (listeSit = this.getEvenements(connectionInit, IBusinessService.EvenementFiltre.getVersionActive((String)idSit, (String)idEvt), null)) != null && listeSit.size() > 0 && (evts = listeSit.get(0).getEvenements()) != null && !evts.isEmpty()) {
            if (evts.size() > 1) {
                Log.error("ERREUR PLUSIEURS VERSIONS ACTIVES - " + idEvt + " - " + evts.size());
                return this.getMaxVersion(evts);
            }
            return (Evenement)evts.get(0);
        }
        return null;
    }

    public Evenement getMaxVersion(List<Evenement> evts) {
        Evenement maxVersionEvt = null;
        if (!GLS.estVide(evts)) {
            for (Evenement evt : evts) {
                if (maxVersionEvt != null && evt.getDateMaj() <= maxVersionEvt.getDateMaj()) continue;
                maxVersionEvt = evt;
            }
        }
        return maxVersionEvt;
    }

    public Evenement getMinVersion(List<Evenement> evts) {
        Evenement minVersionEvt = null;
        if (!GLS.estVide(evts)) {
            for (Evenement evt : evts) {
                if (minVersionEvt != null && evt.getDateMaj() >= minVersionEvt.getDateMaj()) continue;
                minVersionEvt = evt;
            }
        }
        return minVersionEvt;
    }

    public Evenement getPremiereVersionEvenement(Evenement evenement) throws DAOException {
        Evenement evenement2;
        block8: {
            Connection connection = this.daoFactory.getConnection();
            try {
                evenement2 = this.getPremiereVersionEvenement(connection, evenement);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            connection.close();
        }
        return evenement2;
    }

    public Evenement getPremiereVersionEvenement(Connection connectionInit, Evenement evenement) {
        List evts;
        List<Situation> listeSit;
        if (evenement != null && (listeSit = this.getEvenements(connectionInit, IBusinessService.EvenementFiltre.getPremiereVersion((String)evenement.getIdSituation(), (String)evenement.getIdReference()), null)) != null && listeSit.size() > 0 && (evts = listeSit.get(0).getEvenements()) != null && !evts.isEmpty()) {
            if (evts.size() > 1) {
                Log.error("ERREUR PLUSIEURS VERSIONS ACTIVES - " + evenement.getIdReference() + " - " + evts.size());
                return this.getMinVersion(evts);
            }
            return (Evenement)evts.get(0);
        }
        return null;
    }

    public long recupIdEvenement() throws RuntimeException {
        long l;
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        String requete = "select nextval('K_EVENTID_SEQ') as k_eventid";
        try {
            connection = this.daoFactory.getConnection();
            stm = connection.createStatement(1004, 1007);
            rs = stm.executeQuery(requete);
            long k_eventid = -1L;
            if (rs.first()) {
                k_eventid = rs.getLong("k_eventid");
            }
            rs.close();
            if (k_eventid == -1L) {
                throw new RuntimeException("Valeur de s\u00e9quence non trouv\u00e9e");
            }
            l = k_eventid;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, stm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, stm, rs);
        return l;
    }

    @Override
    public void inactivationEvenement(Evenement evenement) {
        try (Connection connection = this.daoFactory.getConnection();){
            this.inactivationEvenement(connection, evenement);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    public void inactivationEvenement(Connection connectionInit, Evenement evenement) {
        String requete = "update evenement set etat = ? where erf = ? AND snm = ?";
        PreparedStatement pstm = null;
        try {
            pstm = connectionInit.prepareStatement(requete);
            pstm.setInt(1, 0);
            pstm.setString(2, evenement.getIdReference());
            pstm.setString(3, evenement.getIdSituation());
            int ret = pstm.executeUpdate();
            Log.debug(ret + " ligne(s) mise(s) \u00e0 jour - " + requete);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(null, pstm, null);
        }
    }

    public void incrementeVNMEvenement(Evenement evenement) {
        try (Connection connection = this.daoFactory.getConnection();){
            this.incrementeVNMEvenement(connection, evenement);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    public void incrementeVNMEvenement(Connection connection, Evenement evenement) {
        String requete = "update evenement set vnm = vnm_new from evenement AS eold  LEFT JOIN (   SELECT     *, vnm+1 AS vnm_new    FROM evenement e where e.erf = ? AND e.snm = ? and e.vnm >= ?    ORDER BY vnm desc   ) AS enew using(erf, snm , vnm) \tWHERE (enew.erf, enew.snm , enew.vnm) = (eold.erf, eold.snm, eold.vnm) and  (evenement.erf, evenement.snm , evenement.vnm) = (eold.erf, eold.snm, eold.vnm) ";
        String requeteValope = "update evenement set mst = now() where erf = ? and snm = ? and etat = ? ";
        PreparedStatement pstm = null;
        try {
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, evenement.getIdReference());
            pstm.setString(2, evenement.getIdSituation());
            pstm.setInt(3, evenement.getNumVersion());
            int ret = pstm.executeUpdate();
            Log.debug(ret + " ligne(s) mise(s) \u00e0 jour - " + requete);
            DAOUtil.close(pstm);
            pstm = connection.prepareStatement(requeteValope);
            pstm.setString(1, evenement.getIdReference());
            pstm.setString(2, evenement.getIdSituation());
            pstm.setInt(3, 1);
            ret = pstm.executeUpdate();
            Log.debug(ret + " ligne(s) mise(s) \u00e0 jour - " + requeteValope);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(null, pstm, null);
        }
    }

    public void creationSituation(Situation situation, PrismCentralUser u) throws Exception {
        try (Connection connection = this.daoFactory.getConnection();){
            this.creationSituation(connection, situation, u);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    public void creationSituation(Connection connectionInit, Situation situation, PrismCentralUser u) throws Exception {
        if (this.rechercheSituation(situation.getSid()) == null) {
            PreparedStatement pstm = null;
            String requete = "insert into situation (snm, id_utilisateur) values (?,?)";
            Log.debug(requete);
            try {
                pstm = connectionInit.prepareStatement(requete);
                pstm.setString(1, situation.getSid());
                pstm.setInt(2, u.getId());
                boolean ret = pstm.execute();
                Log.debug(ret + " requete insertion situation ok ? " + pstm);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
            finally {
                DAOUtil.close(null, pstm, null);
            }
        }
    }

    public Situation rechercheSituation(String snm) throws Exception {
        Situation situation;
        Situation situation2 = null;
        String requete = "select snm, id_utilisateur from situation where snm = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, snm);
            rs = pstm.executeQuery();
            situation2 = rs.first() ? new Situation(snm) : null;
            situation = situation2;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, null);
        return situation;
    }

    public long recupVnmSuivant(Evenement dernierActif) {
        long vnm = 1L;
        if (dernierActif != null) {
            vnm = dernierActif.getNumVersion() + 1;
        }
        return vnm;
    }

    private void ajouterAttributs(HashMap<String, String> mapValeurs) {
    }

    private String getValeurAttribut(HashMap<String, String> mapValeurs, String champ, String defaut) {
        if (mapValeurs.containsKey(champ)) {
            return mapValeurs.get(champ);
        }
        return defaut;
    }

    public void sauvegardeAttributsEvenement(Evenement evt, HashMap<String, String> m) throws Exception {
        try (Connection connection = this.daoFactory.getConnection();){
            this.sauvegardeAttributsEvenement(connection, evt, m);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void sauvegardeAttributsEvenement(Connection connectionInit, Evenement e, HashMap<String, String> m) throws Exception {
        if (m != null) {
            PreparedStatement pstm = null;
            String requete = "insert into attribut_evenement (k_eventid,champ,valeur) VALUES(?,?,?)";
            pstm = connectionInit.prepareStatement(requete);
            for (String k : m.keySet()) {
                try {
                    pstm.setLong(1, e.getkEventid());
                    pstm.setString(2, k);
                    pstm.setString(3, m.get(k));
                    Log.debug("Insertion att " + pstm);
                    pstm.execute();
                    pstm.clearParameters();
                }
                catch (SQLException ex) {
                    Log.error("Erreur insertion attribut " + k + " -- " + pstm, ex);
                }
            }
            DAOUtil.close(null, pstm, null);
        }
    }

    private void sauvegardeAttributsImageEvenement(Map<String, byte[]> photosExtraitesComposant) throws Exception {
        IPhotoDAO photoDAOJDBC = this.daoFactory.getPhotoDAO();
        Set<Map.Entry<String, byte[]>> photos = photosExtraitesComposant.entrySet();
        for (Map.Entry<String, byte[]> photo : photos) {
            photoDAOJDBC.sauvegarderPhoto(photo.getKey(), photo.getValue());
        }
    }

    private void sauvegardeAttributsImageEvenement(Connection connectionInit, Map<String, byte[]> photosExtraitesComposant) throws Exception {
        IPhotoDAO photoDAOJDBC = this.daoFactory.getPhotoDAO();
        Set<Map.Entry<String, byte[]>> photos = photosExtraitesComposant.entrySet();
        for (Map.Entry<String, byte[]> photo : photos) {
            photoDAOJDBC.sauvegarderPhoto(connectionInit, photo.getKey(), photo.getValue());
        }
    }

    private void sauvegardeAttributsDocumentEvenement(Map<String, Document> documetsExtraitesComposant) throws Exception {
        IDocumentDAO documentDAOJDBC = this.daoFactory.getDocumentDAO();
        Set<Map.Entry<String, Document>> documents = documetsExtraitesComposant.entrySet();
        for (Map.Entry<String, Document> document : documents) {
            documentDAOJDBC.sauvegarderDocument(document.getKey(), document.getValue().getContenu(), document.getValue().getNom(), document.getValue().getSynchronisation());
        }
    }

    private void sauvegardeAttributsDocumentEvenement(Connection connectionInit, Map<String, Document> documetsExtraitesComposant) throws Exception {
        IDocumentDAO documentDAOJDBC = this.daoFactory.getDocumentDAO();
        Set<Map.Entry<String, Document>> documents = documetsExtraitesComposant.entrySet();
        for (Map.Entry<String, Document> document : documents) {
            documentDAOJDBC.sauvegarderDocument(connectionInit, document.getKey(), document.getValue().getContenu(), document.getValue().getNom(), document.getValue().getSynchronisation());
        }
    }

    public static boolean miseAJourDateCreationEvenement(Evenement e, Map<String, String> m) {
        String sta;
        if (m.containsKey("sta") && !MetierCommun.estVide((String)(sta = m.get("sta")))) {
            GLS.getDate();
            e.setDateCreation(GLSDate.toDate((String)sta).getTimeInMillis());
            return true;
        }
        return false;
    }

    public static boolean miseAJourDateFinEvenement(Evenement e, Map<String, String> m) {
        String dateButoir;
        if (m.containsKey("sto")) {
            String sto = m.get("sto");
            if (!MetierCommun.estVide((String)sto)) {
                GLS.getDate();
                e.setDateFin(GLSDate.toDate((String)sto).getTimeInMillis());
                return true;
            }
        } else if (!e.isTermine() && m.containsKey("datePlanification") && !MetierCommun.estVide((String)(dateButoir = m.get("datePlanification")))) {
            GLS.getDate();
            e.setDateFin(GLSDate.toDate((String)dateButoir).getTimeInMillis());
            return true;
        }
        return false;
    }

    public boolean miseAJourChampSystemeAgentsEvenement(Evenement e, Map<String, String> m) {
        if (m.containsKey("sna")) {
            StringBuffer sb = new StringBuffer();
            PrismCentralUser user = this.referentiel.getUtilisateur(e.getMainCourante().getCodeUtilisateur());
            if (user != null) {
                sb.append(user.getNom());
            }
            if (!GLS.estVide((String)e.getMainCourante().getCodeAccompagnateur())) {
                if (!GLS.estVide((String)sb.toString())) {
                    sb.append(", ");
                }
                sb.append(e.getMainCourante().getCodeAccompagnateur());
            }
            m.put("sna", sb.toString());
            return true;
        }
        if (m.containsKey("agentsTerrain") && e.getMainCourante().getIdPatrouille() != null) {
            String valeurCourante = m.get("agentsTerrain");
            ArrayList<String> l = !GLS.estVide((String)valeurCourante) ? MetierCommun.getListe((String)valeurCourante, (String)",") : new ArrayList<String>();
            PrismCentralUser user = this.referentiel.getUtilisateur(e.getMainCourante().getCodeUtilisateur());
            if (user != null && !GLS.estDansLaListe(l, (Object)user.getNom())) {
                l.add(user.getNom());
            }
            if (!GLS.estVide((String)e.getMainCourante().getCodeAccompagnateur())) {
                String[] acc;
                for (String s : acc = e.getMainCourante().getCodeAccompagnateur().split(",")) {
                    if (GLS.estDansLaListe(l, (Object)s.trim()) || GLS.egal((String)s.trim(), (String)"Aucun \u00e9quipier")) continue;
                    l.add(s.trim());
                }
            }
            m.put("agentsTerrain", GLS.getString(l, (String)","));
            return true;
        }
        return false;
    }

    public boolean miseAJourChampSystemeCfiEvenement(Evenement e, Map<String, String> m, int contexteCreation) {
        if (m.containsKey("cfi")) {
            ModuleMetier mm = this.referentiel.getModulesMetiers().get(contexteCreation);
            if (mm != null) {
                m.put("cfi", mm.getLibelle());
            } else {
                m.put("cfi", String.valueOf(contexteCreation));
            }
            return true;
        }
        return false;
    }

    public boolean miseAJourChampSystemeCcnEvenement(Evenement e, Map<String, String> m, Nature n) {
        if (m.containsKey("ccn")) {
            m.put("ccn", this.referentiel.getListeCategoriesNature().get(n.getCode()));
            return true;
        }
        return false;
    }

    @Override
    public synchronized void sauvegarderEvenement(IEvenementASauvegarder eas) throws RuntimeException {
        if (this.referentiel.getConfiguration().getBoolean("mct.sauvegardeevt.v2", false)) {
            this.sauvegarderEvenementV2(eas);
        } else {
            this.sauvegarderEvenementV1(eas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sauvegarderEvenementV2(IEvenementASauvegarder eas) throws RuntimeException {
        boolean erreur;
        Evenement premiereVersion;
        Object dernierActif;
        Nature n;
        PreparedStatement pstm;
        Connection connection;
        Evenement e;
        block77: {
            e = eas.getEvenement();
            connection = null;
            pstm = null;
            n = (Nature)DeepCopy.copy((Object)this.referentiel.getNatureMap().get(e.getValeurNature().getCode()));
            n.chargerValeurs(e.getValeurNature());
            ValeurChampCollectionChoixUnique d = e.getValeurNature().getDescription();
            ValeurChampLocalisation l = e.getValeurNature().getLocalisation();
            List<DescriptionNature> listeDesc = this.referentiel.getDescriptionsNatureMap().get(n.getCode());
            int iDesc = MetierCommun.getIndiceObjetListe(listeDesc, (Object)d.getValeur());
            dernierActif = null;
            long k_eventid = this.recupIdEvenement();
            premiereVersion = null;
            erreur = false;
            String requeteSelect = "select k_eventid from evenement where etat=1 and snm=? and erf=? FOR UPDATE";
            boolean utiliserSelectForUpdate = false;
            utiliserSelectForUpdate = this.referentiel.getConfiguration().getBoolean("mct.selectForUpdate", false);
            try {
                connection = this.daoFactory.getConnection();
            }
            catch (SQLException ex) {
                throw new DAOException(ex);
            }
            try {
                long dateFin;
                long dateDebut;
                Evenement eSuiv;
                String libelleDescription;
                String codeDescription;
                if (utiliserSelectForUpdate) {
                    connection.setAutoCommit(false);
                    pstm = connection.prepareStatement(requeteSelect);
                    pstm.setString(1, e.getIdSituation());
                    pstm.setString(2, e.getIdReference());
                    pstm.executeQuery();
                    DAOUtil.close(null, pstm);
                }
                dernierActif = this.getDernierEvenementActif(connection, e);
                if (iDesc > -1) {
                    IDescription desc = (IDescription)listeDesc.get(iDesc);
                    codeDescription = desc.getCode();
                    libelleDescription = desc.getLibelle();
                } else if (e.isTermine() && dernierActif != null) {
                    codeDescription = "#" + dernierActif.getValeurNature().getCode() + "#";
                    libelleDescription = d.getValeur();
                    Log.error("!!! erreur description nature impossible \u00e0 trouver ! cloture " + d.getValeur());
                } else {
                    Log.error("!!! erreur description nature impossible \u00e0 trouver modification impossible" + d.getValeur());
                    throw new RuntimeException();
                }
                boolean bVersionPlusAncienne = false;
                if (dernierActif != null) {
                    boolean bl = bVersionPlusAncienne = dernierActif.getDateMaj() > 0L && e.getDateMaj() > 0L && e.getDateMaj() < dernierActif.getDateMaj();
                    if (!bVersionPlusAncienne) {
                        this.inactivationEvenement(connection, e);
                    }
                }
                boolean creation = dernierActif == null;
                HashMap<String, byte[]> imagesExtraites = new HashMap<String, byte[]>();
                HashMap<String, Document> documentsExtraits = new HashMap<String, Document>();
                HashMap<String, String> m = Utils.convertirAttributsExtraireImage2(n, e, imagesExtraites, documentsExtraits);
                PrismCentralUser u = this.user.rechercheUtilisateurParLogin(e.getCodeUtilisateur());
                InfoTerritoire inf = this.getTerritoireEvenement(e, (Evenement)dernierActif, (IUtilisateur)u, eas.getInfoTerritoire());
                e.setCei(inf.getCentre());
                e.setDistrict(inf.getDelegation());
                if (m.containsKey("centre") || m.containsKey("delegation")) {
                    if (m.containsKey("centre")) {
                        m.put("centre", inf.getCentre());
                    }
                    if (m.containsKey("delegation")) {
                        m.put("delegation", inf.getDelegation());
                    }
                }
                long vnm = this.recupVnmSuivant((Evenement)dernierActif);
                PrismCentralUser createur = null;
                int contexteCreation = -1;
                if (!creation) {
                    premiereVersion = this.getPremiereVersionEvenement(connection, e);
                    if (premiereVersion != null && !GLS.estVide((String)premiereVersion.getCodeUtilisateur())) {
                        createur = this.referentiel.getUtilisateur(premiereVersion.getCodeUtilisateur());
                        contexteCreation = e.getMainCourante().getCodeModuleMetier();
                    } else {
                        createur = u;
                    }
                } else {
                    createur = u;
                    if (e.getMainCourante() != null) {
                        contexteCreation = e.getMainCourante().getCodeModuleMetier();
                    }
                }
                this.miseAJourChampSystemeCfiEvenement(e, m, contexteCreation);
                this.miseAJourChampSystemeAgentsEvenement(e, m);
                this.miseAJourChampSystemeCcnEvenement(e, m, n);
                String codeEvenement = this.referentiel.getConfiguration().getBoolean("genereCodeClair", false) ? (creation ? (GLS.estVide((String)e.getCodeEvenement()) ? this.genereCodeEvenement(connection, e, inf) : e.getCodeEvenement()) : dernierActif.getCodeEvenement()) : e.getIdReference();
                e.setCodeEvenement(codeEvenement);
                if (e.getType() <= 0) {
                    e.setType(1);
                }
                if (!e.isTermine()) {
                    try {
                        int etatTraitement = MetierCommun.getEtatValeurOk(m, (String)this.champsCloture, (String)this.valeursCloture);
                        if (etatTraitement != -1) {
                            if (etatTraitement == 1) {
                                e.setTraite(true);
                                if (this.clotureDefinitiveActivee) {
                                    CommonProfilUtils.getInstance().init(u);
                                    e.setTermine(CommonProfilUtils.getInstance().peutCloturerEvenement(n));
                                }
                                e.setProgramme(false);
                            } else {
                                e.setTraite(false);
                            }
                        }
                    }
                    catch (Exception etatTraitement) {
                        // empty catch block
                    }
                }
                if (this.champsProgramme != null && this.valeursProgramme != null) {
                    e.setProgramme(MetierCommun.estValeurOk(m, (String)this.champsProgramme, (String)this.valeursProgramme));
                }
                e.setUrgence(GLS.getInt((boolean)MetierCommun.estValeurOk(m, (String)this.champsUrgence, (String)this.valeursUrgence)));
                e.setkEventid((int)k_eventid);
                if (eas.isVnmSynchro()) {
                    if ((long)e.getNumVersion() > vnm) {
                        vnm = e.getNumVersion();
                    }
                } else if (bVersionPlusAncienne && (eSuiv = this.getEvenementSuivantParDateMaj(connection, e)) != null) {
                    vnm = eSuiv.getNumVersion();
                    this.incrementeVNMEvenement(connection, eSuiv);
                }
                e.setNumVersion((int)vnm);
                boolean majsta = EvenementsDAOJDBC.miseAJourDateCreationEvenement(e, m);
                boolean majsto = EvenementsDAOJDBC.miseAJourDateFinEvenement(e, m);
                if (creation) {
                    dateDebut = e.getDateCreation();
                    dateFin = e.getDateFin() > 0L && e.getDateFin() > dateDebut ? e.getDateFin() : e.getDateCreation() + 720000L;
                } else if (e.isTermine()) {
                    dateDebut = dernierActif.getDateCreation();
                    dateFin = e.getDateFin() > 0L ? e.getDateFin() : (e.getDateMaj() <= 0L ? (e.getDateCreation() > 0L ? e.getDateCreation() : System.currentTimeMillis()) : e.getDateMaj());
                } else {
                    dateDebut = majsta ? e.getDateCreation() : dernierActif.getDateCreation();
                    dateFin = majsto ? (e.getDateFin() > 0L && e.getDateFin() > dateDebut ? e.getDateFin() : e.getDateCreation() + 720000L) : dernierActif.getDateCreation() + 720000L;
                }
                if (dateDebut > System.currentTimeMillis()) {
                    e.setPrevisionnel(true);
                } else {
                    e.setPrevisionnel(false);
                }
                Log.debug("DERNIER ACTIF " + dernierActif);
                try {
                    Situation situation = new Situation(e.getIdSituation());
                    this.creationSituation(connection, situation, u);
                }
                catch (Exception ex) {
                    Log.error(e);
                }
                String projection = ConfigurationFactory.getInstance().get("bdd.projection");
                String requete = "insert into evenement (K_EVENTID, DOB, SNM, ERF, FOREVENT, INP, MST, PHR, STA, STO, SUR, VNM, DATEXL01, DATEXL02, DATEXL03, DATEXL04, DATEXL05, DATEXL09, DATEXL11, DATEXL12, DATEXLTV, DATEXLOL, DATEXLOL1, DATEXLOT, LNP, NLQ, QUE, ARI, CFI, FIN, ETAT, VALOPE, VALOPEDATE, CAN, MCIG_ID, SOURCE, POSITIONNEMENT, ENVOIAUTO, COORDONNEES, POSITIONBRETELLE, EVENEMENTSERPE, MOT, PRDEB, PRFIN, DISTANCEPRDEB, DISTANCEPRFIN, TYPEEVENEMENT, SENS, ROUTE, APPEL, DONNEESCOMPLEMENTAIRES, LISTECOORDONNEES, CEI, DISTRICT, COMMUNE,COMMENTAIREINTERNE,departement,description,direction,nature,id_patrouille,lu,id_utilisateur,erreur,photos,code_evenement,adresse_debut,adresse_fin,programme,id_createur)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstm = connection.prepareStatement(requete);
                pstm.setLong(1, k_eventid);
                pstm.setString(2, e.getValeurNature().getCode());
                pstm.setString(3, e.getIdSituation());
                pstm.setString(4, e.getIdReference());
                if (e.isPrevisionnel()) {
                    pstm.setString(5, "Y");
                } else {
                    pstm.setString(5, "N");
                }
                pstm.setTimestamp(6, new Timestamp(e.getDateMaj()));
                pstm.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                pstm.setString(8, codeDescription);
                pstm.setTimestamp(9, new Timestamp(dateDebut));
                pstm.setTimestamp(10, new Timestamp(dateFin));
                String commentaire = this.getValeurAttribut(m, "commentaire", null);
                if (commentaire != null) {
                    Extension config = this.referentiel.getConfiguration();
                    int longueurMax = config.getInt("COMMENTAIRE_LONGUEUR_MAX", 350);
                    if (commentaire.length() > longueurMax - 1) {
                        commentaire = commentaire.substring(0, longueurMax);
                    }
                }
                pstm.setString(11, commentaire);
                pstm.setLong(12, vnm);
                pstm.setString(13, "-");
                pstm.setString(14, "-");
                pstm.setInt(15, 4);
                pstm.setInt(16, -1);
                pstm.setString(17, "-");
                pstm.setInt(18, -1);
                pstm.setInt(19, -1);
                pstm.setInt(20, -1);
                pstm.setInt(21, 0);
                pstm.setString(22, "");
                pstm.setString(23, "");
                pstm.setString(24, "");
                pstm.setString(25, l.getVoie());
                pstm.setInt(26, GLS.getInt((boolean)l.isAccrochage()));
                pstm.setInt(27, l.getLongueur());
                pstm.setInt(28, e.getUrgence());
                pstm.setInt(29, contexteCreation);
                if (e.isTermine()) {
                    pstm.setString(30, "Y");
                } else {
                    pstm.setNull(30, 12);
                }
                if (!bVersionPlusAncienne) {
                    pstm.setInt(31, 1);
                } else {
                    pstm.setInt(31, 0);
                }
                pstm.setInt(32, e.isTraite() ? 1 : 0);
                pstm.setTimestamp(33, new Timestamp(System.currentTimeMillis()));
                if (e.isAnnule()) {
                    pstm.setString(34, "Y");
                } else {
                    pstm.setString(34, "N");
                }
                pstm.setString(35, e.getMainCourante().getId());
                pstm.setString(36, "");
                pstm.setString(37, "t");
                pstm.setString(38, "0");
                if (l.getPositionDebut() != null) {
                    pstm.setString(39, SQL.getGeometryPointUTM((double)l.getPositionDebut().getX(), (double)l.getPositionDebut().getY(), (float)l.getPositionDebut().getAltitude()));
                } else if (!creation && dernierActif.getLocalisation() != null && dernierActif.getLocalisation().getPositionDebut() != null) {
                    pstm.setString(39, SQL.getGeometryPointUTM((double)dernierActif.getLocalisation().getPositionDebut().getX(), (double)dernierActif.getLocalisation().getPositionDebut().getY(), (float)dernierActif.getLocalisation().getPositionDebut().getAltitude()));
                } else {
                    pstm.setString(39, SQL.getGeometryPointUTM((double)0.0, (double)0.0));
                }
                pstm.setInt(40, l.getPointParticulier());
                pstm.setInt(41, 1);
                pstm.setInt(42, 1);
                pstm.setString(43, LocalisantPr.toString((String)String.valueOf(l.getPrDebut()), (String)l.getDeptDebut()));
                pstm.setString(44, LocalisantPr.toString((String)String.valueOf(l.getPrFin()), (String)l.getDeptFin()));
                pstm.setInt(45, l.getAbsPrDebut());
                pstm.setInt(46, l.getAbsPrFin());
                pstm.setInt(47, e.getType());
                pstm.setInt(48, l.getSensPr());
                pstm.setString(49, l.getAxe());
                pstm.setString(50, "");
                pstm.setString(51, MetierCommun.getCaracteristiquesLocalisation((ValeurChampLocalisation)l));
                if (l.getX() == null || l.getX().length == 0) {
                    pstm.setString(52, SQL.getGeometryLineUTM((float[])new float[]{0.0f, 0.0f}, (float[])new float[]{0.0f, 0.0f}));
                } else if (l.getX().length == 1 || !MetierCommun.estLineaire((ValeurChampLocalisation)l)) {
                    pstm.setString(52, SQL.getGeometryLineUTM((float[])new float[]{l.getX()[0], l.getX()[0]}, (float[])new float[]{l.getY()[0], l.getY()[0]}));
                } else {
                    pstm.setString(52, SQL.getGeometryLineUTM((float[])l.getX(), (float[])l.getY()));
                }
                pstm.setString(53, inf.getCentre());
                pstm.setString(54, inf.getDelegation());
                pstm.setString(55, l.getCommune());
                pstm.setString(56, GLS.getString((String)l.getDirection()));
                pstm.setString(57, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(58, libelleDescription);
                pstm.setString(59, MetierCommun.getComplementLocalisation((ValeurChampLocalisation)l));
                pstm.setString(60, e.getValeurNature().getCode());
                pstm.setString(61, e.getMainCourante().getIdPatrouille());
                pstm.setInt(62, e.isLu() ? 1 : 0);
                pstm.setInt(63, u.getId());
                pstm.setString(64, e.getErreur());
                List photosUniques = e.getPhotos().stream().distinct().collect(Collectors.toList());
                pstm.setArray(65, connection.createArrayOf("text", photosUniques.toArray()));
                pstm.setString(66, codeEvenement);
                e.setCodeEvenement(codeEvenement);
                pstm.setString(67, l.getAdresseDebut());
                pstm.setString(68, l.getAdresseFin());
                if (e.isProgramme()) {
                    pstm.setString(69, "1");
                } else {
                    pstm.setString(69, "0");
                }
                pstm.setInt(70, createur.getId());
                Log.debug("Insertion evenement requete " + pstm);
                pstm.execute();
                this.miseAJourAttributsImageEvenement(e, m);
                this.sauvegardeAttributsEvenement(connection, e, m);
                this.sauvegardeAttributsImageEvenement(connection, imagesExtraites);
                this.sauvegardeAttributsDocumentEvenement(connection, documentsExtraits);
                if (utiliserSelectForUpdate) {
                    try {
                        connection.commit();
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!bVersionPlusAncienne) break block77;
                if (e.getNumVersion() <= 1) {
                    dernierActif = null;
                    break block77;
                }
                IBusinessService.EvenementFiltre ef = IBusinessService.EvenementFiltre.getVersionActive((String)e.getIdSituation(), (String)e.getIdReference());
                ef.etat = -1;
                ef.vnm = e.getNumVersion() - 1;
                List<Situation> listeSit = this.getEvenements(connection, ef, null);
                if (listeSit == null || listeSit.size() <= 0) break block77;
                List evts = listeSit.get(0).getEvenements();
                dernierActif = evts != null && !evts.isEmpty() ? (Evenement)evts.get(0) : null;
            }
            catch (SQLException ex) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                Log.error("", ex);
                erreur = true;
                DAOUtil.close(connection, pstm);
            }
            catch (Throwable ex2) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                Log.error("", ex2);
                erreur = true;
                {
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm);
            }
        }
        DAOUtil.close(connection, pstm);
        if (GLS.estVide((String)e.getErreur()) && !erreur) {
            try {
                this.mcig.ajouterCommentaire(e.getMainCourante(), this.genereCommentaire(e, (Evenement)dernierActif, premiereVersion, n));
            }
            catch (Exception ex) {
                Log.error(ex, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sauvegarderEvenementV1(IEvenementASauvegarder eas) throws RuntimeException {
        long dateFin;
        long dateDebut;
        Evenement eSuiv;
        String libelleDescription;
        String codeDescription;
        Evenement e = eas.getEvenement();
        Connection connection = null;
        PreparedStatement pstm = null;
        Nature n = (Nature)DeepCopy.copy((Object)this.referentiel.getNatureMap().get(e.getValeurNature().getCode()));
        n.chargerValeurs(e.getValeurNature());
        ValeurChampCollectionChoixUnique d = e.getValeurNature().getDescription();
        ValeurChampLocalisation l = e.getValeurNature().getLocalisation();
        List<DescriptionNature> listeDesc = this.referentiel.getDescriptionsNatureMap().get(n.getCode());
        int iDesc = MetierCommun.getIndiceObjetListe(listeDesc, (Object)d.getValeur());
        long k_eventid = this.recupIdEvenement();
        Evenement dernierActif = this.getDernierEvenementActif(e);
        if (iDesc > -1) {
            IDescription desc = (IDescription)listeDesc.get(iDesc);
            codeDescription = desc.getCode();
            libelleDescription = desc.getLibelle();
        } else if (e.isTermine() && dernierActif != null) {
            codeDescription = "#" + dernierActif.getValeurNature().getCode() + "#";
            libelleDescription = d.getValeur();
            Log.error("!!! erreur description nature impossible \u00e0 trouver ! cloture " + d.getValeur());
        } else {
            Log.error("!!! erreur description nature impossible \u00e0 trouver modification impossible" + d.getValeur());
            throw new RuntimeException();
        }
        boolean bVersionPlusAncienne = false;
        if (dernierActif != null) {
            boolean bl = bVersionPlusAncienne = dernierActif.getDateMaj() > 0L && e.getDateMaj() > 0L && e.getDateMaj() < dernierActif.getDateMaj();
            if (!bVersionPlusAncienne) {
                this.inactivationEvenement(e);
            }
        }
        Evenement premiereVersion = null;
        boolean creation = dernierActif == null;
        HashMap<String, byte[]> imagesExtraites = new HashMap<String, byte[]>();
        HashMap<String, Document> documentsExtraits = new HashMap<String, Document>();
        HashMap<String, String> m = Utils.convertirAttributsExtraireImage2(n, e, imagesExtraites, documentsExtraits);
        PrismCentralUser u = this.user.rechercheUtilisateurParLogin(e.getCodeUtilisateur());
        InfoTerritoire inf = this.getTerritoireEvenement(e, dernierActif, (IUtilisateur)u, eas.getInfoTerritoire());
        e.setCei(inf.getCentre());
        e.setDistrict(inf.getDelegation());
        if (m.containsKey("centre") || m.containsKey("delegation")) {
            if (m.containsKey("centre")) {
                m.put("centre", inf.getCentre());
            }
            if (m.containsKey("delegation")) {
                m.put("delegation", inf.getDelegation());
            }
        }
        long vnm = this.recupVnmSuivant(dernierActif);
        PrismCentralUser createur = null;
        int contexteCreation = -1;
        if (!creation) {
            premiereVersion = this.getPremiereVersionEvenement(e);
            if (premiereVersion != null && !GLS.estVide((String)premiereVersion.getCodeUtilisateur())) {
                createur = this.referentiel.getUtilisateur(premiereVersion.getCodeUtilisateur());
                contexteCreation = e.getMainCourante().getCodeModuleMetier();
            } else {
                createur = u;
            }
        } else {
            createur = u;
            if (e.getMainCourante() != null) {
                contexteCreation = e.getMainCourante().getCodeModuleMetier();
            }
        }
        this.miseAJourChampSystemeCfiEvenement(e, m, contexteCreation);
        this.miseAJourChampSystemeAgentsEvenement(e, m);
        this.miseAJourChampSystemeCcnEvenement(e, m, n);
        String codeEvenement = this.referentiel.getConfiguration().getBoolean("genereCodeClair", false) ? (creation ? (GLS.estVide((String)e.getCodeEvenement()) ? this.genereCodeEvenement(e, inf) : e.getCodeEvenement()) : dernierActif.getCodeEvenement()) : e.getIdReference();
        e.setCodeEvenement(codeEvenement);
        if (e.getType() <= 0) {
            e.setType(1);
        }
        if (!e.isTermine()) {
            try {
                int etatTraitement = MetierCommun.getEtatValeurOk(m, (String)this.champsCloture, (String)this.valeursCloture);
                if (etatTraitement != -1) {
                    if (etatTraitement == 1) {
                        e.setTraite(true);
                        if (this.clotureDefinitiveActivee) {
                            CommonProfilUtils.getInstance().init(u);
                            e.setTermine(CommonProfilUtils.getInstance().peutCloturerEvenement(n));
                        }
                        e.setProgramme(false);
                    } else {
                        e.setTraite(false);
                    }
                }
            }
            catch (Exception etatTraitement) {
                // empty catch block
            }
        }
        if (this.champsProgramme != null && this.valeursProgramme != null) {
            e.setProgramme(MetierCommun.estValeurOk(m, (String)this.champsProgramme, (String)this.valeursProgramme));
        }
        e.setUrgence(GLS.getInt((boolean)MetierCommun.estValeurOk(m, (String)this.champsUrgence, (String)this.valeursUrgence)));
        e.setkEventid((int)k_eventid);
        if (eas.isVnmSynchro()) {
            if ((long)e.getNumVersion() > vnm) {
                vnm = e.getNumVersion();
            }
        } else if (bVersionPlusAncienne && (eSuiv = this.getEvenementSuivantParDateMaj(e)) != null) {
            vnm = eSuiv.getNumVersion();
            this.incrementeVNMEvenement(eSuiv);
        }
        e.setNumVersion((int)vnm);
        boolean majsta = EvenementsDAOJDBC.miseAJourDateCreationEvenement(e, m);
        boolean majsto = EvenementsDAOJDBC.miseAJourDateFinEvenement(e, m);
        if (creation) {
            dateDebut = e.getDateCreation();
            dateFin = e.getDateFin() > 0L && e.getDateFin() > dateDebut ? e.getDateFin() : e.getDateCreation() + 720000L;
        } else if (e.isTermine()) {
            dateDebut = dernierActif.getDateCreation();
            dateFin = e.getDateFin() > 0L ? e.getDateFin() : (e.getDateMaj() <= 0L ? (e.getDateCreation() > 0L ? e.getDateCreation() : System.currentTimeMillis()) : e.getDateMaj());
        } else {
            dateDebut = majsta ? e.getDateCreation() : dernierActif.getDateCreation();
            dateFin = majsto ? (e.getDateFin() > 0L && e.getDateFin() > dateDebut ? e.getDateFin() : e.getDateCreation() + 720000L) : dernierActif.getDateCreation() + 720000L;
        }
        if (dateDebut > System.currentTimeMillis()) {
            e.setPrevisionnel(true);
        } else {
            e.setPrevisionnel(false);
        }
        Log.debug("DERNIER ACTIF " + dernierActif);
        try {
            Situation situation = new Situation(e.getIdSituation());
            this.creationSituation(situation, u);
        }
        catch (Exception ex) {
            Log.error(e);
        }
        boolean erreur = false;
        String projection = ConfigurationFactory.getInstance().get("bdd.projection");
        String requete = "insert into evenement (K_EVENTID, DOB, SNM, ERF, FOREVENT, INP, MST, PHR, STA, STO, SUR, VNM, DATEXL01, DATEXL02, DATEXL03, DATEXL04, DATEXL05, DATEXL09, DATEXL11, DATEXL12, DATEXLTV, DATEXLOL, DATEXLOL1, DATEXLOT, LNP, NLQ, QUE, ARI, CFI, FIN, ETAT, VALOPE, VALOPEDATE, CAN, MCIG_ID, SOURCE, POSITIONNEMENT, ENVOIAUTO, COORDONNEES, POSITIONBRETELLE, EVENEMENTSERPE, MOT, PRDEB, PRFIN, DISTANCEPRDEB, DISTANCEPRFIN, TYPEEVENEMENT, SENS, ROUTE, APPEL, DONNEESCOMPLEMENTAIRES, LISTECOORDONNEES, CEI, DISTRICT, COMMUNE,COMMENTAIREINTERNE,departement,description,direction,nature,id_patrouille,lu,id_utilisateur,erreur,photos,code_evenement,adresse_debut,adresse_fin,programme,id_createur)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setLong(1, k_eventid);
            pstm.setString(2, e.getValeurNature().getCode());
            pstm.setString(3, e.getIdSituation());
            pstm.setString(4, e.getIdReference());
            if (e.isPrevisionnel()) {
                pstm.setString(5, "Y");
            } else {
                pstm.setString(5, "N");
            }
            pstm.setTimestamp(6, new Timestamp(e.getDateMaj()));
            pstm.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            pstm.setString(8, codeDescription);
            pstm.setTimestamp(9, new Timestamp(dateDebut));
            pstm.setTimestamp(10, new Timestamp(dateFin));
            String commentaire = this.getValeurAttribut(m, "commentaire", null);
            if (commentaire != null) {
                Extension config = this.referentiel.getConfiguration();
                int longueurMax = config.getInt("COMMENTAIRE_LONGUEUR_MAX", 350);
                if (commentaire.length() > longueurMax - 1) {
                    commentaire = commentaire.substring(0, longueurMax);
                }
            }
            pstm.setString(11, commentaire);
            pstm.setLong(12, vnm);
            pstm.setString(13, "-");
            pstm.setString(14, "-");
            pstm.setInt(15, 4);
            pstm.setInt(16, -1);
            pstm.setString(17, "-");
            pstm.setInt(18, -1);
            pstm.setInt(19, -1);
            pstm.setInt(20, -1);
            pstm.setInt(21, 0);
            pstm.setString(22, "");
            pstm.setString(23, "");
            pstm.setString(24, "");
            pstm.setString(25, l.getVoie());
            pstm.setInt(26, GLS.getInt((boolean)l.isAccrochage()));
            pstm.setInt(27, l.getLongueur());
            pstm.setInt(28, e.getUrgence());
            pstm.setInt(29, contexteCreation);
            if (e.isTermine()) {
                pstm.setString(30, "Y");
            } else {
                pstm.setNull(30, 12);
            }
            if (!bVersionPlusAncienne) {
                pstm.setInt(31, 1);
            } else {
                pstm.setInt(31, 0);
            }
            pstm.setInt(32, e.isTraite() ? 1 : 0);
            pstm.setTimestamp(33, new Timestamp(System.currentTimeMillis()));
            if (e.isAnnule()) {
                pstm.setString(34, "Y");
            } else {
                pstm.setString(34, "N");
            }
            pstm.setString(35, e.getMainCourante().getId());
            pstm.setString(36, "");
            pstm.setString(37, "t");
            pstm.setString(38, "0");
            if (l.getPositionDebut() != null) {
                pstm.setString(39, SQL.getGeometryPointUTM((double)l.getPositionDebut().getX(), (double)l.getPositionDebut().getY(), (float)l.getPositionDebut().getAltitude()));
            } else if (!creation && dernierActif.getLocalisation() != null && dernierActif.getLocalisation().getPositionDebut() != null) {
                pstm.setString(39, SQL.getGeometryPointUTM((double)dernierActif.getLocalisation().getPositionDebut().getX(), (double)dernierActif.getLocalisation().getPositionDebut().getY(), (float)dernierActif.getLocalisation().getPositionDebut().getAltitude()));
            } else {
                pstm.setString(39, SQL.getGeometryPointUTM((double)0.0, (double)0.0));
            }
            pstm.setInt(40, l.getPointParticulier());
            pstm.setInt(41, 1);
            pstm.setInt(42, 1);
            pstm.setString(43, LocalisantPr.toString((String)String.valueOf(l.getPrDebut()), (String)l.getDeptDebut()));
            pstm.setString(44, LocalisantPr.toString((String)String.valueOf(l.getPrFin()), (String)l.getDeptFin()));
            pstm.setInt(45, l.getAbsPrDebut());
            pstm.setInt(46, l.getAbsPrFin());
            pstm.setInt(47, e.getType());
            pstm.setInt(48, l.getSensPr());
            pstm.setString(49, l.getAxe());
            pstm.setString(50, "");
            pstm.setString(51, MetierCommun.getCaracteristiquesLocalisation((ValeurChampLocalisation)l));
            if (l.getX() == null || l.getX().length == 0) {
                pstm.setString(52, SQL.getGeometryLineUTM((float[])new float[]{0.0f, 0.0f}, (float[])new float[]{0.0f, 0.0f}));
            } else if (l.getX().length == 1 || !MetierCommun.estLineaire((ValeurChampLocalisation)l)) {
                pstm.setString(52, SQL.getGeometryLineUTM((float[])new float[]{l.getX()[0], l.getX()[0]}, (float[])new float[]{l.getY()[0], l.getY()[0]}));
            } else {
                pstm.setString(52, SQL.getGeometryLineUTM((float[])l.getX(), (float[])l.getY()));
            }
            pstm.setString(53, inf.getCentre());
            pstm.setString(54, inf.getDelegation());
            pstm.setString(55, l.getCommune());
            pstm.setString(56, GLS.getString((String)l.getDirection()));
            pstm.setString(57, ConfigurationFactory.getInstance().get("zoneroutiere"));
            pstm.setString(58, libelleDescription);
            pstm.setString(59, MetierCommun.getComplementLocalisation((ValeurChampLocalisation)l));
            pstm.setString(60, e.getValeurNature().getCode());
            pstm.setString(61, e.getMainCourante().getIdPatrouille());
            pstm.setInt(62, e.isLu() ? 1 : 0);
            pstm.setInt(63, u.getId());
            pstm.setString(64, e.getErreur());
            List photosUniques = e.getPhotos().stream().distinct().collect(Collectors.toList());
            pstm.setArray(65, connection.createArrayOf("text", photosUniques.toArray()));
            pstm.setString(66, codeEvenement);
            e.setCodeEvenement(codeEvenement);
            pstm.setString(67, l.getAdresseDebut());
            pstm.setString(68, l.getAdresseFin());
            if (e.isProgramme()) {
                pstm.setString(69, "1");
            } else {
                pstm.setString(69, "0");
            }
            pstm.setInt(70, createur.getId());
            Log.debug("Insertion evenement requete " + pstm);
            pstm.execute();
            this.miseAJourAttributsImageEvenement(e, m);
            this.sauvegardeAttributsEvenement(e, m);
            this.sauvegardeAttributsImageEvenement(imagesExtraites);
            this.sauvegardeAttributsDocumentEvenement(documentsExtraits);
        }
        catch (SQLException ex) {
            Log.error("", ex);
            erreur = true;
            DAOUtil.close(connection, pstm);
        }
        catch (Throwable ex2) {
            Log.error("", ex2);
            erreur = true;
            {
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm);
        }
        DAOUtil.close(connection, pstm);
        if (GLS.estVide((String)e.getErreur())) {
            try {
                this.mcig.ajouterCommentaire(e.getMainCourante(), this.genereCommentaire(e, dernierActif, premiereVersion, n));
            }
            catch (Exception ex) {
                Log.error(ex, ex);
            }
        }
    }

    private void miseAJourAttributsImageEvenement(Evenement e, HashMap<String, String> m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void miseAJourGeometryEvenement(Evenement evt) {
        block6: {
            block7: {
                String projection = ConfigurationFactory.getInstance().get("bdd.projection");
                Connection connection = null;
                PreparedStatement pstm = null;
                ValeurChampLocalisation l = evt.getLocalisation();
                String requete = "update evenement set QUE = ?,COORDONNEES=GeomFromText(?," + projection + "), PRDEB=?, PRFIN=?, DISTANCEPRDEB=?, DISTANCEPRFIN=?,  SENS=?, ROUTE=?, LISTECOORDONNEES=GeomFromText(?," + projection + "), COMMUNE=? where k_eventid = ?";
                if (l.getPositionDebut() == null || l.getX() == null || l.getX().length <= 0) break block7;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setInt(1, l.getLongueur());
                    pstm.setString(2, SQL.getGeometryPointUTM((double)l.getPositionDebut().getX(), (double)l.getPositionDebut().getY(), (float)l.getPositionDebut().getAltitude()));
                    pstm.setString(3, LocalisantPr.toString((String)String.valueOf(l.getPrDebut()), (String)l.getDeptDebut()));
                    pstm.setString(4, LocalisantPr.toString((String)String.valueOf(l.getPrFin()), (String)l.getDeptFin()));
                    pstm.setInt(5, l.getAbsPrDebut());
                    pstm.setInt(6, l.getAbsPrFin());
                    pstm.setInt(7, l.getSensPr());
                    pstm.setString(8, l.getAxe());
                    if (l.getX().length == 1) {
                        pstm.setString(9, SQL.getGeometryLineUTM((float[])new float[]{l.getX()[0], l.getX()[0]}, (float[])new float[]{l.getY()[0], l.getY()[0]}));
                    } else {
                        pstm.setString(9, SQL.getGeometryLineUTM((float[])l.getX(), (float[])l.getY()));
                    }
                    pstm.setString(10, l.getCommune());
                    pstm.setLong(11, evt.getkEventid());
                    pstm.execute();
                }
                catch (Exception e) {
                    try {
                        Log.error("coord err maj evt geom " + evt.getkEventid(), e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm);
                        throw throwable;
                    }
                    DAOUtil.close(connection, pstm);
                    break block6;
                }
                DAOUtil.close(connection, pstm);
                break block6;
            }
            Log.error("coord null id " + evt.getkEventid());
        }
    }

    public InfoTerritoire getTerritoireEvenement(Evenement evenement, Evenement dernierActif, IUtilisateur utilisateur, InfoTerritoire infoTerritoire) {
        Extension config = this.referentiel.getConfiguration();
        boolean exclureInterventions = config.getBoolean("determinationTerritoire.exclureIntervention", false);
        return this.getTerritoireEvenement(evenement, dernierActif, utilisateur, infoTerritoire, exclureInterventions);
    }

    public InfoTerritoire getTerritoireEvenement(Evenement evenement, Evenement dernierActif, IUtilisateur utilisateur, InfoTerritoire infoTerritoire, boolean exclureInterventions) {
        InfoTerritoire inf;
        try {
            Extension config = this.referentiel.getConfiguration();
            String determinationTerritoire = config.getString("determinationTerritoire");
            boolean utiliserDepartement = config.getBoolean("determinationTerritoire.utiliserDepartement", true);
            Log.debug("D\u00e9terminationTerritoire " + determinationTerritoire + " -- Exclure interventions : " + exclureInterventions);
            if (exclureInterventions && evenement != null && MetierCommun.estIntervention((Evenement)evenement, this.referentiel.getNatures()) && !evenement.isTermine()) {
                InfoTerritoire inf2 = new InfoTerritoire();
                inf2.setCentre(null);
                inf2.setDelegation(null);
                return inf2;
            }
            inf = !MetierCommun.estTypeDefautPrism((int)evenement.getType()) && infoTerritoire != null ? infoTerritoire : (GLS.egal((String)determinationTerritoire, (String)"commune") ? this.getTerritoireEvenementCommune(evenement, utilisateur, evenement.getLocalisation().getCommune()) : (GLS.egal((String)determinationTerritoire, (String)"manuel") ? EvenementsDAOJDBC.getTerritoireEvenementManuel(evenement, infoTerritoire, utilisateur) : (GLS.egal((String)determinationTerritoire, (String)"axe_pr") ? this.getTerritoireEvenementAxePr(evenement, utilisateur, evenement.getLocalisation().getAxe(), evenement.getLocalisation().getPrDebut(), evenement.getLocalisation().getAbsPrDebut(), utiliserDepartement ? evenement.getLocalisation().getDeptDebut() : null, false) : (GLS.egal((String)determinationTerritoire, (String)"axe_pr_centre") ? this.getTerritoireEvenementAxePr(evenement, utilisateur, evenement.getLocalisation().getAxe(), evenement.getLocalisation().getPrDebut(), evenement.getLocalisation().getAbsPrDebut(), utiliserDepartement ? evenement.getLocalisation().getDeptDebut() : null, true) : (GLS.egal((String)determinationTerritoire, (String)"centre") ? this.getTerritoireEvenementGeometrieCentre(evenement, utilisateur) : EvenementsDAOJDBC.getTerritoireEvenementUtilisateur(evenement, utilisateur))))));
        }
        catch (Exception e) {
            inf = EvenementsDAOJDBC.getTerritoireEvenementUtilisateur(evenement, utilisateur);
        }
        if (dernierActif != null) {
            if (GLS.estVide((String)inf.getCentre()) && !GLS.estVide((String)dernierActif.getCei())) {
                inf.setCentre(dernierActif.getCei());
                Log.debug("MAJ INF TER Changement de centre " + dernierActif.getkEventid() + " -- " + inf.getCentre());
            }
            if (GLS.estVide((String)inf.getDelegation()) && !GLS.estVide((String)dernierActif.getDistrict())) {
                inf.setDelegation(dernierActif.getDistrict());
                Log.debug("MAJ INF TER Changement de delegation " + dernierActif.getkEventid() + " -- " + inf.getDelegation());
            }
        }
        return inf;
    }

    public static InfoTerritoire getTerritoireEvenementUtilisateur(Evenement evenement, IUtilisateur utilisateur) {
        InfoTerritoire inf = new InfoTerritoire();
        if (!GLS.estVide((String)utilisateur.getCentre())) {
            inf.setCentre(utilisateur.getCentre());
        } else {
            inf.setCentre(evenement.getCei());
        }
        if (!GLS.estVide((String)utilisateur.getDelegation())) {
            inf.setDelegation(utilisateur.getDelegation());
        } else {
            inf.setDelegation(evenement.getDistrict());
        }
        return inf;
    }

    public static InfoTerritoire getTerritoireEvenementManuel(Evenement evenement, InfoTerritoire infoTerritoire, IUtilisateur utilisateur) {
        InfoTerritoire inf;
        if (infoTerritoire != null) {
            inf = infoTerritoire;
        } else if (!GLS.estVide((String)evenement.getDistrict())) {
            inf = new InfoTerritoire();
            inf.setCentre(evenement.getCei());
            inf.setDelegation(evenement.getDistrict());
        } else {
            inf = EvenementsDAOJDBC.getTerritoireEvenementUtilisateur(evenement, utilisateur);
        }
        return inf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoTerritoire getTerritoireEvenementCommune(Evenement evenement, IUtilisateur utilisateur, String commune) throws Exception {
        String requete = "select delegation,centre from prism.communes where commune=? limit 1";
        Connection connection = null;
        PreparedStatement pstm = null;
        InfoTerritoire inf = new InfoTerritoire();
        ResultSet rs = null;
        boolean trouve = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, commune);
            Log.debug(pstm.toString());
            rs = pstm.executeQuery();
            if (rs != null && rs.first()) {
                inf = new InfoTerritoire();
                inf.setCentre(rs.getString("centre"));
                inf.setDelegation(rs.getString("delegation"));
                trouve = true;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        catch (SQLException e) {
            rs = null;
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        if (!trouve && utilisateur != null) {
            inf.setCentre(utilisateur.getCentre());
            inf.setDelegation(utilisateur.getDelegation());
        }
        return inf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoTerritoire getTerritoireEvenementGeometrieCentre(Evenement evenement, IUtilisateur utilisateur) throws RuntimeException {
        Connection connection = null;
        PreparedStatement pstm = null;
        InfoTerritoire inf = new InfoTerritoire();
        ResultSet rs = null;
        boolean trouve = false;
        if (evenement != null && evenement.getLocalisation() != null && evenement.getLocalisation().getPositionDebut() != null) {
            String requete = "select centreplusproche(" + SQL.getChampGeometryPoint((double)evenement.getLocalisation().getPositionDebut().getX(), (double)evenement.getLocalisation().getPositionDebut().getY(), (int)4326) + ",0.0001,2,100)";
            Log.debug("Recherche territoire g\u00e9om\u00e9trie centre - " + evenement.getkEventid());
            try {
                String nomCentre;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                rs = pstm.executeQuery();
                Log.debug("Requete centre geom " + pstm.toString());
                if (rs != null && rs.first() && !GLS.estVide((String)(nomCentre = rs.getString(1)))) {
                    Log.debug("Centre ok " + nomCentre);
                    Centre centre = MetierCommun.getCentreParNom(this.referentiel.getDelegations(), (String)nomCentre);
                    inf.setCentre(centre.getNom());
                    inf.setDelegation(centre.getDelegation());
                    trouve = true;
                }
                DAOUtil.close(connection, pstm, rs);
            }
            catch (SQLException e) {
                rs = null;
            }
            finally {
                DAOUtil.close(connection, pstm, rs);
            }
        }
        try {
            if (!trouve) {
                if (utilisateur != null) {
                    inf.setCentre(utilisateur.getCentre());
                    inf.setDelegation(utilisateur.getDelegation());
                } else {
                    inf = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoTerritoire getTerritoireEvenementAxePr(Evenement evenement, IUtilisateur utilisateur, String axe, int pr, int abscisse, String dpt, boolean rechercheCentreGeometrie) throws RuntimeException {
        Connection connection = null;
        PreparedStatement pstm = null;
        InfoTerritoire inf = new InfoTerritoire();
        ResultSet rs = null;
        boolean trouve = false;
        boolean aDepartement = !GLS.estVide((String)dpt) && !GLS.egal((String)"-1", (String)dpt);
        String requete = "select delegation,centre from donnees_metier.troncon_centre where axe=?  and (prdebut < ? or (prdebut = ? and abscisseprdebut <= ?))  and (prfin > ? or (prfin = ? and abscisseprfin >= ?)) ";
        if (aDepartement) {
            requete = requete + " and departementprdebut = ? ";
        }
        requete = requete + " limit 1";
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, axe);
            pstm.setInt(2, pr);
            pstm.setInt(3, pr);
            pstm.setInt(4, abscisse);
            pstm.setInt(5, pr);
            pstm.setInt(6, pr);
            pstm.setInt(7, abscisse);
            if (aDepartement) {
                pstm.setString(8, dpt);
            }
            if ((rs = pstm.executeQuery()) != null && rs.first()) {
                inf.setCentre(rs.getString("centre"));
                inf.setDelegation(rs.getString("delegation"));
                trouve = true;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        catch (SQLException e) {
            rs = null;
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        try {
            if (!trouve) {
                if (rechercheCentreGeometrie) {
                    inf = this.getTerritoireEvenementGeometrieCentre(evenement, utilisateur);
                } else if (utilisateur != null) {
                    inf.setCentre(utilisateur.getCentre());
                    inf.setDelegation(utilisateur.getDelegation());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inf;
    }

    @Override
    public void lireEvenement(Evenement event) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("UPDATE prism.evenement SET lu='1',mst=now() WHERE k_eventid=?");
            pstm.setInt(1, event.getkEventid());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void programmeEvenement(Evenement event, boolean etat) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("UPDATE prism.evenement SET programme=?,mst=now(),lu='1' WHERE k_eventid=?");
            pstm.setString(1, etat ? "1" : "0");
            pstm.setInt(2, event.getkEventid());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void supprimeEvenement(Evenement event) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("DELETE from prism.attribut_evenement a WHERE a.k_eventid in (select e.k_eventid from prism.evenement e where e.erf=? and can='Y')");
            pstm.setString(1, event.getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("DELETE from prism.evenement WHERE erf=? and can='Y'");
            pstm.setString(1, event.getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(connection, pstm);
        }
    }

    @Override
    public void annulerEvenement(IEvenementASauvegarder event) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.evenement set can='Y' WHERE erf=?");
            pstm.setString(1, event.getEvenement().getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.sauvegarderEvenement(event);
    }

    @Override
    public void associerEvenement(IEvenementASauvegarder event, String nouvelleSituation) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.evenement set snm=?,valopedate=now(),mst=now() WHERE erf=?");
            pstm.setString(1, nouvelleSituation);
            pstm.setString(2, event.getEvenement().getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.sauvegarderEvenement(event);
    }

    public int getNbEvenementParNatureJournee(Connection connectionInit, String nature, String delegation, String centre, long date) {
        PreparedStatement pstm;
        block7: {
            pstm = null;
            boolean pasDeCentre = GLS.estVide((String)centre);
            pstm = pasDeCentre ? connectionInit.prepareStatement(REQUETE_NB_EVENEMENT_NATURE_JOURNEE_CEI_NULL, 1004, 1007) : connectionInit.prepareStatement(REQUETE_NB_EVENEMENT_NATURE_JOURNEE, 1004, 1007);
            pstm.setString(1, nature);
            if (pasDeCentre) {
                pstm.setLong(2, date);
            } else {
                pstm.setString(2, centre);
                pstm.setLong(3, date);
            }
            ResultSet rs = pstm.executeQuery();
            if (!rs.first()) break block7;
            int n = rs.getInt("nb");
            DAOUtil.close(null, pstm);
            return n;
        }
        try {
            try {
                throw new RuntimeException();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm);
            throw throwable;
        }
    }

    public String genereCodeEvenement(Evenement evt, InfoTerritoire inf) throws DAOException {
        String string;
        block8: {
            Connection connection = this.daoFactory.getConnection();
            try {
                string = this.genereCodeEvenement(connection, evt, inf);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            connection.close();
        }
        return string;
    }

    private String genereCodeEvenement(Connection connectionInit, Evenement evt, InfoTerritoire inf) {
        return new PrismCodeEvenementGenerator(this, this.referentiel, this.nf).genereCodeEvenement(connectionInit, evt.getValeurNature().getCode(), inf.getDelegation(), inf.getCentre(), evt.getDateCreation());
    }

    private void miseAJourCodeEvenement(int k_eventid, String codeEvenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update evenement set code_evenement = ? where k_eventid = ?", 1004, 1007);
            pstm.setString(1, codeEvenement);
            pstm.setInt(2, k_eventid);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void traitementApresVisaPatrouille(VehiculeEnIntervention v) {
        boolean clotureAuto = this.referentiel.getConfiguration().getBoolean("mct.visa.clotureAuto", false);
        if (clotureAuto) {
            String req = "update prism.evenement set valopedate=now(),mst=now(),fin='Y' where etat=1 and valope=1 and id_patrouille = ANY(?)";
            Connection connection = null;
            PreparedStatement pstm = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req, 1004, 1007);
                Array a = connection.createArrayOf("text", v.getIdsPatrouillesAgreg().toArray());
                pstm.setArray(1, a);
                pstm.execute();
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm);
        }
    }

    private void verificationCodeEvenement() {
        PreparedStatement pstm;
        Connection connection;
        block11: {
            connection = null;
            pstm = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select k_eventid,nature,cei,district,inp from prism.evenement where code_evenement is null and vnm = 1 order by cei,nature,inp", 1004, 1007);
                ResultSet rs = pstm.executeQuery();
                if (rs.first()) {
                    do {
                        String codeEvenement = new PrismCodeEvenementGenerator(this, this.referentiel, this.nf).genereCodeEvenement(connection, rs.getString("nature"), rs.getString("district"), rs.getString("cei"), rs.getTimestamp("inp").getTime());
                        this.miseAJourCodeEvenement(rs.getInt("k_eventid"), codeEvenement);
                    } while (rs.next());
                    break block11;
                }
                Log.debug("Aucun id \u00e9v\u00e8nement en clair \u00e0 reg\u00e9n\u00e9rer");
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm);
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.evenement as evt set code_evenement = evt2.code_evenement from prism.evenement evt2 where evt2.erf = evt.erf and evt.vnm <> 1 and evt.code_evenement is null and evt2.vnm = 1", 1004, 1007);
            pstm.execute();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(connection, pstm);
        }
    }

    private String getLongueurCommentaire(double l) {
        if (l >= 1000.0) {
            GLS.getNombre();
            return String.valueOf(Nombre.getNombre((double)(l / 1000.0), (int)3)).concat(" ").concat(ReportI18n.getString("unit.kilometres"));
        }
        GLS.getNombre();
        return String.valueOf(Nombre.getNombre((double)l)).concat(" ").concat(ReportI18n.getString("unit.metres"));
    }

    private String getLibelleChamp(Nature n, String nom) {
        Champ c = null;
        try {
            c = MetierCommun.instanceOf().getChamp(n.getChamps(), nom);
        }
        catch (Exception e) {
            c = null;
            Log.error("R\u00e9cup\u00e9ration du nom du champ impossible " + nom, e);
        }
        if (c != null) {
            return c.getLibelle();
        }
        return nom;
    }

    public Commentaire genereCommentaire(Evenement nouveau, Evenement ancien, Evenement premier, Nature n) {
        Object createur;
        StringBuffer s = new StringBuffer();
        String typeMesssage = "";
        Map<String, Nature> natures = this.referentiel.getNatureMap();
        String codeDescription = nouveau.getValeurNature().getDescription().getValeur();
        if (nouveau.getNumVersion() <= 1) {
            typeMesssage = !nouveau.isTermine() ? (nouveau.isTraite() ? (n.getCodeMM() == 5 ? typeMesssage + ReportI18n.getString("mcig.libelleVisa") + " -" : typeMesssage + ReportI18n.getString("mcig.libelleTraite") + " -") : ReportI18n.getString("mcig.libelleCreation") + " -") : ReportI18n.getString("mcig.libelleCreation") + " / " + ReportI18n.getString("mcig.libelleCloture") + " -";
            createur = this.referentiel.getUtilisateur(nouveau.getCodeUtilisateur());
        } else if (nouveau.isTermine()) {
            typeMesssage = nouveau.isAnnule() ? ReportI18n.getString("mcig.libelleAnnule") + " -" : ReportI18n.getString("mcig.libelleCloture") + " -";
            createur = premier != null ? this.referentiel.getUtilisateur(premier.getCodeUtilisateur()) : null;
        } else {
            typeMesssage = ancien != null && ancien.getType() != nouveau.getType() ? (nouveau.getType() == 4 ? ReportI18n.getString("mcig.libelleAxioneTransmis") + " -" : ReportI18n.getString("mcig.libelleModification") + " -") : (ancien != null && !ancien.isTraite() && nouveau.isTraite() ? (n.getCodeMM() == 5 ? typeMesssage + ReportI18n.getString("mcig.libelleVisa") + " -" : typeMesssage + ReportI18n.getString("mcig.libelleTraite") + " -") : (ancien != null && ancien.isTermine() && !nouveau.isTermine() ? ReportI18n.getString("mcig.libelleDecloture") + " -" : ReportI18n.getString("mcig.libelleModification") + " -"));
            createur = premier != null ? this.referentiel.getUtilisateur(premier.getCodeUtilisateur()) : null;
        }
        s.append(typeMesssage);
        s.append(" ");
        s.append(n.getLabel());
        s.append(nouveau.getValeurNature().getLocalisation().getLongueur() == 0 ? "" : " " + this.getLongueurCommentaire(nouveau.getValeurNature().getLocalisation().getLongueur()));
        s.append(" " + ReportI18n.getString("mcig.cree") + " ");
        GLS.getDate();
        GLS.getDate();
        Calendar calendar = GLSDate.toDate((long)nouveau.getDateCreation());
        GLS.getDate();
        GLS.getDate();
        s.append(GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour, (DateFormat)GLSDate.formatHeureComplete));
        s.append(createur != null ? " " + ReportI18n.getString("mcig.par") + " " + createur.getNom() : "");
        s.append(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE);
        if (ancien != null && (this.localisationAChange(ancien, nouveau) || !GLS.egal((String)ancien.getValeurNature().getDescription().getValeur(), (String)codeDescription))) {
            s.append("(*) ");
        }
        s.append(codeDescription);
        if (GLS.estVide((String)nouveau.getErreur())) {
            if (!GLS.estVide((String)nouveau.getLocalisation().getAxe())) {
                s.append(" " + ReportI18n.getString("mcig.sur") + " ");
                s.append(nouveau.getLocalisation().getAxe());
                s.append(" - ");
                String pr = MetierCommun.getLibellePr((ValeurChampLocalisation)nouveau.getLocalisation());
                if (!GLS.estVide((String)pr)) {
                    s.append(pr + " - ");
                }
                if (!GLS.estVide((String)nouveau.getLocalisation().getComplementLocalisation()) && !GLS.egal((String)nouveau.getLocalisation().getComplementLocalisation(), (String)nouveau.getLocalisation().getAxe())) {
                    s.append(nouveau.getLocalisation().getComplementLocalisation());
                    s.append(" - ");
                }
                if (!GLS.estVide((String)nouveau.getLocalisation().getCommune())) {
                    s.append(nouveau.getLocalisation().getCommune());
                }
                if (!GLS.estVide((String)nouveau.getLocalisation().getDirection())) {
                    s.append(" ");
                    s.append(nouveau.getLocalisation().getDirection());
                }
            } else if (!GLS.estVide((String)nouveau.getLocalisation().getCommune())) {
                s.append(" " + ReportI18n.getString("mcig.surcommune") + " ");
                s.append(nouveau.getLocalisation().getCommune());
            }
            s.append(" ");
        } else {
            s.append(" (" + nouveau.getErreur() + ") ");
            if (!GLS.estVide((String)nouveau.getLocalisation().getCommune())) {
                s.append(" " + ReportI18n.getString("mcig.surcommune") + " ");
                s.append(nouveau.getLocalisation().getCommune());
            }
        }
        CommentaireComposantFactory2 factory = new CommentaireComposantFactory2();
        Nature nat = (Nature)DeepCopy.copy((Object)natures.get(n.getCode()));
        nat.chargerValeurs(nouveau.getValeurNature());
        Map<String, ChampCSV> mapNouvellesValeurs = CommentaireComposantFactory2.getMapViewCommentaire(nat, factory);
        if (nouveau.getNumVersion() <= 1 || ancien == null) {
            for (ChampCSV k : mapNouvellesValeurs.values()) {
                s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append(k.getLibelle()).append(" : ").append(k.getValeur());
            }
        } else {
            nat = null;
            nat = (Nature)DeepCopy.copy((Object)natures.get(n.getCode()));
            nat.chargerValeurs(ancien.getValeurNature());
            Map<String, ChampCSV> mapAnciennesValeurs = CommentaireComposantFactory2.getMapViewCommentaire(nat, factory);
            for (String k : mapNouvellesValeurs.keySet()) {
                ChampCSV newVal = mapNouvellesValeurs.get(k);
                ChampCSV oldVal = mapAnciennesValeurs.get(k);
                if (!GLS.estVide((String)newVal.getValeur())) {
                    if (!mapAnciennesValeurs.containsKey(k)) {
                        s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append("(+) ").append(newVal.getLibelle()).append(" : ").append(newVal.getValeur());
                        continue;
                    }
                    if (GLS.egal((Object)newVal, (Object)oldVal)) {
                        s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append(newVal.getLibelle()).append(" : ").append(newVal.getValeur());
                        continue;
                    }
                    if (GLS.egal((String)newVal.getValeur(), (String)oldVal.getValeur())) continue;
                    s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append("(*) ").append(newVal.getLibelle()).append(" : ").append(newVal.getValeur());
                    continue;
                }
                if (!mapAnciennesValeurs.containsKey(k) || GLS.estVide((String)oldVal.getValeur())) continue;
                s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append("(-) " + oldVal.getLibelle());
            }
            for (String k : mapAnciennesValeurs.keySet()) {
                if (GLS.estVide((String)mapAnciennesValeurs.get(k).getValeur()) || mapNouvellesValeurs.containsKey(k)) continue;
                s.append(String.valueOf(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE)).append("(-) " + mapAnciennesValeurs.get(k).getLibelle());
            }
        }
        return MetierCommun.genereCommentaire((String)s.toString(), (long)nouveau.getDateMaj(), (Evenement)nouveau, (int)-1);
    }

    private boolean localisationAChange(Evenement ancien, Evenement nouveau) {
        return !GLS.egal((String)nouveau.getLocalisation().getAxe(), (String)ancien.getLocalisation().getAxe()) || !GLS.egal((Object)nouveau.getLocalisation().getPrDebut(), (Object)ancien.getLocalisation().getPrDebut()) || !GLS.egal((Object)nouveau.getLocalisation().getPrFin(), (Object)ancien.getLocalisation().getPrFin()) || !GLS.egal((String)nouveau.getLocalisation().getDirection(), (String)ancien.getLocalisation().getDirection()) || !GLS.egal((String)nouveau.getLocalisation().getCommune(), (String)ancien.getLocalisation().getCommune());
    }

    @Override
    public List<Situation> getEvenementsASynchroniserDatex2(IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) throws DAOException {
        ArrayList<Situation> arrayList;
        block48: {
            Connection connection = this.daoFactory.getConnection();
            try {
                Map<Integer, Map<String, String>> attributs = this.chargerTousAttributsASynchroniserDatex2(filtreSql);
                Set<String> publies = this.chargerErfEvenementPubliees(connection);
                PreparedStatement pstm = null;
                ResultSet rs = null;
                String requete = "SELECT k_eventid as \"id\", snm as \"id_situation\", erf as \"id_reference\",code_evenement, dob as \"code_nature\", vnm as \"version\", sta as \"date_creation\", sto as  \"date_fin\", inp as \"date_version\", sna as \"code_utilisateur\", erreur, description, fin, can, forevent, cei,district,lnp,nlq,direction,commentaireinterne,donneescomplementaires,programme,  prdeb,prfin,distanceprdeb,distanceprfin,sens,route,commune,que as \"longueur\", lu, photos,coordonnees, ST_Transform(listecoordonnees,4326) as geom, adresse_debut,adresse_fin,typeevenement FROM prism.evenement  JOIN prism.utilisateur ON evenement.id_utilisateur=utilisateur.id_utilisateur WHERE utilisateur.mse=? and evenement.k_eventid in (select k_eventid from datex2.synchro_evenement where zone_routiere = ? order by inp asc)";
                if (filtreSql.idEvenement != null) {
                    requete = requete + " AND k_eventid=ANY(?)";
                }
                if (filtreSql.descriptions != null) {
                    requete = requete + " AND phr=ANY(?)";
                }
                if (filtreSql.etat != -1) {
                    requete = requete + " AND etat=?";
                }
                if (filtreSql.termines == 0) {
                    requete = requete + " AND fin IS NULL";
                }
                if (filtreSql.termines == 1) {
                    requete = requete + " AND fin='Y'";
                }
                if (filtreSql.idUtilisateur != -1) {
                    requete = requete + " AND utilisateur.id_utilisateur=?";
                }
                if (filtreSql.nature != null) {
                    requete = requete + " AND nature=ANY(?)";
                }
                if (filtreSql.route != null) {
                    requete = requete + " AND UPPER(route)=UPPER(?)";
                }
                if (filtreSql.sid != null) {
                    requete = requete + " AND snm=?";
                }
                if (filtreSql.delegation != null) {
                    requete = requete + " AND district=?";
                }
                if (filtreSql.centre != null) {
                    requete = requete + " AND cei=?";
                }
                if (filtreSql.erf != null) {
                    requete = requete + " AND erf=?";
                }
                if (filtreSql.dateMin != null) {
                    requete = requete + " AND sta >= ?";
                }
                if (filtreSql.dateMax != null) {
                    requete = requete + " AND sta <= ?";
                }
                requete = requete + " ORDER BY id_situation,date_creation DESC";
                Log.debug("requete : " + requete);
                ArrayList<Situation> evenements = null;
                try {
                    Array a;
                    pstm = connection.prepareStatement(requete);
                    String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
                    pstm.setString(1, zr);
                    pstm.setString(2, zr);
                    int indexParam = 3;
                    if (filtreSql.idEvenement != null) {
                        a = connection.createArrayOf("int", filtreSql.idEvenement.toArray());
                        pstm.setArray(indexParam, a);
                        ++indexParam;
                    }
                    if (filtreSql.descriptions != null) {
                        a = connection.createArrayOf("text", filtreSql.descriptions.toArray());
                        pstm.setArray(indexParam, a);
                        ++indexParam;
                    }
                    if (filtreSql.etat != -1) {
                        pstm.setInt(indexParam, filtreSql.etat);
                        ++indexParam;
                    }
                    if (filtreSql.idUtilisateur != -1) {
                        pstm.setInt(indexParam, filtreSql.idUtilisateur);
                        ++indexParam;
                    }
                    if (filtreSql.nature != null) {
                        a = connection.createArrayOf("text", filtreSql.nature.toArray());
                        pstm.setArray(indexParam, a);
                        ++indexParam;
                    }
                    if (filtreSql.route != null) {
                        pstm.setString(indexParam, filtreSql.route);
                        ++indexParam;
                    }
                    if (filtreSql.sid != null) {
                        pstm.setString(indexParam, filtreSql.sid);
                        ++indexParam;
                    }
                    if (filtreSql.delegation != null) {
                        pstm.setString(indexParam, filtreSql.delegation);
                        ++indexParam;
                    }
                    if (filtreSql.centre != null) {
                        pstm.setString(indexParam, filtreSql.centre);
                        ++indexParam;
                    }
                    if (filtreSql.erf != null) {
                        pstm.setString(indexParam, filtreSql.erf);
                        ++indexParam;
                    }
                    if (filtreSql.dateMin != null) {
                        pstm.setTimestamp(indexParam, filtreSql.dateMin);
                        ++indexParam;
                    }
                    if (filtreSql.dateMax != null) {
                        pstm.setTimestamp(indexParam, filtreSql.dateMax);
                        ++indexParam;
                    }
                    Log.debug("# requete evenements # " + pstm);
                    rs = pstm.executeQuery();
                    evenements = new ArrayList<Situation>();
                    Situation current = null;
                    while (rs.next()) {
                        Evenement e = new Evenement();
                        e.setCodeUtilisateur(rs.getString("code_utilisateur"));
                        Timestamp dateCreation = rs.getTimestamp("date_creation");
                        e.setDateCreation(dateCreation.getTime());
                        Timestamp dateMaj = rs.getTimestamp("date_version");
                        e.setDateMaj(dateMaj.getTime());
                        Timestamp dateFin = rs.getTimestamp("date_fin");
                        e.setDateFin(dateFin.getTime());
                        String err = rs.getString("erreur");
                        if (err == null) {
                            e.setEtat(2);
                        } else {
                            e.setErreur(err);
                            e.setEtat(3);
                        }
                        e.setIdReference(rs.getString("id_reference"));
                        e.setIdSituation(rs.getString("id_situation"));
                        e.setNumVersion(rs.getInt("version"));
                        e.setCei(rs.getString("cei"));
                        e.setDistrict(rs.getString("district"));
                        e.setPublie(publies.contains(e.getIdReference()));
                        e.setPrevisionnel(!rs.getString("forevent").equals("N"));
                        e.setType(rs.getInt("typeevenement"));
                        Array photoArray = rs.getArray("photos");
                        if (photoArray != null) {
                            String[] photos = (String[])photoArray.getArray();
                            ArrayList<String> photosList = new ArrayList<String>();
                            photosList.addAll(Arrays.asList(photos));
                            e.setPhotos(photosList);
                        } else {
                            e.setPhotos(new ArrayList());
                        }
                        e.setTermine("Y".equals(rs.getString("fin")));
                        e.setAnnule("Y".equals(rs.getString("can")));
                        e.setLu("1".equals(rs.getString("lu")));
                        e.setProgramme("1".equals(rs.getString("programme")));
                        int keventid = rs.getInt("id");
                        e.setkEventid(keventid);
                        String codeNature = rs.getString("code_nature");
                        Nature nat = (Nature)DeepCopy.copy((Object)this.referentiel.getNatureMap().get(codeNature));
                        this.chargerChampsEvenement(e, keventid, nat, codeNature, rs, attributs.get(keventid), filtreSql.cible);
                        boolean aAjouter = true;
                        if (filtresJava != null) {
                            for (FiltreJava filtre : filtresJava) {
                                if (filtre.accept(e)) continue;
                                aAjouter = false;
                                break;
                            }
                        }
                        if (!aAjouter) continue;
                        if (current == null || !current.getSid().equals(e.getIdSituation())) {
                            if (current != null) {
                                evenements.add(current);
                            }
                            current = new Situation(e.getIdSituation());
                        }
                        current.addEvenement(e);
                    }
                    rs.close();
                    if (current != null) {
                        evenements.add(current);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, rs);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, rs);
                arrayList = evenements;
                if (connection == null) break block48;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getNbAccidentsEtInterventionsParAnnee(IBusinessService.EvenementFiltre filtre) {
        HashMap<String, Map<String, Map<Integer, Integer>>> retour = new HashMap<String, Map<String, Map<Integer, Integer>>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String corporel;
            String mortel;
            connection = this.daoFactory.getConnection();
            String requete = REQUETE_NB_ACCIDENT_ET_INTERVENTION_SELECT;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + " WHERE e.nature = np.code AND np.code_module_metier = ? AND e.sta BETWEEN ? AND ? AND e.can <> 'Y'";
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_NB_ACCIDENT_ET_INTERVENTION_GROUPBY;
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, 5);
            pstm.setTimestamp(2, filtre.dateMin);
            pstm.setTimestamp(3, filtre.dateMax);
            int indexParam = 4;
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            String nomGroupe = "tableaubord.stats.pc.interventions.et.accidents";
            HashMap<Integer, Integer> mapTotal = new HashMap<Integer, Integer>();
            Map<String, HashMap<String, Map<Integer, Integer>>> mapLine = new LinkedHashMap<String, Map<Integer, Integer>>();
            for (int i = 0; i < 12; ++i) {
                mapTotal.put(i, 0);
            }
            while (rs.next()) {
                String nature = rs.getString("libelle");
                int nb = rs.getInt("nb");
                int mois = rs.getInt("mois") - 1;
                if (retour.containsKey(nomGroupe)) {
                    mapLine = (Map)retour.get(nomGroupe);
                }
                Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                if (mapLine.containsKey(nature)) {
                    mapMois = (Map)mapLine.get(nature);
                }
                mapMois.put(mois, nb);
                mapTotal.put(mois, (Integer)mapTotal.get(mois) + nb);
                mapLine.put(nature, (HashMap<String, Map<Integer, Integer>>)mapMois);
            }
            try {
                mortel = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident.mortel");
            }
            catch (Exception e) {
                mortel = "mortel";
            }
            try {
                corporel = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident.corporel");
            }
            catch (Exception e) {
                corporel = "corporel";
            }
            mapLine.put("tableaubord.stats.pc.total.general", mapTotal);
            mapLine.put("tableaubord.stats.pc.accident.mortel", (HashMap<String, Map<Integer, Integer>>)this.getNbAccidentsMortelsCorporels(filtre, mortel));
            mapLine.put("tableaubord.stats.pc.accident.corporel", (HashMap<String, Map<Integer, Integer>>)this.getNbAccidentsMortelsCorporels(filtre, corporel));
            retour.put(nomGroupe, mapLine);
            retour.put("tableaubord.stats.pc.emetteur.appel", this.getNbAppels(filtre));
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    @Override
    public SyntheseTBDelaiDureeInterventionBean getDelaisDureesIntervention(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        SyntheseTBDelaiDureeInterventionBean tbd = new SyntheseTBDelaiDureeInterventionBean();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String champDateDeclenchementIntervention;
            int delaiMaxHeures;
            try {
                delaiMaxHeures = ConfigurationFactory.getInstance().getInt("synthese.deleaidureeeintervention.delaidureemax.heure");
            }
            catch (Exception e) {
                delaiMaxHeures = 8;
            }
            try {
                champDateDeclenchementIntervention = ConfigurationFactory.getInstance().get("synthese.champ.datedeclenchement");
            }
            catch (Exception e) {
                champDateDeclenchementIntervention = "dateDeclenchementIntervention";
            }
            connection = this.daoFactory.getConnection();
            GregorianCalendar gc = new GregorianCalendar();
            gc.set(11, delaiMaxHeures);
            gc.set(12, 0);
            gc.set(13, 0);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            String dureeDelai = sdf.format(gc.getTime());
            String requete = REQUETE_DUREEDELAI_INTERVENTION_SELECT;
            requete = requete.replaceAll("XXDELAIXX", dureeDelai);
            requete = annuel ? requete + " date_part('month',e2.sta) as colonne " : requete + " date_part('day',e2.sta) as colonne ";
            requete = requete + REQUETE_DUREEDELAI_INTERVENTION_FROM;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + REQUETE_DUREEDELAI_INTERVENTION_WHERE;
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_DUREEDELAI_INTERVENTION_GROUPBY;
            pstm = connection.prepareStatement(requete);
            int indexParam = 1;
            pstm.setInt(indexParam++, 5);
            pstm.setTimestamp(indexParam++, filtre.dateMin);
            pstm.setTimestamp(indexParam++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            SyntheseTBDelaiDureeInterventionLineBean lineDelai = new SyntheseTBDelaiDureeInterventionLineBean();
            SyntheseTBDelaiDureeInterventionLineBean lineDuree = new SyntheseTBDelaiDureeInterventionLineBean();
            tbd.setSyntheseTBDelaiInterventionLineBean(lineDelai);
            tbd.setSyntheseTBDureeInterventionLineBean(lineDuree);
            if (annuel) {
                for (int i = 1; i <= 12; ++i) {
                    String jourMois = String.valueOf(i);
                    tbd.getJoursMois().add(jourMois);
                    lineDelai.getDelaiDureeMoyen().put(jourMois, 0);
                    lineDelai.getDelaiDureeMax().put(jourMois, 0);
                    lineDelai.getDelaiDureeMin().put(jourMois, 0);
                    lineDuree.getDelaiDureeMoyen().put(jourMois, 0);
                    lineDuree.getDelaiDureeMax().put(jourMois, 0);
                    lineDuree.getDelaiDureeMin().put(jourMois, 0);
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(2, filtre.dateMin.getMonth());
                int maxDay = cal.getActualMaximum(5);
                for (int i = 1; i <= maxDay; ++i) {
                    String jourMois = String.valueOf(i);
                    tbd.getJoursMois().add(jourMois);
                    lineDelai.getDelaiDureeMoyen().put(jourMois, 0);
                    lineDelai.getDelaiDureeMax().put(jourMois, 0);
                    lineDelai.getDelaiDureeMin().put(jourMois, 0);
                    lineDuree.getDelaiDureeMoyen().put(jourMois, 0);
                    lineDuree.getDelaiDureeMax().put(jourMois, 0);
                    lineDuree.getDelaiDureeMin().put(jourMois, 0);
                }
            }
            while (rs.next()) {
                String colonne = rs.getString("colonne");
                if (rs.getString("delaimoyen") != null) {
                    lineDelai.getDelaiDureeMoyen().put(colonne, rs.getTime("delaimoyen").getMinutes() + 60 * rs.getTime("delaimoyen").getHours());
                } else {
                    lineDelai.getDelaiDureeMoyen().put(colonne, 0);
                }
                if (rs.getString("delaimax") != null) {
                    lineDelai.getDelaiDureeMax().put(colonne, rs.getTime("delaimax").getMinutes() + 60 * rs.getTime("delaimax").getHours());
                } else {
                    lineDelai.getDelaiDureeMax().put(colonne, 0);
                }
                if (rs.getString("delaimin") != null) {
                    lineDelai.getDelaiDureeMin().put(colonne, rs.getTime("delaimin").getMinutes() + 60 * rs.getTime("delaimin").getHours());
                } else {
                    lineDelai.getDelaiDureeMin().put(colonne, 0);
                }
                if (rs.getString("tempmoyen") != null) {
                    lineDuree.getDelaiDureeMoyen().put(colonne, rs.getTime("tempmoyen").getMinutes() + 60 * rs.getTime("tempmoyen").getHours());
                } else {
                    lineDuree.getDelaiDureeMoyen().put(colonne, 0);
                }
                if (rs.getString("tempmax") != null) {
                    lineDuree.getDelaiDureeMax().put(colonne, rs.getTime("tempmax").getMinutes() + 60 * rs.getTime("tempmax").getHours());
                } else {
                    lineDuree.getDelaiDureeMax().put(colonne, 0);
                }
                if (rs.getString("tempmin") != null) {
                    lineDuree.getDelaiDureeMin().put(colonne, rs.getTime("tempmin").getMinutes() + 60 * rs.getTime("tempmin").getHours());
                    continue;
                }
                lineDuree.getDelaiDureeMin().put(colonne, 0);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return tbd;
    }

    @Override
    public Map<String, Map<String, Integer>> getNbAccidentsEtInterventionsParAnneeParAxe(IBusinessService.EvenementFiltre filtre) {
        LinkedHashMap<String, Map<String, Integer>> mapLine = new LinkedHashMap<String, Map<String, Integer>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String corporel;
            String mortel;
            connection = this.daoFactory.getConnection();
            String requete = REQUETE_NB_ACCIDENT_ET_INTERVENTION_AXE_SELECT;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + " WHERE e.nature = np.code AND np.code_module_metier = ? AND e.sta BETWEEN ? AND ? AND e.can <> 'Y'";
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_NB_ACCIDENT_ET_INTERVENTION_AXE_GROUPBY;
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, 5);
            pstm.setTimestamp(2, filtre.dateMin);
            pstm.setTimestamp(3, filtre.dateMax);
            int indexParam = 4;
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            HashMap<String, Integer> mapTotal = new HashMap<String, Integer>();
            while (rs.next()) {
                String nature = rs.getString("libelle");
                int nb = rs.getInt("nb");
                String axe = rs.getString("route");
                if (axe == null) {
                    axe = "";
                }
                Map mapMois = mapLine.containsKey(nature) ? (Map)mapLine.get(nature) : new HashMap();
                mapMois.put(axe, nb);
                mapTotal.put(axe, (mapTotal.get(axe) != null ? (Integer)mapTotal.get(axe) : 0) + nb);
                mapLine.put(nature, mapMois);
            }
            try {
                mortel = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident.mortel");
            }
            catch (Exception e) {
                mortel = "mortel";
            }
            try {
                corporel = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident.corporel");
            }
            catch (Exception e) {
                corporel = "corporel";
            }
            mapLine.put("tableaubord.stats.pc.total.general", mapTotal);
            mapLine.put("tableaubord.stats.pc.accident.mortel", this.getNbAccidentsMortelsCorporelsParAxe(filtre, mortel));
            mapLine.put("tableaubord.stats.pc.accident.corporel", this.getNbAccidentsMortelsCorporelsParAxe(filtre, corporel));
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return mapLine;
    }

    private void remplirVehiculeImplique(SyntheseAccidentologieLineBean ligne, boolean annuel, int mois, int nb, int nbVehicule) {
        if (ligne != null) {
            if (annuel) {
                ligne.getNbMois()[mois] = ligne.getNbMois()[mois] + nb * nbVehicule;
            } else {
                ligne.getNbMois()[0] = ligne.getNbMois()[0] + nb * nbVehicule;
            }
            ligne.setTotal(ligne.getTotal() + nb * nbVehicule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAccidentologieNbVehiculesImpliques(Connection connection, SyntheseAccidentologieBean retour, IBusinessService.EvenementFiltre filtre, boolean annuel) {
        PreparedStatement pstm = null;
        try {
            String champVehiculesImpliques;
            String natureAccident;
            try {
                natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.accident");
            }
            catch (Exception e) {
                natureAccident = "acc";
            }
            try {
                champVehiculesImpliques = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.vehiculesimpliques");
            }
            catch (Exception e) {
                champVehiculesImpliques = "typeVehicule";
            }
            String[] ordreVehiculesImpliques = new String[]{};
            ResultSet rs = null;
            try {
                pstm = connection.prepareStatement("SELECT * FROM prism.composant WHERE nom = '" + champVehiculesImpliques + "'");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ordreVehiculesImpliques = rs.getString("definition").split(";");
                }
            }
            catch (SQLException e) {
                try {
                    ordreVehiculesImpliques = new String[]{"vl", "pl", "tc", "campingCar", "velo", "moto", "pietonCycle", "tmd", "autres", "deuxRoues", "caravane", "train", "tramway", "enginAgricole", "animaux", "autres"};
                }
                catch (Throwable throwable) {
                    DAOUtil.close(null, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(null, pstm, rs);
            }
            DAOUtil.close(null, pstm, rs);
            String requete = REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_SELECT;
            requete = requete + "FROM attribut_evenement ae, evenement e2 ";
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBVEHICULESIMPLIQUES_WHERE;
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + " GROUP BY mois, valeur ORDER BY mois ASC";
            pstm = connection.prepareStatement(requete);
            int indexParam = 1;
            pstm.setString(indexParam++, champVehiculesImpliques);
            pstm.setString(indexParam++, natureAccident);
            pstm.setTimestamp(indexParam++, filtre.dateMin);
            pstm.setTimestamp(indexParam++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            rs = pstm.executeQuery();
            if (annuel) {
                for (int i = 0; i < 12; ++i) {
                    retour.getMois().add(i);
                }
            }
            SyntheseAccidentologieLineBean line = null;
            LinkedHashMap<String, SyntheseAccidentologieLineBean> lignes = new LinkedHashMap<String, SyntheseAccidentologieLineBean>();
            if (ordreVehiculesImpliques != null && ordreVehiculesImpliques.length > 0) {
                for (String ordre : ordreVehiculesImpliques) {
                    line = new SyntheseAccidentologieLineBean();
                    line.setNom(ordre);
                    if (annuel) {
                        line.setNbMois(new Integer[12]);
                        for (int i = 0; i < 12; ++i) {
                            line.getNbMois()[i] = 0;
                        }
                    } else {
                        line.setNbMois(new Integer[1]);
                        line.getNbMois()[0] = 0;
                    }
                    lignes.put(ordre, line);
                }
            }
            while (rs.next()) {
                int mois = rs.getInt("mois") - 1;
                if (!retour.getMois().contains(mois)) {
                    retour.getMois().add(mois);
                }
                int nb = rs.getInt("nb");
                String valeur = rs.getString("valeur");
                ChampVehiculeEnCause chVehicule = new ChampVehiculeEnCause(valeur);
                ValeurChampVehiculeEnCause ch = (ValeurChampVehiculeEnCause)chVehicule.parseValeur(valeur);
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("vl"), annuel, mois, nb, ch.getVl());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("pl"), annuel, mois, nb, ch.getPl());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("tc"), annuel, mois, nb, ch.getVtc());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("campingCar"), annuel, mois, nb, ch.getCampingCar());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("velo"), annuel, mois, nb, ch.getVelo());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("moto"), annuel, mois, nb, ch.getMoto());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("pietonCycle"), annuel, mois, nb, ch.getPietonCycle());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("tmd"), annuel, mois, nb, ch.getTmd());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("autres"), annuel, mois, nb, ch.getAutres());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("deuxRoues"), annuel, mois, nb, ch.getDeuxRoues());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("caravane"), annuel, mois, nb, ch.getCaravane());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("train"), annuel, mois, nb, ch.getTrain());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("tramway"), annuel, mois, nb, ch.getTramway());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("enginAgricole"), annuel, mois, nb, ch.getEnginAgricole());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("animaux"), annuel, mois, nb, ch.getAnimaux());
                this.remplirVehiculeImplique((SyntheseAccidentologieLineBean)lignes.get("autres"), annuel, mois, nb, ch.getAutres());
            }
            DAOUtil.close(null, pstm);
            retour.getSyntheseVehiculesImpliquesLineBean().addAll(lignes.values());
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm);
    }

    private void getAccidentologieNbAccidents(Connection connection, SyntheseAccidentologieBean retour, IBusinessService.EvenementFiltre filtre, boolean annuel) {
        PreparedStatement pstm;
        block40: {
            pstm = null;
            try {
                String champNatureAccident;
                String natureAccident;
                try {
                    natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.accident");
                }
                catch (Exception e) {
                    natureAccident = "acc";
                }
                try {
                    champNatureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident");
                }
                catch (Exception e) {
                    champNatureAccident = "natureAccident";
                }
                String[] ordreNatureAccident = new String[]{};
                ResultSet rs = null;
                try {
                    pstm = connection.prepareStatement("SELECT * FROM prism.composant WHERE nom = '" + champNatureAccident + "'");
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        ordreNatureAccident = rs.getString("definition").split(";");
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(null, pstm, rs);
                        throw throwable;
                    }
                }
                DAOUtil.close(null, pstm, rs);
                String requete = REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_SELECT;
                requete = requete + "FROM attribut_evenement ae, evenement e2 ";
                if (filtre.delegation != null || filtre.centre != null) {
                    requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
                }
                requete = requete + "WHERE ae.champ = ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
                if (filtre.delegation != null) {
                    requete = requete + " AND (district=? OR u.delegation=?)";
                }
                if (filtre.centre != null) {
                    requete = requete + " AND (cei=? OR u.centre=?)";
                }
                requete = requete + " GROUP BY mois, valeur ORDER BY mois ASC";
                pstm = connection.prepareStatement(requete);
                int indexParam = 1;
                pstm.setString(indexParam++, champNatureAccident);
                pstm.setString(indexParam++, natureAccident);
                pstm.setTimestamp(indexParam++, filtre.dateMin);
                pstm.setTimestamp(indexParam++, filtre.dateMax);
                if (filtre.delegation != null) {
                    pstm.setString(indexParam++, filtre.delegation);
                    pstm.setString(indexParam++, filtre.delegation);
                }
                if (filtre.centre != null) {
                    pstm.setString(indexParam++, filtre.centre);
                    pstm.setString(indexParam++, filtre.centre);
                }
                rs = pstm.executeQuery();
                if (annuel) {
                    for (int i = 0; i < 12; ++i) {
                        retour.getMois().add(i);
                    }
                }
                SyntheseAccidentologieLineBean lineTotal = new SyntheseAccidentologieLineBean();
                if (annuel) {
                    lineTotal.setNbMois(new Integer[12]);
                    for (int i = 0; i < 12; ++i) {
                        lineTotal.getNbMois()[i] = 0;
                    }
                } else {
                    lineTotal.setNbMois(new Integer[1]);
                    lineTotal.getNbMois()[0] = 0;
                }
                lineTotal.setNom(natureAccident);
                retour.getSyntheseAccidentsLineBean().add(lineTotal);
                SyntheseAccidentologieLineBean line = null;
                HashMap<String, SyntheseAccidentologieLineBean> lignes = new HashMap<String, SyntheseAccidentologieLineBean>();
                Object natureOld = null;
                while (rs.next()) {
                    int mois = rs.getInt("mois") - 1;
                    if (!retour.getMois().contains(mois)) {
                        retour.getMois().add(mois);
                    }
                    int nb = rs.getInt("nb");
                    String[] natures = GLS.estVide((String)rs.getString("nature")) ? new String[]{""} : rs.getString("nature").split(";");
                    for (String nature : natures) {
                        Integer[] integerArray;
                        if (nature != natureOld && (line = (SyntheseAccidentologieLineBean)lignes.get(nature)) == null) {
                            line = new SyntheseAccidentologieLineBean();
                            line.setNom(nature);
                            if (annuel) {
                                line.setNbMois(new Integer[12]);
                                for (int i = 0; i < 12; ++i) {
                                    line.getNbMois()[i] = 0;
                                }
                            } else {
                                line.setNbMois(new Integer[1]);
                                line.getNbMois()[0] = 0;
                            }
                            lignes.put(nature, line);
                        }
                        if (annuel) {
                            integerArray = line.getNbMois();
                            int n = mois;
                            Integer.valueOf(integerArray[n] + nb);
                        } else {
                            integerArray = line.getNbMois();
                            Integer.valueOf(integerArray[0] + nb);
                        }
                        line.setTotal(line.getTotal() + nb);
                    }
                    if (annuel) {
                        lineTotal.getNbMois()[mois] = lineTotal.getNbMois()[mois] + nb;
                    } else {
                        lineTotal.getNbMois()[0] = lineTotal.getNbMois()[0] + nb;
                    }
                    lineTotal.setTotal(lineTotal.getTotal() + nb);
                }
                DAOUtil.close(null, pstm);
                if (ordreNatureAccident != null && ordreNatureAccident.length > 0) {
                    for (String ordre : ordreNatureAccident) {
                        if (lignes.get(ordre) != null) {
                            retour.getSyntheseAccidentsLineBean().add((SyntheseAccidentologieLineBean)lignes.get(ordre));
                            continue;
                        }
                        line = new SyntheseAccidentologieLineBean();
                        line.setNom(ordre);
                        if (annuel) {
                            line.setNbMois(new Integer[12]);
                            for (int i = 0; i < 12; ++i) {
                                line.getNbMois()[i] = 0;
                            }
                        } else {
                            line.setNbMois(new Integer[1]);
                            line.getNbMois()[0] = 0;
                        }
                        retour.getSyntheseAccidentsLineBean().add(line);
                    }
                    break block40;
                }
                retour.getSyntheseAccidentsLineBean().addAll(lignes.values());
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(null, pstm);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(null, pstm);
    }

    @Override
    public LinkedHashMap<String, List<Position>> getAccidentologieCoordonneesAccidents(IBusinessService.EvenementFiltre filtre) {
        LinkedHashMap<String, List<Position>> retour;
        PreparedStatement pstm;
        Connection connection;
        block24: {
            connection = null;
            pstm = null;
            retour = new LinkedHashMap<String, List<Position>>();
            try {
                String champNatureAccident;
                String natureAccident;
                connection = this.daoFactory.getConnection();
                try {
                    natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.accident");
                }
                catch (Exception e) {
                    natureAccident = "acc";
                }
                try {
                    champNatureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident");
                }
                catch (Exception e) {
                    champNatureAccident = "natureAccident";
                }
                String[] ordreNatureAccident = new String[]{};
                ResultSet rs = null;
                try {
                    pstm = connection.prepareStatement("SELECT * FROM prism.composant WHERE nom = '" + champNatureAccident + "'");
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        ordreNatureAccident = rs.getString("definition").split(";");
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(null, pstm, rs);
                        throw throwable;
                    }
                }
                DAOUtil.close(null, pstm, rs);
                String requete = REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_SELECT;
                requete = requete + "FROM attribut_evenement ae, evenement e2 ";
                if (filtre.delegation != null || filtre.centre != null) {
                    requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
                }
                requete = requete + "WHERE ae.champ = ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
                if (filtre.delegation != null) {
                    requete = requete + " AND (district=? OR u.delegation=?)";
                }
                if (filtre.centre != null) {
                    requete = requete + " AND (cei=? OR u.centre=?)";
                }
                requete = requete + REQUETE_ACCIDENTOLOGIE_COORDONNEES_ACCIDENTS_GROUPBY;
                pstm = connection.prepareStatement(requete);
                int indexParam = 1;
                pstm.setString(indexParam++, champNatureAccident);
                pstm.setString(indexParam++, natureAccident);
                pstm.setTimestamp(indexParam++, filtre.dateMin);
                pstm.setTimestamp(indexParam++, filtre.dateMax);
                if (filtre.delegation != null) {
                    pstm.setString(indexParam++, filtre.delegation);
                    pstm.setString(indexParam++, filtre.delegation);
                }
                if (filtre.centre != null) {
                    pstm.setString(indexParam++, filtre.centre);
                    pstm.setString(indexParam++, filtre.centre);
                }
                rs = pstm.executeQuery();
                HashMap<String, ArrayList<Position>> lignes = new HashMap<String, ArrayList<Position>>();
                Object natureOld = null;
                while (rs.next()) {
                    LineString ls;
                    String nature = rs.getString("nature");
                    PGgeometry geom = null;
                    Object point = null;
                    if (EvenementsDAOJDBC.getValueFromResultSet(rs, "geom", null) != null) {
                        geom = (PGgeometry)rs.getObject("geom");
                    }
                    if (geom == null || (ls = (LineString)geom.getGeometry()).getFirstPoint() == null) continue;
                    Position p = new Position();
                    p.setX((float)ls.getFirstPoint().getX());
                    p.setY((float)ls.getFirstPoint().getY());
                    ArrayList<Position> positionsNature = (ArrayList<Position>)lignes.get(nature);
                    if (positionsNature == null) {
                        positionsNature = new ArrayList<Position>();
                    }
                    positionsNature.add(p);
                    lignes.put(nature, positionsNature);
                }
                DAOUtil.close(null, pstm);
                if (ordreNatureAccident != null && ordreNatureAccident.length > 0) {
                    for (String ordre : ordreNatureAccident) {
                        if (lignes.get(ordre) != null) {
                            retour.put(ordre, (List)lignes.get(ordre));
                            continue;
                        }
                        retour.put(ordre, new ArrayList());
                    }
                    break block24;
                }
                retour.putAll(lignes);
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    private void getAccidentologieNbBlessesTues(Connection connection, SyntheseAccidentologieBean retour, IBusinessService.EvenementFiltre filtre, boolean annuel) {
        PreparedStatement pstm = null;
        try {
            String libelleMorts;
            String libelleBlessesGraves;
            String libelleBlessesLegers;
            String natureAccident;
            try {
                natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.accident");
            }
            catch (Exception e) {
                natureAccident = "acc";
            }
            String requete = REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_SELECT;
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_FROM;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_WHERE;
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_GROUPBY;
            pstm = connection.prepareStatement(requete);
            try {
                libelleBlessesLegers = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.blesseslegers");
            }
            catch (Exception e) {
                libelleBlessesLegers = "blessesLegers";
            }
            try {
                libelleBlessesGraves = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.blessesgraves");
            }
            catch (Exception e) {
                libelleBlessesGraves = "blessesGraves";
            }
            try {
                libelleMorts = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.morts");
            }
            catch (Exception e) {
                libelleMorts = "tues";
            }
            int indexParam = 1;
            pstm.setString(indexParam++, libelleMorts);
            pstm.setString(indexParam++, libelleBlessesLegers);
            pstm.setString(indexParam++, libelleBlessesGraves);
            pstm.setString(indexParam++, natureAccident);
            pstm.setTimestamp(indexParam++, filtre.dateMin);
            pstm.setTimestamp(indexParam++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            SyntheseAccidentologieLineBean lineBlesses = new SyntheseAccidentologieLineBean();
            retour.getSyntheseAccidentsLineBean().add(lineBlesses);
            lineBlesses.setNom(libelleBlessesLegers);
            SyntheseAccidentologieLineBean lineMorts = new SyntheseAccidentologieLineBean();
            retour.getSyntheseAccidentsLineBean().add(lineMorts);
            lineMorts.setNom(libelleMorts);
            if (annuel) {
                lineBlesses.setNbMois(new Integer[12]);
                lineMorts.setNbMois(new Integer[12]);
                for (int i = 0; i < 12; ++i) {
                    lineBlesses.getNbMois()[i] = 0;
                    lineMorts.getNbMois()[i] = 0;
                }
            } else {
                lineBlesses.setNbMois(new Integer[1]);
                lineBlesses.getNbMois()[0] = 0;
                lineMorts.setNbMois(new Integer[1]);
                lineMorts.getNbMois()[0] = 0;
            }
            while (rs.next()) {
                int mois = rs.getInt("mois") - 1;
                int nbblesses = rs.getInt("nbblesses");
                int nbtues = rs.getInt("nbtues");
                lineBlesses.setTotal(lineBlesses.getTotal() + nbblesses);
                if (annuel) {
                    lineBlesses.getNbMois()[mois] = nbblesses;
                    lineMorts.getNbMois()[mois] = nbtues;
                } else {
                    lineBlesses.getNbMois()[0] = nbblesses;
                    lineMorts.getNbMois()[0] = nbtues;
                }
                lineMorts.setTotal(lineMorts.getTotal() + nbtues);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm);
    }

    @Override
    public SyntheseAccidentologieBean getAccidentologie(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        SyntheseAccidentologieBean retour = new SyntheseAccidentologieBean();
        Connection connection = null;
        try {
            connection = this.daoFactory.getConnection();
            this.getAccidentologieNbAccidents(connection, retour, filtre, annuel);
            this.getAccidentologieNbBlessesTues(connection, retour, filtre, annuel);
            this.getAccidentologieNbVehiculesImpliques(connection, retour, filtre, annuel);
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(connection, null);
        }
        return retour;
    }

    public SyntheseAccidentologieBean oldgetAccidentologie(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        SyntheseAccidentologieBean retour = new SyntheseAccidentologieBean();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String libelleMorts;
            String libelleBlessesGraves;
            String libelleBlessesLegers;
            String champNatureAccident;
            String natureAccident;
            connection = this.daoFactory.getConnection();
            try {
                natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.accident");
            }
            catch (Exception e) {
                natureAccident = "acc";
            }
            try {
                champNatureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident");
            }
            catch (Exception e) {
                champNatureAccident = "natureAccident";
            }
            String[] ordreNatureAccident = new String[]{};
            ResultSet rs = null;
            try {
                pstm = connection.prepareStatement("SELECT * FROM prism.composant WHERE nom = '" + champNatureAccident + "'");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ordreNatureAccident = rs.getString("definition").split(";");
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(null, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(null, pstm, rs);
            String requete = REQUETE_ACCIDENTOLOGIE_NBACCIDENTS_SELECT;
            requete = requete + "FROM attribut_evenement ae, evenement e2 ";
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + "WHERE ae.champ = ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature=? AND e.can <> 'Y' AND e.sta BETWEEN ? AND ? GROUP BY e.snm, e.erf) ";
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + " GROUP BY mois, valeur ORDER BY mois ASC";
            pstm = connection.prepareStatement(requete);
            int indexParam = 1;
            pstm.setString(indexParam++, champNatureAccident);
            pstm.setString(indexParam++, natureAccident);
            pstm.setTimestamp(indexParam++, filtre.dateMin);
            pstm.setTimestamp(indexParam++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            rs = pstm.executeQuery();
            if (annuel) {
                for (int i = 0; i < 12; ++i) {
                    retour.getMois().add(i);
                }
            }
            SyntheseAccidentologieLineBean lineTotal = new SyntheseAccidentologieLineBean();
            if (annuel) {
                lineTotal.setNbMois(new Integer[12]);
                for (int i = 0; i < 12; ++i) {
                    lineTotal.getNbMois()[i] = 0;
                }
            } else {
                lineTotal.setNbMois(new Integer[1]);
                lineTotal.getNbMois()[0] = 0;
            }
            lineTotal.setNom(natureAccident);
            retour.getSyntheseAccidentsLineBean().add(lineTotal);
            SyntheseAccidentologieLineBean line = null;
            HashMap<String, SyntheseAccidentologieLineBean> lignes = new HashMap<String, SyntheseAccidentologieLineBean>();
            Object natureOld = null;
            while (rs.next()) {
                int mois = rs.getInt("mois") - 1;
                if (!retour.getMois().contains(mois)) {
                    retour.getMois().add(mois);
                }
                int nb = rs.getInt("nb");
                String nature = rs.getString("nature");
                if (nature != natureOld && (line = (SyntheseAccidentologieLineBean)lignes.get(nature)) == null) {
                    line = new SyntheseAccidentologieLineBean();
                    line.setNom(rs.getString("nature"));
                    if (annuel) {
                        line.setNbMois(new Integer[12]);
                        for (int i = 0; i < 12; ++i) {
                            line.getNbMois()[i] = 0;
                        }
                    } else {
                        line.setNbMois(new Integer[1]);
                        line.getNbMois()[0] = 0;
                    }
                    lignes.put(nature, line);
                }
                if (annuel) {
                    line.getNbMois()[mois] = nb;
                    lineTotal.getNbMois()[mois] = lineTotal.getNbMois()[mois] + nb;
                } else {
                    line.getNbMois()[0] = nb;
                    lineTotal.getNbMois()[0] = lineTotal.getNbMois()[0] + nb;
                }
                line.setTotal(line.getTotal() + nb);
                lineTotal.setTotal(lineTotal.getTotal() + nb);
            }
            DAOUtil.close(null, pstm);
            if (ordreNatureAccident != null && ordreNatureAccident.length > 0) {
                for (String ordre : ordreNatureAccident) {
                    if (lignes.get(ordre) != null) {
                        retour.getSyntheseAccidentsLineBean().add((SyntheseAccidentologieLineBean)lignes.get(ordre));
                        continue;
                    }
                    line = new SyntheseAccidentologieLineBean();
                    line.setNom(ordre);
                    if (annuel) {
                        line.setNbMois(new Integer[12]);
                        for (int i = 0; i < 12; ++i) {
                            line.getNbMois()[i] = 0;
                        }
                    } else {
                        line.setNbMois(new Integer[1]);
                        line.getNbMois()[0] = 0;
                    }
                    retour.getSyntheseAccidentsLineBean().add(line);
                }
            } else {
                retour.getSyntheseAccidentsLineBean().addAll(lignes.values());
            }
            requete = REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_SELECT;
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_FROM;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_WHERE;
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_ACCIDENTOLOGIE_NBBLESSESTUES_GROUPBY;
            pstm = connection.prepareStatement(requete);
            try {
                libelleBlessesLegers = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.blesseslegers");
            }
            catch (Exception e) {
                libelleBlessesLegers = "blessesLegers";
            }
            try {
                libelleBlessesGraves = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.blessesgraves");
            }
            catch (Exception e) {
                libelleBlessesGraves = "blessesGraves";
            }
            try {
                libelleMorts = ConfigurationFactory.getInstance().get("synthese.accidentologie.libelle.morts");
            }
            catch (Exception e) {
                libelleMorts = "tues";
            }
            indexParam = 1;
            pstm.setString(indexParam++, libelleMorts);
            pstm.setString(indexParam++, libelleBlessesLegers);
            pstm.setString(indexParam++, libelleBlessesGraves);
            pstm.setString(indexParam++, natureAccident);
            pstm.setTimestamp(indexParam++, filtre.dateMin);
            pstm.setTimestamp(indexParam++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(indexParam++, filtre.delegation);
                pstm.setString(indexParam++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam++, filtre.centre);
                pstm.setString(indexParam++, filtre.centre);
            }
            rs = pstm.executeQuery();
            SyntheseAccidentologieLineBean lineBlesses = new SyntheseAccidentologieLineBean();
            retour.getSyntheseAccidentsLineBean().add(lineBlesses);
            lineBlesses.setNom(libelleBlessesLegers);
            SyntheseAccidentologieLineBean lineMorts = new SyntheseAccidentologieLineBean();
            retour.getSyntheseAccidentsLineBean().add(lineMorts);
            lineMorts.setNom(libelleMorts);
            if (annuel) {
                lineBlesses.setNbMois(new Integer[12]);
                lineMorts.setNbMois(new Integer[12]);
                for (int i = 0; i < 12; ++i) {
                    lineBlesses.getNbMois()[i] = 0;
                    lineMorts.getNbMois()[i] = 0;
                }
            } else {
                lineBlesses.setNbMois(new Integer[1]);
                lineBlesses.getNbMois()[0] = 0;
                lineMorts.setNbMois(new Integer[1]);
                lineMorts.getNbMois()[0] = 0;
            }
            while (rs.next()) {
                int mois = rs.getInt("mois") - 1;
                int nbblesses = rs.getInt("nbblesses");
                int nbtues = rs.getInt("nbtues");
                lineBlesses.setTotal(lineBlesses.getTotal() + nbblesses);
                if (annuel) {
                    lineBlesses.getNbMois()[mois] = nbblesses;
                    lineMorts.getNbMois()[mois] = nbtues;
                } else {
                    lineBlesses.getNbMois()[0] = nbblesses;
                    lineMorts.getNbMois()[0] = nbtues;
                }
                lineMorts.setTotal(lineMorts.getTotal() + nbtues);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    public Map<Integer, Integer> getNbAccidentsMortelsCorporels(IBusinessService.EvenementFiltre filtre, String type) {
        HashMap<Integer, Integer> retour = new HashMap<Integer, Integer>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String natureAccident;
            try {
                natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident");
            }
            catch (Exception e) {
                natureAccident = "acc";
            }
            connection = this.daoFactory.getConnection();
            String requete = REQUETE_NB_TUES_SELECT;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + " WHERE ae.champ = ? AND ae.valeur like ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND e.sta BETWEEN ? AND ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) ";
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_NB_TUES_GROUPBY;
            pstm = connection.prepareStatement(requete);
            int index = 1;
            pstm.setString(index++, natureAccident);
            pstm.setString(index++, "%" + type + "%");
            pstm.setInt(index++, 5);
            pstm.setTimestamp(index++, filtre.dateMin);
            pstm.setTimestamp(index++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(index++, filtre.delegation);
                pstm.setString(index++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(index++, filtre.centre);
                pstm.setString(index++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            for (int i = 0; i < 12; ++i) {
                retour.put(i, 0);
            }
            while (rs.next()) {
                int nb = rs.getInt("nb");
                int mois = rs.getInt("mois") - 1;
                retour.put(mois, nb);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    public Map<String, Integer> getNbAccidentsMortelsCorporelsParAxe(IBusinessService.EvenementFiltre filtre, String type) {
        HashMap<String, Integer> retour = new HashMap<String, Integer>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            String natureAccident;
            try {
                natureAccident = ConfigurationFactory.getInstance().get("synthese.accidentologie.champ.natureaccident");
            }
            catch (Exception e) {
                natureAccident = "acc";
            }
            connection = this.daoFactory.getConnection();
            String requete = REQUETE_NB_TUES_CORPORELS_AXE_SELECT;
            if (filtre.delegation != null || filtre.centre != null) {
                requete = requete + " JOIN prism.utilisateur u ON e2.id_utilisateur=u.id_utilisateur ";
            }
            requete = requete + " WHERE ae.champ = ? AND ae.valeur like ? AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND e.sta BETWEEN ? AND ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) ";
            if (filtre.delegation != null) {
                requete = requete + " AND (district=? OR u.delegation=?)";
            }
            if (filtre.centre != null) {
                requete = requete + " AND (cei=? OR u.centre=?)";
            }
            requete = requete + REQUETE_NB_TUES_CORPORELS_AXE_GROUPBY;
            pstm = connection.prepareStatement(requete);
            int index = 1;
            pstm.setString(index++, natureAccident);
            pstm.setString(index++, "%" + type + "%");
            pstm.setInt(index++, 5);
            pstm.setTimestamp(index++, filtre.dateMin);
            pstm.setTimestamp(index++, filtre.dateMax);
            if (filtre.delegation != null) {
                pstm.setString(index++, filtre.delegation);
                pstm.setString(index++, filtre.delegation);
            }
            if (filtre.centre != null) {
                pstm.setString(index++, filtre.centre);
                pstm.setString(index++, filtre.centre);
            }
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                int nb = rs.getInt("nb");
                String mois = rs.getString("route");
                if (mois == null) {
                    mois = "";
                }
                retour.put(mois, nb);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    public Map<String, Map<Integer, Integer>> getNbAppels(IBusinessService.EvenementFiltre filtre) {
        HashMap<String, Map<Integer, Integer>> retour = new HashMap<String, Map<Integer, Integer>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = REQUETE_NB_APPELS_DEBUT;
            if (filtre.delegation != null) {
                requete = requete + " AND district=?";
            }
            if (filtre.centre != null) {
                requete = requete + " AND cei=?";
            }
            requete = requete + REQUETE_NB_APPELS_FIN;
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, 5);
            pstm.setTimestamp(2, filtre.dateMin);
            pstm.setTimestamp(3, filtre.dateMax);
            int indexParam = 4;
            if (filtre.delegation != null) {
                pstm.setString(indexParam, filtre.delegation);
                ++indexParam;
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam, filtre.centre);
                ++indexParam;
            }
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                String valeur = rs.getString("valeur");
                int nb = rs.getInt("nb");
                int mois = rs.getInt("mois") - 1;
                if (valeur.contains(";")) {
                    String[] valeurs;
                    for (String val : valeurs = valeur.split(";")) {
                        Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                        if (retour.containsKey(val)) {
                            mapMois = (Map)retour.get(val);
                        }
                        mapMois.put(mois, nb);
                        retour.put(val, mapMois);
                    }
                    continue;
                }
                Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                if (retour.containsKey(valeur)) {
                    mapMois = (Map)retour.get(valeur);
                }
                mapMois.put(mois, nb);
                retour.put(valeur, mapMois);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    public Map<String, Map<Integer, Integer>> getNbArretes(int annee) {
        HashMap<String, Map<Integer, Integer>> retour = new HashMap<String, Map<Integer, Integer>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT DISTINCT(valeur), COUNT(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 WHERE ae.champ = 'emetteur' AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND date_part('year',e.sta) = ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) GROUP BY valeur, mois ORDER BY mois, valeur ASC");
            pstm.setInt(1, 5);
            pstm.setInt(2, annee);
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                String valeur = rs.getString("valeur");
                int nb = rs.getInt("nb");
                int mois = rs.getInt("mois") - 1;
                if (valeur.contains(";")) {
                    String[] valeurs;
                    for (String val : valeurs = valeur.split(";")) {
                        Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                        if (retour.containsKey(val)) {
                            mapMois = (Map)retour.get(val);
                        }
                        mapMois.put(mois, nb);
                        retour.put(val, mapMois);
                    }
                    continue;
                }
                Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                if (retour.containsKey(valeur)) {
                    mapMois = (Map)retour.get(valeur);
                }
                mapMois.put(mois, nb);
                retour.put(valeur, mapMois);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    public Map<String, Map<Integer, Integer>> getNbManifestations(int annee) {
        HashMap<String, Map<Integer, Integer>> retour = new HashMap<String, Map<Integer, Integer>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT DISTINCT(valeur), COUNT(valeur) as nb, date_part('month',e2.sta) as mois FROM attribut_evenement ae, evenement e2 WHERE ae.champ = 'emetteur' AND e2.k_eventid = ae.k_eventid AND (e2.snm, e2.erf, e2.vnm) IN (SELECT e.snm, e.erf, MAX(e.vnm) as vnm FROM prism.evenement e where nature IN (SELECT np.code FROM nature_perso np WHERE np.code_module_metier = ?) AND date_part('year',e.sta) = ? AND e.can <> 'Y' GROUP BY e.snm, e.erf) GROUP BY valeur, mois ORDER BY mois, valeur ASC");
            pstm.setInt(1, 5);
            pstm.setInt(2, annee);
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                String valeur = rs.getString("valeur");
                int nb = rs.getInt("nb");
                int mois = rs.getInt("mois") - 1;
                if (valeur.contains(";")) {
                    String[] valeurs;
                    for (String val : valeurs = valeur.split(";")) {
                        Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                        if (retour.containsKey(val)) {
                            mapMois = (Map)retour.get(val);
                        }
                        mapMois.put(mois, nb);
                        retour.put(val, mapMois);
                    }
                    continue;
                }
                Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                if (retour.containsKey(valeur)) {
                    mapMois = (Map)retour.get(valeur);
                }
                mapMois.put(mois, nb);
                retour.put(valeur, mapMois);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    @Override
    public List<String> verificationEtatEvenementPrevisionnel() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("UPDATE prism.evenement SET forevent='N',mst=now(),lu='0' WHERE etat=1 and forevent='Y' and sta < now() returning erf");
            pstm.execute();
            ResultSet rs = pstm.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    ret.add(rs.getString("erf"));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public PatrouilleSemaineList getPatrouilleSemaineBean(Timestamp debut, Timestamp fin) {
        PatrouilleSemaineList retour;
        PreparedStatement pstm;
        Connection connection;
        block15: {
            connection = null;
            pstm = null;
            retour = new PatrouilleSemaineList();
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(REQUETE_GET_PATROUILLE_SEMAINE);
                pstm.setTimestamp(1, debut);
                pstm.setTimestamp(2, fin);
                ResultSet rs = pstm.executeQuery();
                Log.debug(pstm);
                if (rs == null) break block15;
                int annee = -1;
                int semaine = -1;
                String delegation = "";
                PatrouilleSemaineBean patrouilleSemaineBean = null;
                PatrouilleSemaineDelegationBean delegationBean = null;
                while (rs.next()) {
                    if (!retour.getDelegations().contains(rs.getString("delegation"))) {
                        retour.addDelegation(rs.getString("delegation"));
                        retour.initCentre(rs.getString("delegation"));
                    }
                    if (!((ArrayList)retour.getCentres().get(rs.getString("delegation"))).contains(rs.getString("centre"))) {
                        retour.addCentre(rs.getString("delegation"), rs.getString("centre"));
                    }
                    if (annee != rs.getInt("annee") || semaine != rs.getInt("numsemaine")) {
                        if (delegationBean != null) {
                            patrouilleSemaineBean.addDelegationBean(delegationBean);
                        }
                        if (patrouilleSemaineBean != null) {
                            retour.addPatrouilleSemaineBean(patrouilleSemaineBean);
                        }
                        patrouilleSemaineBean = new PatrouilleSemaineBean();
                        patrouilleSemaineBean.setAnnee(rs.getInt("annee"));
                        patrouilleSemaineBean.setNumSemaine(rs.getInt("numsemaine"));
                        annee = rs.getInt("annee");
                        semaine = rs.getInt("numsemaine");
                        delegation = rs.getString("delegation");
                        delegationBean = new PatrouilleSemaineDelegationBean();
                        delegationBean.setNomDelegation(rs.getString("delegation"));
                        delegation = rs.getString("delegation");
                    } else if (rs.getString("delegation") != null && delegation == null || delegation != null && (rs.getString("delegation") == null || !delegation.equals(rs.getString("delegation")))) {
                        if (delegationBean != null) {
                            patrouilleSemaineBean.addDelegationBean(delegationBean);
                        }
                        delegationBean = new PatrouilleSemaineDelegationBean();
                        delegationBean.setNomDelegation(rs.getString("delegation"));
                        delegation = rs.getString("delegation");
                    }
                    PatrouilleSemaineCentreBean centreBean = new PatrouilleSemaineCentreBean(rs.getString("centre"), rs.getInt("nbpatrouille"), 0, 0);
                    delegationBean.addCentre(centreBean);
                }
                if (delegationBean != null) {
                    patrouilleSemaineBean.addDelegationBean(delegationBean);
                }
                if (patrouilleSemaineBean != null) {
                    retour.addPatrouilleSemaineBean(patrouilleSemaineBean);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm);
        Log.debug(retour.toString());
        retour = this.getEvenenementSemaineCrees(retour, debut, fin);
        retour = this.getEvenenementSemaineClotures(retour, debut, fin);
        return retour;
    }

    public PatrouilleSemaineList getEvenenementSemaineCrees(PatrouilleSemaineList retour, Timestamp debut, Timestamp fin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_GET_EVENEMENT_SEMAINE_CREES);
            pstm.setTimestamp(1, debut);
            pstm.setTimestamp(2, fin);
            ResultSet rs = pstm.executeQuery();
            Log.debug(pstm);
            if (rs != null) {
                int annee = -1;
                int semaine = -1;
                String delegation = "";
                PatrouilleSemaineBean patrouilleSemaineBean = null;
                while (rs.next()) {
                    PatrouilleSemaineDelegationBean delegationBean = null;
                    if (!retour.getDelegations().contains(rs.getString("delegation"))) {
                        retour.addDelegation(rs.getString("delegation"));
                        retour.initCentre(rs.getString("delegation"));
                    }
                    if (!((ArrayList)retour.getCentres().get(rs.getString("delegation"))).contains(rs.getString("centre"))) {
                        retour.addCentre(rs.getString("delegation"), rs.getString("centre"));
                    }
                    if (annee == rs.getInt("annee") && semaine == rs.getInt("numsemaine")) continue;
                    for (PatrouilleSemaineBean bean : retour.getPatrouilleSemaineBeanList()) {
                        if (bean.getAnnee() != rs.getInt("annee") || bean.getNumSemaine() != rs.getInt("numsemaine")) continue;
                        patrouilleSemaineBean = bean;
                    }
                    if (patrouilleSemaineBean == null) {
                        patrouilleSemaineBean = new PatrouilleSemaineBean();
                        patrouilleSemaineBean.setAnnee(rs.getInt("annee"));
                        patrouilleSemaineBean.setNumSemaine(rs.getInt("numsemaine"));
                        retour.addPatrouilleSemaineBean(patrouilleSemaineBean);
                    }
                    for (PatrouilleSemaineBean bean : patrouilleSemaineBean.getDelegationsBean()) {
                        if (!bean.getNomDelegation().equals(rs.getString("delegation"))) continue;
                        delegationBean = bean;
                    }
                    if (delegationBean == null) {
                        delegationBean = new PatrouilleSemaineDelegationBean();
                        delegationBean.setNomDelegation(rs.getString("delegation"));
                        patrouilleSemaineBean.addDelegationBean(delegationBean);
                    }
                    PatrouilleSemaineCentreBean centreBean = null;
                    for (PatrouilleSemaineCentreBean bean : delegationBean.getCentres()) {
                        if (!bean.getNomCentre().equals(rs.getString("centre"))) continue;
                        centreBean = bean;
                    }
                    if (centreBean != null) {
                        centreBean.setNbEvtsCrees(rs.getInt("nb_evt_crees"));
                        continue;
                    }
                    centreBean = new PatrouilleSemaineCentreBean(rs.getString("centre"), 0, rs.getInt("nb_evt_crees"), 0);
                    delegationBean.addCentre(centreBean);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        Log.debug(retour.toString());
        return retour;
    }

    public PatrouilleSemaineList getEvenenementSemaineClotures(PatrouilleSemaineList retour, Timestamp debut, Timestamp fin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_GET_EVENEMENT_SEMAINE_CLOTURES);
            pstm.setTimestamp(1, debut);
            pstm.setTimestamp(2, fin);
            ResultSet rs = pstm.executeQuery();
            Log.debug(pstm);
            if (rs != null) {
                int annee = -1;
                int semaine = -1;
                String delegation = "";
                PatrouilleSemaineBean patrouilleSemaineBean = null;
                while (rs.next()) {
                    PatrouilleSemaineDelegationBean delegationBean = null;
                    if (!retour.getDelegations().contains(rs.getString("delegation"))) {
                        retour.addDelegation(rs.getString("delegation"));
                        retour.initCentre(rs.getString("delegation"));
                    }
                    if (!((ArrayList)retour.getCentres().get(rs.getString("delegation"))).contains(rs.getString("centre"))) {
                        retour.addCentre(rs.getString("delegation"), rs.getString("centre"));
                    }
                    if (annee == rs.getInt("annee") && semaine == rs.getInt("numsemaine")) continue;
                    for (PatrouilleSemaineBean bean : retour.getPatrouilleSemaineBeanList()) {
                        if (bean.getAnnee() != rs.getInt("annee") || bean.getNumSemaine() != rs.getInt("numsemaine")) continue;
                        patrouilleSemaineBean = bean;
                    }
                    if (patrouilleSemaineBean == null) {
                        patrouilleSemaineBean = new PatrouilleSemaineBean();
                        patrouilleSemaineBean.setAnnee(rs.getInt("annee"));
                        patrouilleSemaineBean.setNumSemaine(rs.getInt("numsemaine"));
                        retour.addPatrouilleSemaineBean(patrouilleSemaineBean);
                    }
                    for (PatrouilleSemaineBean bean : patrouilleSemaineBean.getDelegationsBean()) {
                        if (!bean.getNomDelegation().equals(rs.getString("delegation"))) continue;
                        delegationBean = bean;
                    }
                    if (delegationBean == null) {
                        delegationBean = new PatrouilleSemaineDelegationBean();
                        delegationBean.setNomDelegation(rs.getString("delegation"));
                        patrouilleSemaineBean.addDelegationBean(delegationBean);
                    }
                    PatrouilleSemaineCentreBean centreBean = null;
                    for (PatrouilleSemaineCentreBean bean : delegationBean.getCentres()) {
                        if (!bean.getNomCentre().equals(rs.getString("centre"))) continue;
                        centreBean = bean;
                    }
                    if (centreBean != null) {
                        centreBean.setNbEvtsClotures(rs.getInt("nb_evt_clotures"));
                        continue;
                    }
                    centreBean = new PatrouilleSemaineCentreBean(rs.getString("centre"), 0, 0, rs.getInt("nb_evt_clotures"));
                    delegationBean.addCentre(centreBean);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        Log.debug(retour.toString());
        return retour;
    }

    @Override
    public EvenementTriListe getEvenementTriListe(String codeNature) {
        Connection connection = null;
        PreparedStatement pstm = null;
        EvenementTriListe ret = new EvenementTriListe();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_EVENEMENT_TRI_LISTE);
            pstm.setString(1, codeNature);
            pstm.execute();
            ResultSet rs = pstm.getResultSet();
            EvenementTri evtTri = null;
            if (rs != null) {
                while (rs.next()) {
                    int id = rs.getInt("id_evenement_tri_liste");
                    String nature = rs.getString("code_nature");
                    String composant = rs.getString("nom_composant");
                    int ordre = rs.getInt("ordre_tri");
                    int sens = rs.getInt("sens_tri");
                    EvenementTri evtTriCourant = new EvenementTri(id, nature, composant, ordre, sens);
                    if (evtTri != null) {
                        evtTri.setSubTri(evtTriCourant);
                    }
                    evtTri = evtTriCourant;
                }
            }
            ret.setEvenementTri(evtTri);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public Map<String, EvenementTriListe> getEvenementTriListe() {
        Connection connection = null;
        PreparedStatement pstm = null;
        HashMap<String, EvenementTriListe> ret = new HashMap<String, EvenementTriListe>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_EVENEMENT_TRI_LISTE_COMPLET);
            pstm.execute();
            ResultSet rs = pstm.getResultSet();
            EvenementTri evtTri = null;
            String natureEnCours = null;
            if (rs != null) {
                while (rs.next()) {
                    int id = rs.getInt("id_evenement_tri_liste");
                    String nature = rs.getString("code_nature");
                    String composant = rs.getString("nom_composant");
                    int ordre = rs.getInt("ordre_tri");
                    int sens = rs.getInt("sens_tri");
                    EvenementTri evtTriCourant = new EvenementTri(id, nature, composant, ordre, sens);
                    if (natureEnCours == null) {
                        natureEnCours = nature;
                    }
                    if (!natureEnCours.equals(nature)) {
                        EvenementTriListe evtTriListe = new EvenementTriListe();
                        evtTriListe.setEvenementTri(evtTri);
                        ret.put(natureEnCours, evtTriListe);
                        natureEnCours = nature;
                        evtTri = null;
                    }
                    if (evtTri != null) {
                        evtTri.setSubTri(evtTriCourant);
                    }
                    evtTri = evtTriCourant;
                }
            }
            EvenementTriListe evtTriListe = new EvenementTriListe();
            evtTriListe.setEvenementTri(evtTri);
            ret.put(natureEnCours, evtTriListe);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public boolean isEvenementHasPhoto(long idEvenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        EvenementTriListe ret = new EvenementTriListe();
        boolean hasPhoto = false;
        try {
            Array photoArray;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT photos FROM prism.evenement WHERE k_eventid = ?");
            pstm.setLong(1, idEvenement);
            pstm.execute();
            ResultSet rs = pstm.getResultSet();
            if (rs != null && rs.next() && (photoArray = rs.getArray("photos")) != null) {
                String[] photos = (String[])photoArray.getArray();
                hasPhoto = photos != null && photos.length != 0;
            }
        }
        catch (Exception e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return hasPhoto;
    }

    @Override
    public Map<Integer, Integer> getNbAgents(List<Integer> listeKEventId) {
        Connection connection = null;
        PreparedStatement pstm = null;
        HashMap<Integer, Integer> retour = new HashMap<Integer, Integer>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_GET_PATROUILLES_FROM_KEVENTID);
            Array a = connection.createArrayOf("int", listeKEventId.toArray());
            pstm.setArray(1, a);
            pstm.execute();
            ResultSet rs = pstm.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    int nbAgents = 1;
                    if (!"Aucun \u00e9quipier".equals(rs.getString("equipier"))) {
                        nbAgents = StringUtils.countMatches((CharSequence)rs.getString("equipier"), (CharSequence)",") + 2;
                    }
                    retour.put(rs.getInt("k_eventid"), nbAgents);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }
}

