/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IDatex2DAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.beans.ClientVO;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import com.geolocsystems.prismcentral.beans.SuiviVH;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Datex2DAOJDBC
implements IDatex2DAO {
    private DAOFactory daoFactory;
    private static final Logger log = Logger.getLogger(Datex2DAOJDBC.class);

    public Datex2DAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public void miseAJourDateSynchro(ClientVO client) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "update datex2.client_datex2 set date_synchro = now() where zone_routiere = ? and identifiant = ?";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, client.getZoneRoutiere());
            pstm.setString(2, client.getIdentifiant());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void miseAJourDateSynchroSuiviVH(SuiviVH client) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "update datex2.suivi_vh set date_synchro_vehicule = ?, date_synchro_troncon = ? where zone_routiere = ?";
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, new Timestamp(client.getDateSynchroVehicule().getTimeInMillis()));
            pstm.setTimestamp(2, new Timestamp(client.getDateSynchroTroncon().getTimeInMillis()));
            pstm.setString(3, client.getZoneRoutiere());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public SuiviVH getDateSynchroSuiviVH(String zoneRoutiere) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        SuiviVH suiviVh = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select date_synchro_vehicule, date_synchro_troncon, delai_synchro_vehicule, delai_synchro_troncon from datex2.suivi_vh where zone_routiere = ? ";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            if (!rs.next()) {
                throw new DAOException("ERREUR RECUP DATE DERNIERE SYNCHRO DATEX2");
            }
            suiviVh = new SuiviVH();
            suiviVh.setZoneRoutiere(zoneRoutiere);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(rs.getTimestamp("date_synchro_vehicule"));
            suiviVh.setDateSynchroVehicule((Calendar)cal);
            cal = new GregorianCalendar();
            cal.setTime(rs.getTimestamp("date_synchro_troncon"));
            suiviVh.setDateSynchroTroncon((Calendar)cal);
            suiviVh.setDelaiSynchroVehicule(rs.getInt("delai_synchro_vehicule"));
            suiviVh.setDelaiSynchroTroncon(rs.getInt("delai_synchro_troncon"));
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return suiviVh;
    }

    @Override
    public void miseAJourDateSynchro(FournisseurVO fournisseur) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "update datex2.fournisseur_datex2 set date_synchro = now() where zone_routiere = ? and identifiant = ?";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, fournisseur.getZoneRoutiere());
            pstm.setString(2, fournisseur.getIdentifiant());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public Calendar getDerniereDateSynchro(String zoneRoutiere) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block5: {
            connection = null;
            pstm = null;
            rs = null;
            connection = this.daoFactory.getConnection();
            String requete = "select date from datex2.date_synchro where zone_routiere = ? and champ = 'derniere_synchro' ";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            if (!rs.next()) break block5;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(rs.getTimestamp("date"));
            Calendar calendar = cal;
            DAOUtil.close(connection, pstm, rs);
            return calendar;
        }
        try {
            try {
                throw new DAOException("ERREUR RECUP DATE DERNIERE SYNCHRO DATEX2");
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
    }

    @Override
    public List<FournisseurVO> getFournisseurs(String zoneRoutiere) {
        ArrayList<FournisseurVO> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<FournisseurVO> fournisseurs = new ArrayList<FournisseurVO>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select zone_routiere,url_datex2,etat,utilisateur,password,put,identifiant,convertisseur,timeout,tempo,date_synchro from datex2.fournisseur_datex2 where zone_routiere = ? and etat = 1";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                FournisseurVO f = new FournisseurVO();
                f.setUrl(rs.getString("url_datex2"));
                f.setClasseConvertisseur(rs.getString("convertisseur"));
                f.setIdentifiant(rs.getString("identifiant"));
                f.setEtatClient(true);
                f.setTimeOutUrl(rs.getInt("timeout"));
                f.setZoneRoutiere(zoneRoutiere);
                f.setUser(rs.getString("utilisateur"));
                f.setPassword(rs.getString("password"));
                f.setTempoRealTime((long)rs.getInt("tempo"));
                Calendar cal = GregorianCalendar.getInstance();
                if (rs.getDate("date_synchro") != null) {
                    cal.setTime(rs.getTimestamp("date_synchro"));
                }
                f.setDateSynchro(cal.getTimeInMillis());
                fournisseurs.add(f);
            }
            arrayList = fournisseurs;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public Map<String, String> getCorrespondanceCodeDelegation(String zoneRoutiere) {
        HashMap<String, String> hashMap;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, String> corresCodeDelegation = new HashMap<String, String>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select nom, code from datex2.code_delegation_rattachement where zone = ? ";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                corresCodeDelegation.put(rs.getString("code"), rs.getString("nom"));
            }
            hashMap = corresCodeDelegation;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return hashMap;
    }

    @Override
    public List<ClientVO> getClients(String zoneRoutiere) {
        ArrayList<ClientVO> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<ClientVO> clients = new ArrayList<ClientVO>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select zone_routiere,url_datex2,etat,utilisateur,password,put,identifiant,convertisseur,timeout,tempo,date_synchro from datex2.client_datex2 where zone_routiere = ? and etat = 1";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                ClientVO f = new ClientVO();
                f.setUrl(rs.getString("url_datex2"));
                f.setClasseConvertisseur(rs.getString("convertisseur"));
                f.setIdentifiant(rs.getString("identifiant"));
                f.setEtatClient(true);
                f.setTimeOutUrl(rs.getInt("timeout"));
                f.setZoneRoutiere(zoneRoutiere);
                f.setUser(rs.getString("utilisateur"));
                f.setPassword(rs.getString("password"));
                f.setTempoRealTime((long)rs.getInt("tempo"));
                Calendar cal = GregorianCalendar.getInstance();
                if (rs.getDate("date_synchro") != null) {
                    cal.setTime(rs.getTimestamp("date_synchro"));
                }
                f.setDateSynchro(cal.getTimeInMillis());
                clients.add(f);
            }
            arrayList = clients;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public Map<String, CorrespondanceDatex2> getMapDescriptionPrismDatex2(String zoneRoutiere) {
        HashMap<String, CorrespondanceDatex2> hashMap;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, CorrespondanceDatex2> descPrismDatex2 = new HashMap<String, CorrespondanceDatex2>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select dnd.zone_routiere,description,definition_datex2,type, nature, libelle from datex2.description_nature_datex2 dnd , prism.description_nature_perso dnp where dnd.zone_routiere = ? and dnp.zone_routiere = ? and dnp.code = dnd.description";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            pstm.setString(2, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                CorrespondanceDatex2 c = new CorrespondanceDatex2();
                c.setDefinitionDatex2(rs.getString("definition_datex2"));
                c.setDescription(rs.getString("description"));
                c.setType(rs.getString("type"));
                c.setNature(rs.getString("nature"));
                c.setLibelle(rs.getString("libelle"));
                descPrismDatex2.put(c.getDescription(), c);
            }
            hashMap = descPrismDatex2;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return hashMap;
    }

    @Override
    public Map<String, CorrespondanceDatex2> getMapDescriptionDatex2Prism(String zoneRoutiere) {
        HashMap<String, CorrespondanceDatex2> hashMap;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, CorrespondanceDatex2> descPrismDatex2 = new HashMap<String, CorrespondanceDatex2>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select dnd.zone_routiere,description,definition_datex2,type, nature, libelle from datex2.description_nature_datex2 dnd , prism.description_nature_perso dnp where dnd.zone_routiere = ? and dnp.zone_routiere = ? and dnp.code = dnd.description";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            pstm.setString(2, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                CorrespondanceDatex2 c = new CorrespondanceDatex2();
                c.setDefinitionDatex2(rs.getString("definition_datex2"));
                c.setDescription(rs.getString("description"));
                c.setType(rs.getString("type"));
                c.setNature(rs.getString("nature"));
                c.setLibelle(rs.getString("libelle"));
                descPrismDatex2.put(c.getDefinitionDatex2(), c);
            }
            hashMap = descPrismDatex2;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return hashMap;
    }

    @Override
    public List<Evenement> getListeEvtsASynchroniser(String zoneRoutiere) {
        ArrayList<Evenement> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Evenement> listeEvts = new ArrayList<Evenement>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select zone_routiere,k_eventid,inp, erf from datex2.synchro_evenement where zone_routiere = ? order by inp desc ";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, zoneRoutiere);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Evenement evt = new Evenement();
                evt.setkEventid(rs.getInt("k_eventid"));
                evt.setIdReference(rs.getString("erf"));
                listeEvts.add(evt);
            }
            arrayList = listeEvts;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public void ajouterEvenementASynchroniser(Evenement evenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "delete from datex2.synchro_evenement where erf=?";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, evenement.getIdReference());
            pstm.execute();
            pstm.close();
            requete = "insert into datex2.synchro_evenement (k_eventid,erf,inp,zone_routiere) values (?,?,?,?)";
            pstm = connection.prepareStatement(requete);
            pstm.setLong(1, evenement.getkEventid());
            pstm.setString(2, evenement.getIdReference());
            pstm.setTimestamp(3, new Timestamp(evenement.getDateMaj()));
            String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
            pstm.setString(4, zr);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteListeEvtsASynchroniser(List<Integer> listeEvts) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean autoCommit = true;
        try {
            connection = this.daoFactory.getConnection();
            autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            String requete2332 = "delete from datex2.synchro_evenement where k_eventid = ?";
            pstm = connection.prepareStatement(requete2332);
            Iterator<Integer> iterator = listeEvts.iterator();
            while (iterator.hasNext()) {
                long id = iterator.next().intValue();
                pstm.setLong(1, id);
                pstm.addBatch();
            }
            int[] count = pstm.executeBatch();
            connection.commit();
            pstm.close();
            connection.close();
        }
        catch (SQLException e) {
            try {
                try {
                    if (connection == null) throw new DAOException(e);
                    connection.setAutoCommit(autoCommit);
                    throw new DAOException(e);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.setAutoCommit(autoCommit);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        try {
            if (connection != null) {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException requete2332) {
            // empty catch block
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void deleteListeEvtsASynchroniserInactif() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            connection.setAutoCommit(false);
            String requete = "delete from datex2.synchro_evenement where inp < (now() - interval '5 minutes')";
            pstm = connection.prepareStatement(requete);
            pstm.execute();
            connection.commit();
            pstm.close();
            connection.close();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public long getNumFichier() {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            long l;
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                String requete = "select nextval('datex2.num_fichier_seq')";
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                l = rs.getLong(1);
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return l;
        }
        DAOUtil.close(connection, pstm, rs);
        return -1L;
    }
}

