/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IAnonymisation;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AnonymisationDAOJDBC
implements IAnonymisation {
    private DAOFactory daoFactory;
    private IReferentielDAO refDAO;

    public AnonymisationDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
    }

    @Override
    public boolean isAuthorise() {
        return false;
    }

    @Override
    public boolean isConfirme() {
        return false;
    }

    private int getDureeAnonymisation() {
        return this.refDAO.getConfiguration().getInt("dureeAnonymisation", -1);
    }

    private void verificationAnonymisation() {
        Log.info("V\u00e9rification utilisateurs syst\u00e8mes : Anonymisation");
        String requete = "select prism.maj_system_user();";
        Connection connection = null;
        PreparedStatement pstm = null;
        Object rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.execute();
        }
        catch (Exception e) {
            try {
                Log.error("ERR ANONIMISATION VERIFICATION", e);
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, null);
    }

    @Override
    public void anonymisationEvenements() {
        block5: {
            block4: {
                int dureeAnonymisation = this.getDureeAnonymisation();
                if (dureeAnonymisation <= 0) break block4;
                Log.info("Anonymisation des \u00e9v\u00e8nements de plus de  " + dureeAnonymisation + " jours");
                String requete = "update prism.evenement set id_createur = (select id_utilisateur from prism.utilisateur where sna = concat('#',coalesce(evenement.cei,''))),id_utilisateur = (select id_utilisateur from prism.utilisateur where sna = concat('#',coalesce(evenement.cei,''))) from utilisateur u2 where u2.id_utilisateur = evenement.id_utilisateur and evenement.inp < (now() - ?::interval) and u2.systeme = 0";
                Connection connection = null;
                PreparedStatement pstm = null;
                Object rs = null;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, String.valueOf(dureeAnonymisation).concat(" days"));
                    Log.debug("anonymisationEvenements - " + pstm.toString());
                    pstm.execute();
                }
                catch (Exception e) {
                    try {
                        Log.error("ERR ANONIMISATION EVENEMENT", e);
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, null);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, null);
                break block5;
            }
            Log.info("Anonymisation d\u00e9sactiv\u00e9e : evenement");
        }
    }

    @Override
    public void anonymisationEvenements(PrismCentralUser u) {
        block5: {
            block4: {
                if (u == null) break block4;
                String requete = "update prism.evenement set id_utilisateur = (select id_utilisateur from prism.utilisateur where sna = concat('#',coalesce(?,''))) where evenement.id_utilisateur = ?";
                Connection connection = null;
                PreparedStatement pstm = null;
                Object rs = null;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, u.getCentre());
                    pstm.setInt(2, u.getId());
                    pstm.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, null);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, null);
                break block5;
            }
            Log.info("Anonymisation d\u00e9sactiv\u00e9e : evenement");
        }
    }

    @Override
    public void anonymisationMainCourante() {
        block5: {
            block4: {
                int dureeAnonymisation = this.getDureeAnonymisation();
                if (dureeAnonymisation <= 0) break block4;
                Log.info("Anonymisation des main courantes de plus de  " + dureeAnonymisation + " jours");
                String requete = "update prism.mcig as m set id_utilisateur = (select u.id_utilisateur from prism.utilisateur u where u.sna = concat('#',coalesce(u2.centre,''))),imei=null,telephone=null from utilisateur u2 where u2.id_utilisateur = m.id_utilisateur and  m.date_heure_deb < (now() - ?::interval) and u2.systeme = 0";
                Connection connection = null;
                PreparedStatement pstm = null;
                Object rs = null;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, String.valueOf(dureeAnonymisation).concat(" days"));
                    Log.debug("anonymisationMaincourante - " + pstm.toString());
                    pstm.execute();
                }
                catch (Exception e) {
                    try {
                        Log.error("ERR ANONIMISATION MAIN COURANTE", e);
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, null);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, null);
                break block5;
            }
            Log.info("Anonymisation d\u00e9sactiv\u00e9e : mcig");
        }
    }

    @Override
    public void anonymisationMainCourante(PrismCentralUser u) {
        block5: {
            block4: {
                if (u == null) break block4;
                String requete = "update prism.mcig as m set id_utilisateur = (select u.id_utilisateur from prism.utilisateur u where u.sna = concat('#',coalesce(?,''))),imei = null,telephone=null where m.id_utilisateur = ?";
                Connection connection = null;
                PreparedStatement pstm = null;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, u.getCentre());
                    pstm.setInt(2, u.getId());
                    pstm.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, null);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, null);
                break block5;
            }
            Log.info("Anonymisation impossible : utilisateur null");
        }
    }

    public void anonymisationPatrouille() {
        block5: {
            block4: {
                int dureeAnonymisation = this.getDureeAnonymisation();
                if (dureeAnonymisation <= 0) break block4;
                Log.info("Anonymisation des patrouilles de plus de  " + dureeAnonymisation + " jours");
                String requete = "update prism.patrouille as p set equipier = null where p.debut < (now() - ?::interval) and not equipier is null;";
                Connection connection = null;
                PreparedStatement pstm = null;
                Object rs = null;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, String.valueOf(dureeAnonymisation).concat(" days"));
                    Log.debug("anonymisationPatrouille - " + pstm.toString());
                    pstm.execute();
                }
                catch (Exception e) {
                    try {
                        Log.error("ERR ANONIMISATION PATROUILLES", e);
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, null);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, null);
                break block5;
            }
            Log.info("Anonymisation d\u00e9sactiv\u00e9e : patrouille");
        }
    }

    @Override
    public void anonymisation() {
        Log.debug("Lancement de l'anonymisation");
        if (this.getDureeAnonymisation() > 0) {
            Log.info("Lancement de l'anonymisation des donn\u00e9es sur " + this.getDureeAnonymisation() + "jours");
            this.verificationAnonymisation();
            this.anonymisationEvenements();
            this.anonymisationPatrouille();
            this.anonymisationMainCourante();
        } else {
            Log.info("Anonymisation des donn\u00e9es d\u00e9sactiv\u00e9e");
        }
    }

    @Override
    public void anonymisation(PrismCentralUser u) {
        Log.debug("Lancement de l'anonymisation de l'utilisateur");
        if (u != null) {
            Log.info("Lancement de l'anonymisation des donn\u00e9es sur l'utilisateur " + u.getNom() + " - " + u.getCode());
            this.anonymisationEvenements(u);
            this.anonymisationMainCourante(u);
        } else {
            Log.info("Anonymisation des donn\u00e9es utilisateur impossible - utilisateur null");
        }
    }
}

