/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO;

import com.geolocsystems.prismcentral.DAO.DataSourceDAOFactory;
import com.geolocsystems.prismcentral.DAO.DataSourceWithLoginDAOFactory;
import com.geolocsystems.prismcentral.DAO.DriverManagerDAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IAnonymisation;
import com.geolocsystems.prismcentral.DAO.IDatex2DAO;
import com.geolocsystems.prismcentral.DAO.IDocumentDAO;
import com.geolocsystems.prismcentral.DAO.IEq2rDAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IExportDAO;
import com.geolocsystems.prismcentral.DAO.IFauchageDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IImportDAO;
import com.geolocsystems.prismcentral.DAO.IImportEvenementDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IPartenaireDAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IScoopDAO;
import com.geolocsystems.prismcentral.DAO.IStatsDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.IVhDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.AdminDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.AnonymisationDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.Datex2DAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.DocumentDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.Eq2rDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.EvenementsDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.ExportDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.FauchageDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.IG4DAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.IconDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.ImportDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.ImportEvenementDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.McigDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.PartenaireDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.PhotoDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.PublicationDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.ReferentielDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.ScoopDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.StatsDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.UserDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.VehiculeDAOJDBC;
import com.geolocsystems.prismcentral.DAO.Jdbc.VhDAOJDBC;
import com.geolocsystems.prismcentral.DAO.exception.DAOConfigurationException;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.outils.GLS;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public abstract class DAOFactory {
    private static final String PROPERTY_JDBC = "jdbc";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_DRIVER = "driver";
    private static final String PROPERTY_USERNAME = "username";
    private static final String PROPERTY_PASSWORD = "password";
    private static final String PROPERTY_ARCHIVE = "archive";
    private static final String PROPERTY_USE_ARCHIVE = "use";

    public static DAOFactory getInstance() throws DAOConfigurationException {
        IConfiguration properties = ConfigurationFactory.getInstance();
        boolean useArchive = properties.getBoolean("jdbc.archive.use", false);
        if (useArchive) {
            return DAOFactory.getArchiveInstance();
        }
        return DAOFactory.getBaseInstance();
    }

    public static DAOFactory getBaseInstance() throws DAOConfigurationException {
        DAOFactory instance;
        IConfiguration properties = ConfigurationFactory.getInstance();
        String url = properties.get("jdbc.url", true);
        String driverClassName = properties.get("jdbc.driver", false);
        String password = properties.get("jdbc.password", false);
        String username = properties.get("jdbc.username", password != null);
        if (!GLS.estVide((String)driverClassName)) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DAOConfigurationException("Driver class '" + driverClassName + "' is missing in classpath.", e);
            }
            instance = new DriverManagerDAOFactory(url, username, password);
        } else {
            DataSource dataSource;
            try {
                dataSource = (DataSource)new InitialContext().lookup(url);
            }
            catch (NamingException e) {
                throw new DAOConfigurationException("DataSource '" + url + "' is missing in JNDI.", e);
            }
            instance = !GLS.estVide((String)username) ? new DataSourceWithLoginDAOFactory(dataSource, username, password) : new DataSourceDAOFactory(dataSource);
        }
        return instance;
    }

    public static DAOFactory getArchiveInstance() throws DAOConfigurationException {
        DAOFactory archiveInstance;
        IConfiguration properties = ConfigurationFactory.getInstance();
        String url = properties.get("jdbc.archive.url", true);
        String driverClassName = properties.get("jdbc.archive.driver", false);
        String password = properties.get("jdbc.archive.password", false);
        String username = properties.get("jdbc.archive.username", password != null);
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DAOConfigurationException("Driver class '" + driverClassName + "' is missing in classpath.", e);
            }
            archiveInstance = new DriverManagerDAOFactory(url, username, password);
        } else {
            DataSource dataSource;
            try {
                dataSource = (DataSource)new InitialContext().lookup(url);
            }
            catch (NamingException e) {
                throw new DAOConfigurationException("DataSource '" + url + "' is missing in JNDI.", e);
            }
            archiveInstance = username != null ? new DataSourceWithLoginDAOFactory(dataSource, username, password) : new DataSourceDAOFactory(dataSource);
        }
        return archiveInstance;
    }

    public static <T> T getValueFromResultSet(ResultSet rs, String columnLabel, T defaultValue) {
        try {
            return (T)rs.getObject(columnLabel);
        }
        catch (SQLException e) {
            return defaultValue;
        }
    }

    public abstract Connection getConnection() throws SQLException;

    public IUserDAO getUserDAO(IReferentielDAO refDAO) {
        return new UserDAOJDBC(this, refDAO);
    }

    public IReferentielDAO getReferentielDAO(IIconDAO iconDal) {
        return new ReferentielDAOJDBC(this, iconDal);
    }

    public IEvenementsDAO getEvenementsDAO(IReferentielDAO referentiel, IUserDAO user, IMcigDAO mcig) {
        return new EvenementsDAOJDBC(this, referentiel, user, mcig);
    }

    public IPublicationDAO getPublicationDAO(IReferentielDAO refDAO, IVehiculeDAO vehiculeDAO, IIG4DAO ig4DAO) {
        return new PublicationDAOJDBC(this, refDAO, vehiculeDAO, ig4DAO);
    }

    public IMcigDAO getMcigDAO(IReferentielDAO refDAO, IVehiculeDAO vehiculaDAO) {
        return new McigDAOJDBC(this, refDAO, vehiculaDAO);
    }

    public IFauchageDAO getFauchageDAO() {
        return new FauchageDAOJDBC(this);
    }

    public IVehiculeDAO getVehiculeDAO(IBusinessService businessService) {
        return new VehiculeDAOJDBC(this, businessService);
    }

    public IAdminDAO getAdminDAO(IReferentielDAO referentielDAO) {
        return new AdminDAOJDBC(this, referentielDAO);
    }

    public IVhDAO getVhDAO(IReferentielDAO ref, IPublicationDAO pub) {
        return new VhDAOJDBC(this, ref, pub);
    }

    public IDatex2DAO getDatex2DAO() {
        return new Datex2DAOJDBC(this);
    }

    public IPhotoDAO getPhotoDAO() {
        return new PhotoDAOJDBC(this);
    }

    public IIconDAO getIconDAO() {
        return new IconDAOJDBC(this);
    }

    public IEq2rDAO getEq2rDAO() {
        return new Eq2rDAOJDBC(this);
    }

    public IExportDAO getExportDAO() {
        return new ExportDAOJDBC(this);
    }

    public IPartenaireDAO getPartenaireDAO() {
        return new PartenaireDAOJDBC(this);
    }

    public IIG4DAO getIG4DAO(IAdminDAO adminDAO, IReferentielDAO refDAO, IUserDAO userDAO, IEvenementsDAO evtDAO, IMcigDAO mciDAO, IVehiculeDAO vehDAO) {
        return new IG4DAOJDBC(this, adminDAO, refDAO, userDAO, evtDAO, mciDAO, vehDAO);
    }

    public IImportDAO getImportDAO() {
        return new ImportDAOJDBC(this);
    }

    public IAnonymisation getAnonymisationDAO(IReferentielDAO refDAO) {
        return new AnonymisationDAOJDBC(this, refDAO);
    }

    public IScoopDAO getScoopDAO(IAdminDAO adminDAO, IReferentielDAO refDAO, IUserDAO userDAO) {
        return new ScoopDAOJDBC(this, refDAO, adminDAO, userDAO);
    }

    public IImportEvenementDAO getImportEvenementDAO(IReferentielDAO refDAO, IEvenementsDAO evtsDAO) {
        return new ImportEvenementDAOJDBC(this, refDAO, evtsDAO);
    }

    public IDocumentDAO getDocumentDAO() {
        return new DocumentDAOJDBC(this);
    }

    public IStatsDAO getStatsDAO() {
        return new StatsDAOJDBC(this);
    }
}

