/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export.reader;

import com.geolocsystems.export.BarreauXML;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class BarreauxReaderXML
extends BarreauXML {
    private static Logger log = Logger.getLogger((String)"exportVH");
    private Element racine;
    private Document document = null;

    public BarreauxReaderXML(MapDescription parametres) {
        this.init(parametres);
        log.debug((Object)("Champ ID " + this.champId));
    }

    public BarreauxReaderXML() {
        this(null);
    }

    public List<BarreauVH> lireXML(String fichier) {
        this.racine = new Element("VH");
        this.document = new Document(this.racine);
        SAXBuilder sxb = new SAXBuilder();
        try {
            this.document = sxb.build(new File(fichier));
        }
        catch (Exception e) {
            log.error((Object)("Erreur SAXBuilder pour le fichier " + fichier), (Throwable)e);
        }
        this.racine = this.document.getRootElement();
        return this.lireBarreauVH();
    }

    private List<BarreauVH> lireBarreauVH() {
        Vector<BarreauVH> barreaux = new Vector<BarreauVH>();
        List listBarreauVH = this.racine.getChildren("Troncon");
        for (Element courant : listBarreauVH) {
            BarreauVH barreauVh = this.genererBarreau(courant);
            barreaux.add(barreauVh);
        }
        return barreaux;
    }

    private BarreauVH genererBarreau(Element eltBarreau) {
        BarreauVH barreau = new BarreauVH();
        String dateMaj = eltBarreau.getAttribute("dateMaj").getValue();
        Date date = GregorianCalendar.getInstance().getTime();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").parse(dateMaj);
        }
        catch (ParseException e) {
            log.error((Object)"Erreur parsing dateMaj", (Throwable)e);
        }
        barreau.setMajDate(date);
        barreau.setTronconID(eltBarreau.getChild(this.champId).getText());
        barreau.setStatus(eltBarreau.getChild("CCH").getText());
        barreau.setIdPatrouilleur(eltBarreau.getChild("NomPatrouilleur").getText());
        barreau.setCch2(eltBarreau.getChild("CCH2").getText());
        barreau.setCommentaire(eltBarreau.getChild("Commentaire").getText());
        barreau.setCommentaireInterne(eltBarreau.getChild("CommentaireInterne").getText());
        barreau.setEquipements(eltBarreau.getChild("Equipement").getText());
        barreau.setMeteo(eltBarreau.getChild("Meteo").getText());
        barreau.setTendanceCC(eltBarreau.getChild("TendanceCC").getText());
        barreau.setTraitement(eltBarreau.getChild("Traitement").getText());
        barreau.setEtatChaussee(eltBarreau.getChild("EtatChaussee").getText());
        barreau.setTemperature(eltBarreau.getChild("Temperature").getText());
        barreau.setVent(eltBarreau.getChild("Vent").getText());
        barreau.setSens(eltBarreau.getChild("Sens").getText());
        return barreau;
    }

    public static void main(String[] args) {
        new BarreauxReaderXML().lireXML("test/Total_04052015_140001.xml");
    }
}

