/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.data.filtrejava;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJavaSituation;
import java.util.Map;

public class FiltreJavaSituationDDP
implements FiltreJavaSituation {
    private Map<String, Nature> natures;
    private boolean accept;
    private String valeurOui = null;

    public FiltreJavaSituationDDP(Map<String, Nature> natures, boolean accept, String valeurOui) {
        this.natures = natures;
        this.accept = accept;
        this.valeurOui = valeurOui;
    }

    @Override
    public boolean accept(Situation s) {
        return this.acceptInterne(s) == this.accept;
    }

    public boolean acceptInterne(Situation s) {
        if (MetierCommun.estDDP(s, this.natures)) {
            return true;
        }
        if (this.valeurOui == null) {
            return false;
        }
        if (s.getEvenements() == null || s.getEvenements().size() == 0) {
            return false;
        }
        for (Evenement e : s.getEvenements()) {
            try {
                ValeurChamp vc = MetierCommun.getValeurChamp(e.getValeurNature().getValeurs(), "ddp-ddp");
                if (vc == null || !(vc instanceof ValeurChampCollectionChoixUnique)) continue;
                return this.valeurOui.equals(((ValeurChampCollectionChoixUnique)vc).getValeur());
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

