/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.data;

import com.geolocsystems.prismandroid.IFiltreFauchage;
import com.geolocsystems.prismandroid.IFiltreReleve;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IExportService {
    public static final String SAUTDELIGNE_FICHIER_EXPORT = "\n";

    public InputStream exportMCIG(List<MCIG> var1, String var2);

    public InputStream exportFauchage(List<IFiltreFauchage> var1, String var2);

    public InputStream exportReleve(List<IFiltreReleve> var1, String var2);

    public List<String> getMCIGExportFormat();

    public List<String> getFauchageExportFormat();

    public InputStream exportSituation(Object var1, String var2, PrismCentralUser var3, List<String[]> var4, String var5, Map<String, Object> var6, String var7);

    public InputStream exportBarreauVHHisto(List<BarreauVHHisto> var1, String var2, Map<String, Object> var3, String var4, String var5, Date var6, Date var7, HashMap<String, String> var8);

    public InputStream exportFauchageHisto(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> var1, String var2, Map<String, Object> var3, String var4, String var5, String var6);

    public InputStream exportSchemaRoutierHisto(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> var1, String var2, Map<String, Object> var3, String var4, String var5);

    public static class FORMATS {
        public static final String TOUTE_NATURE = "*";
        public static final int FORMATS_DEBROUSSAILLAGE = 3;
        public static final int FORMATS_EVENEMENTS = 0;
        public static final int FORMATS_FAUCHAGE = 1;
        public static final int FORMATS_MAINCOURANTE = 2;
        public static final int FORMATS_DEFAUT = -1;
        public static final int FORMATS_BARREAU_VH = 4;
        public static final String ODT = "ODT";
        public static final String PDF = "PDF";
        public static final String XLS = "XLS";
        public static final String DOC = "DOC";
        public static final String ZIP = "ZIP";
        public static final String CSV = "CSV";
        public static final String SHP = "SHP";
        public static final String XLSX = "XLSX";
        public static final String TYPE_PHOTOS = "photos";
        public static final String TYPE_BIRT = "birt";
        public static final String TYPE_BIRT_TABLEAU = "birt-tableau";
        public static final String TYPE_BIRT_TABLEAU_IMAGE = "birt-tableau-image";
        public static final String TYPE_BIRT_HISTORIQUE = "birt-historique";
        public static final String TYPE_CSV = "csv";
        public static final String TYPE_ODT = "odt";
        public static final String TYPE_APACHE_POI = "apache-poi";
        public static final String TYPE_APACHE_POI_TEST = "apache-poi-test";
        public static final Object TYPE_RAPPORT_CONSTAT = "rapport-constat";
        public static final String TYPE_CARTOGRAPHIE = "cartographie";
        public static final String FICHE_EVT = "Fiche d\u00e9taill\u00e9e";
        public static final String FICHE_TRAVAIL = "Fiche travail";
        public static final String FICHIER_PLAT = "Fichier \u00e0 plat";
        public static final String FICHIER_PDF = "Fichier PDF";
        public static final String FICHIER_SHP = "Fichier Shape";
        public static final String DOCUMENT_FICHE_EVT_DEFAUT = "fiche_evt.odt";
        public static final String DOCUMENT_FICHE_TRAVAIL_DEFAUT = "fiche_travail.rptdesign";
        public static final String CODE_FICHE_TRAVAIL = "ficheTravail";
        public static final String CODE_FICHE_DETAILLEE = "ficheDetaillee";
        public static final String LIBELLE_FICHE = "libelle";
        public static final String FICHIER_CSV = FORMATS.getLibelle("Fichier \u00e0 plat", "CSV");
        public static final String FICHE_PDF = FORMATS.getLibelle("Fichier PDF", "PDF");
        public static final String FICHE_EVT_ODT = FORMATS.getLibelle("Fiche d\u00e9taill\u00e9e", "ODT");
        public static final String FICHE_EVT_PDF = FORMATS.getLibelle("Fiche d\u00e9taill\u00e9e", "PDF");
        public static final String FICHE_TRAVAIL_ODT = FORMATS.getLibelle("Fiche travail", "ODT");
        public static final String FICHE_TRAVAIL_PDF = FORMATS.getLibelle("Fiche travail", "PDF");
        public static final String FICHE_TRAVAIL_DOC = FORMATS.getLibelle("Fiche travail", "DOC");
        public static final String FICHIER_SHAPE = FORMATS.getLibelle("Fichier Shape", "ZIP");
        public static final String PHOTOS = "PHOTOS - ZIP";
        private static List<String> evenement = new ArrayList<String>(){
            {
                this.add(FICHE_EVT_PDF);
                this.add(FICHE_EVT_ODT);
                this.add(FICHE_TRAVAIL_ODT);
                this.add(FICHE_TRAVAIL_DOC);
                this.add(FICHE_TRAVAIL_PDF);
                this.add(FICHIER_CSV);
                this.add(FORMATS.PHOTOS);
            }
        };
        private static List<String> defaut = new ArrayList<String>(){
            {
                this.add(FICHE_PDF);
                this.add(FICHIER_CSV);
            }
        };
        private static List<String> fauchage = new ArrayList<String>(){
            {
                this.add(FICHIER_CSV);
                this.add(FICHE_PDF);
            }
        };
        private static List<String> debroussaillage = new ArrayList<String>(){
            {
                this.add(FICHIER_SHAPE);
                this.add(FICHIER_CSV);
            }
        };
        private static List<String> maincourante = new ArrayList<String>(){
            {
                this.add(FICHIER_CSV);
                this.add(FICHE_PDF);
            }
        };

        private static String getLibelle(String nom, String format) {
            return nom.concat(" - ").concat(format);
        }

        public static String getExtension(String format) {
            if (format.length() > 3 && format.substring(format.length() - 4).toLowerCase().equals("xlsx")) {
                return format.substring(format.length() - 4).toLowerCase();
            }
            return format.substring(format.length() - 3).toLowerCase();
        }

        public static boolean estPDF(String format) {
            return format.endsWith(PDF);
        }

        public static boolean estODT(String format) {
            return format.endsWith(ODT);
        }

        public static boolean estSHP(String format) {
            return format.endsWith(SHP);
        }

        public static boolean estCSV(String format) {
            return format.endsWith(CSV);
        }

        public static boolean estZIP(String format) {
            return format.endsWith(ZIP);
        }

        public static boolean estXLS(String format) {
            return format.endsWith(XLS);
        }

        public static boolean estXLSX(String format) {
            return format.endsWith(XLSX);
        }

        public static List<String> getListeFormatsEvenements() {
            return FORMATS.getListe(0);
        }

        public static List<String> getListe(int type) {
            switch (type) {
                case 0: {
                    return evenement;
                }
                case 1: {
                    return fauchage;
                }
                case 3: {
                    return debroussaillage;
                }
                case 2: {
                    return maincourante;
                }
                case -1: {
                    return defaut;
                }
            }
            return defaut;
        }
    }
}

