/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.beans;

import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.IDonneeVH;
import com.geolocsystems.prismandroid.model.Troncon;
import java.util.Date;
import java.util.Vector;

public class BarreauVH
extends Troncon
implements IDonneeVH {
    private static final long serialVersionUID = 4282508631910711021L;
    private static final String TAG_LOGCAT = "BarreauVH";
    public static final String STATUS_NR = "NR";
    public static final String STATUS_C1 = "C1";
    public static final String STATUS_C2 = "C2";
    public static final String STATUS_C3 = "C3";
    public static final String STATUS_C4 = "C4";
    private static String SENS_POSITIF = "positif";
    private static String SENS_NEGATIF = "negatif";
    private static String SENS_DOUBLE = "les 2 sens";
    private String idGroupe;
    private String tronconID;
    private String libelle;
    private String status;
    private Date majDate;
    private Date majDateServeur;
    private String croisement1;
    private String croisement2;
    private String delegation;
    private String centre;
    private String idPatrouilleur;
    private String cch2;
    private int majIdPartenaire = -1;
    private String tendanceCC = "NR";
    private String traitement = "NR";
    private String meteo = "NR";
    private String commentaire;
    private String commentaireInterne;
    private String equipements = "NR";
    private String etatChaussee = "NR";
    private String temperature = "NR";
    private String vent = "NR";
    private String sens = "les 2 sens";
    private int duree = 2;
    private String mcig;
    private boolean publie = false;
    private boolean misAJour = false;

    public boolean isPublie() {
        return this.publie;
    }

    public void setPublie(boolean publie) {
        this.publie = publie;
    }

    public String getIdParent() {
        return this.idGroupe;
    }

    public void setIdParent(String idParent) {
        this.idGroupe = idParent;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public String getCode() {
        return this.status;
    }

    public void setCode(String code) {
        this.status = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getMajDate() {
        return this.majDate;
    }

    public void setMajDate(Date majDate) {
        this.majDate = majDate;
    }

    public String getIdGroupe() {
        return this.idGroupe;
    }

    public void setIdGroupe(String idGroupe) {
        this.idGroupe = idGroupe;
    }

    public String getCroisement1() {
        return this.croisement1;
    }

    public void setCroisement1(String croisement1) {
        this.croisement1 = croisement1;
    }

    public String getCroisement2() {
        return this.croisement2;
    }

    public void setCroisement2(String croisement2) {
        this.croisement2 = croisement2;
    }

    public String getCentre() {
        return this.centre;
    }

    public void setCentre(String centre) {
        this.centre = centre;
    }

    public String getIdPatrouilleur() {
        return this.idPatrouilleur;
    }

    public void setIdPatrouilleur(String idPatrouilleur) {
        this.idPatrouilleur = idPatrouilleur;
    }

    @Override
    public String getCch2() {
        return this.cch2;
    }

    @Override
    public void setCch2(String cch2) {
        this.cch2 = cch2;
    }

    @Override
    public String getCch() {
        return this.status;
    }

    @Override
    public void setCch(String cch) {
        this.status = cch;
    }

    public boolean estMisAJour() {
        return this.misAJour;
    }

    public Date getMajDateServeur() {
        return this.majDateServeur;
    }

    public void setMajDateServeur(Date majDateServeur) {
        this.majDateServeur = majDateServeur;
    }

    public void addGeomX(double[] x) {
        if (this.xs == null) {
            this.xs = new Vector();
        }
        this.xs.add(x);
    }

    public void addGeomY(double[] y) {
        if (this.ys == null) {
            this.ys = new Vector();
        }
        this.ys.add(y);
    }

    public int getMajIdPartenaire() {
        return this.majIdPartenaire;
    }

    public void setMajIdPartenaire(int majIdPartenaire) {
        this.majIdPartenaire = majIdPartenaire;
    }

    @Override
    public String toString() {
        return "Troncon: " + this.tronconID + "\n\tStatus: " + this.status + "\n\tMaj: " + String.valueOf(this.majDate) + "\n\t" + String.valueOf(this.x) + " / " + String.valueOf(this.y);
    }

    @Override
    public String getTronconID() {
        return this.tronconID;
    }

    @Override
    public void setTronconID(String tronconID) {
        this.tronconID = tronconID;
    }

    @Override
    public String getTendanceCC() {
        return this.tendanceCC;
    }

    @Override
    public void setTendanceCC(String tendanceCC) {
        this.tendanceCC = tendanceCC;
    }

    @Override
    public String getTraitement() {
        return this.traitement;
    }

    @Override
    public void setTraitement(String traitement) {
        this.traitement = traitement;
    }

    @Override
    public String getMeteo() {
        return this.meteo;
    }

    @Override
    public void setMeteo(String meteo) {
        this.meteo = meteo;
    }

    @Override
    public String getCommentaire() {
        return this.commentaire;
    }

    @Override
    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    @Override
    public String getEquipements() {
        return this.equipements;
    }

    @Override
    public void setEquipements(String equipements) {
        this.equipements = equipements;
    }

    @Override
    public String getEtatChaussee() {
        return this.etatChaussee;
    }

    @Override
    public void setEtatChaussee(String etat_chaussee) {
        this.etatChaussee = etat_chaussee;
    }

    @Override
    public String getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(String temperature) {
        this.temperature = temperature;
    }

    @Override
    public String getVent() {
        return this.vent;
    }

    @Override
    public void setVent(String vent) {
        this.vent = vent;
    }

    @Override
    public String getCommentaireInterne() {
        return this.commentaireInterne;
    }

    @Override
    public void setCommentaireInterne(String commentaire_interne) {
        this.commentaireInterne = commentaire_interne;
    }

    @Override
    public String getSens() {
        return this.sens;
    }

    @Override
    public void setSens(String sens) {
        this.sens = sens;
    }

    @Override
    public int getDuree() {
        return this.duree;
    }

    @Override
    public void setDuree(int duree) {
        this.duree = duree;
    }

    public String getDelegation() {
        return this.delegation;
    }

    public void setDelegation(String delegation) {
        this.delegation = delegation;
    }

    public void calculerTendance() {
        if (this.getCch().equals(this.getCch2())) {
            this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
        } else if (ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue().equals(this.getCch())) {
            this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.MOINS.getValue());
        } else if (ConstantesPrismCommun.EnumVHTypeCCH.C1.getValue().equals(this.getCch())) {
            if (ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue().equals(this.getCch2())) {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.PLUS.getValue());
            } else {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.MOINS.getValue());
            }
        } else if (ConstantesPrismCommun.EnumVHTypeCCH.C2.getValue().equals(this.getCch())) {
            if (ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue().equals(this.getCch2()) || ConstantesPrismCommun.EnumVHTypeCCH.C1.getValue().equals(this.getCch2())) {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.PLUS.getValue());
            } else {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.MOINS.getValue());
            }
        } else if (ConstantesPrismCommun.EnumVHTypeCCH.C3.getValue().equals(this.getCch())) {
            if (ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue().equals(this.getCch2()) || ConstantesPrismCommun.EnumVHTypeCCH.C1.getValue().equals(this.getCch2()) || ConstantesPrismCommun.EnumVHTypeCCH.C2.getValue().equals(this.getCch2())) {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.PLUS.getValue());
            } else {
                this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.MOINS.getValue());
            }
        } else {
            this.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.PLUS.getValue());
        }
    }

    public String[] toStringArray() {
        String[] valeurs = new String[]{this.tronconID, this.status};
        return valeurs;
    }

    public void setMisAJour(boolean misAJour) {
        this.misAJour = misAJour;
    }

    public boolean estSensUnique() {
        return !this.sens.equals(SENS_DOUBLE);
    }

    public boolean estDateValide(boolean dureeDateVariable, long timeLimit) {
        Date d = this.getMajDate();
        if (d != null) {
            Date n = new Date();
            if (dureeDateVariable) {
                int duree_heure = this.getDuree();
                if (n.getTime() - d.getTime() > (long)(duree_heure * 3600 * 1000)) {
                    return false;
                }
            } else if (n.getTime() - d.getTime() > timeLimit) {
                return false;
            }
        }
        return true;
    }

    public String getMcig() {
        return this.mcig;
    }

    public void setMcig(String mcig) {
        this.mcig = mcig;
    }

    public void updateBarreauVH(BarreauVH barreauVH) {
        if (!this.status.equals(barreauVH.status)) {
            this.setCch(barreauVH.status);
            this.setMisAJour(true);
        }
        if (!this.cch2.equals(barreauVH.cch2)) {
            this.setCch2(barreauVH.cch2);
            this.setMisAJour(true);
        }
        if (!"".equals(this.meteo) || !barreauVH.meteo.equals("")) {
            this.setMeteo(barreauVH.meteo);
            this.setMisAJour(true);
        }
        if (!"".equals(this.temperature) || !barreauVH.temperature.equals("")) {
            this.setTemperature(barreauVH.temperature);
            this.setMisAJour(true);
        }
        if (!"".equals(this.vent) || !barreauVH.vent.equals("")) {
            this.setVent(barreauVH.vent);
            this.setMisAJour(true);
        }
        if (!"".equals(this.etatChaussee) || !barreauVH.etatChaussee.equals("")) {
            this.setEtatChaussee(barreauVH.etatChaussee);
            this.setMisAJour(true);
        }
        if (!"".equals(this.equipements) || !barreauVH.equipements.equals("")) {
            this.setEquipements(barreauVH.equipements);
            this.setMisAJour(true);
        }
        if (!"".equals(this.traitement) || !barreauVH.traitement.equals("")) {
            this.setTraitement(barreauVH.traitement);
            this.setMisAJour(true);
        }
        if (this.commentaireInterne != null && barreauVH.commentaireInterne != null && !this.commentaireInterne.equals(barreauVH.commentaireInterne)) {
            this.setCommentaireInterne(barreauVH.commentaireInterne);
            this.setMisAJour(true);
        }
        if (this.commentaire != null && barreauVH.commentaire != null && !this.commentaire.equals(barreauVH.commentaire)) {
            this.setCommentaire(barreauVH.commentaire);
            this.setMisAJour(true);
        }
    }
}

