/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.saleuse.parseur;

import com.geolocsystems.prismandroid.service.saleuse.parseur.ISaleuseParser;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ThermosondeKmsimeImpl;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ThermosondeKmtechImpl;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ThermosondeTeconerImpl;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ThermosondeVaisalaImpl;

public class ThermosondeParserFactory {
    public static final String THERMOSONDE_TEST = "Test";
    public static final String THERMOSONDE_KMTECH = "KMTECH";
    public static final String THERMOSONDE_KMSIME = "KM SIME";
    public static final String THERMOSONDE_KMSIME_LE = "KM SIME Low Energy";
    public static final String THERMOSONDE_TECONER = "TECONER";
    public static final String THERMOSONDE_VAISALA = "VAISALA";
    private static final String[] SALEUSES_SUPPORTEES = new String[]{"KMTECH", "KM SIME", "KM SIME Low Energy", "TECONER", "Test", "VAISALA"};

    private ThermosondeParserFactory() {
    }

    public static String[] getSuportedSaleuses() {
        return SALEUSES_SUPPORTEES;
    }

    public static ISaleuseParser parserForThermosonde(String sonde) {
        if (THERMOSONDE_TEST.equals(sonde)) {
            return null;
        }
        if (THERMOSONDE_TECONER.equals(sonde)) {
            return new ThermosondeTeconerImpl();
        }
        if (THERMOSONDE_VAISALA.equals(sonde)) {
            return new ThermosondeVaisalaImpl();
        }
        if (sonde.equals(THERMOSONDE_KMSIME_LE)) {
            return new ThermosondeKmsimeImpl();
        }
        if (THERMOSONDE_KMTECH.equals(sonde) || THERMOSONDE_KMSIME.equals(sonde)) {
            return new ThermosondeKmtechImpl();
        }
        return new ThermosondeKmtechImpl();
    }

    public static boolean estSondeBluetooth(String sonde) {
        return !ThermosondeParserFactory.estTeconer(sonde) && !ThermosondeParserFactory.estSondeDeTest(sonde);
    }

    public static boolean aucuneSondeSelectionnee(String sonde) {
        return sonde == null || sonde.equals("");
    }

    public static boolean estSondeDeTest(String sonde) {
        return sonde != null && sonde.equals(THERMOSONDE_TEST);
    }

    public static boolean estTeconer(String sonde) {
        return sonde != null && sonde.equals(THERMOSONDE_TECONER);
    }

    public static boolean estVaisala(String sonde) {
        return sonde != null && sonde.equals(THERMOSONDE_VAISALA);
    }

    public static boolean estKmSimeLE(String sonde) {
        return sonde != null && sonde.equals(THERMOSONDE_KMSIME_LE);
    }

    public static boolean estKmSimOuKmTech(String sonde) {
        return sonde != null && (sonde.equals(THERMOSONDE_KMSIME) || sonde.equals(THERMOSONDE_KMTECH));
    }
}

