/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.saleuse.parseur;

import com.geolocsystems.prismandroid.model.DonneesSaleuse;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ISaleuseParser;

class ThermosondeKmtechImpl
implements ISaleuseParser {
    ThermosondeKmtechImpl() {
    }

    @Override
    public DonneesSaleuse parse(Object ligne) {
        if (ligne != null && ligne instanceof String) {
            String line = (String)ligne;
            if (!line.startsWith("$TEMP")) {
                return null;
            }
            String[] parts = line.split(";|\\*");
            if (parts.length < 5) {
                return null;
            }
            DonneesSaleuse d = new DonneesSaleuse();
            d.init();
            int tempSol = Integer.parseInt(parts[1], 16);
            d.setTemperatureSol(this.round((float)tempSol / 10.0f - 100.0f));
            int tempAir = Integer.parseInt(parts[2], 16);
            d.setTemperatureAir(this.round((float)tempAir / 10.0f - 100.0f));
            int humAir = Integer.parseInt(parts[3], 16);
            d.setTauxHumidite(this.round((float)humAir / 10.0f - 100.0f));
            int ptRose = Integer.parseInt(parts[4], 16);
            d.setTemperaturePointRose(this.round((float)ptRose / 10.0f - 100.0f));
            return d;
        }
        return null;
    }

    private float round(float v) {
        double p = Math.pow(10.0, 1.0);
        return (float)((double)Math.round((double)v * p) / p);
    }
}

