/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.gps.parser;

import java.util.HashMap;
import java.util.Map;

public class NMEA {
    GPSPosition position = new GPSPosition();
    private static final Map<String, SentenceParser> sentenceParsers = new HashMap<String, SentenceParser>();

    static float Latitude2Decimal(String lat, String NS) {
        float med = Float.parseFloat(lat.substring(2)) / 60.0f;
        med += Float.parseFloat(lat.substring(0, 2));
        if (NS.startsWith("S")) {
            med = -med;
        }
        return med;
    }

    static float Longitude2Decimal(String lon, String WE) {
        float med = Float.parseFloat(lon.substring(3)) / 60.0f;
        med += Float.parseFloat(lon.substring(0, 3));
        if (WE.startsWith("W")) {
            med = -med;
        }
        return med;
    }

    public NMEA() {
        sentenceParsers.put("GPGGA", new GPGGA());
        sentenceParsers.put("GPGGL", new GPGGL());
        sentenceParsers.put("GPRMC", new GPRMC());
        sentenceParsers.put("GPRMZ", new GPRMZ());
        sentenceParsers.put("GPVTG", new GPVTG());
    }

    public GPSPosition parse(String line) {
        if (line.startsWith("$")) {
            String nmea = line.substring(1);
            String[] tokens = nmea.split(",");
            String type = tokens[0];
            if (sentenceParsers.containsKey(type)) {
                sentenceParsers.get(type).parse(tokens, this.position);
            }
            this.position.updatefix();
        }
        return this.position;
    }

    public class GPSPosition {
        public float time = 0.0f;
        public float lat = 0.0f;
        public float lon = 0.0f;
        public boolean fixed = false;
        public int quality = 0;
        public float dir = 0.0f;
        public float altitude = 0.0f;
        public float velocity = 0.0f;

        public void updatefix() {
            this.fixed = this.quality > 0;
        }

        public String toString() {
            return String.format("POSITION: lat: %f, lon: %f, time: %f, Q: %d, dir: %f, alt: %f, vel: %f", Float.valueOf(this.lat), Float.valueOf(this.lon), Float.valueOf(this.time), this.quality, Float.valueOf(this.dir), Float.valueOf(this.altitude), Float.valueOf(this.velocity));
        }
    }

    class GPGGA
    implements SentenceParser {
        GPGGA() {
        }

        @Override
        public boolean parse(String[] tokens, GPSPosition position) {
            try {
                position.time = Float.parseFloat(tokens[1]);
                position.lat = NMEA.Latitude2Decimal(tokens[2], tokens[3]);
                position.lon = NMEA.Longitude2Decimal(tokens[4], tokens[5]);
                position.quality = Integer.parseInt(tokens[6]);
                position.altitude = Float.parseFloat(tokens[9]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    class GPGGL
    implements SentenceParser {
        GPGGL() {
        }

        @Override
        public boolean parse(String[] tokens, GPSPosition position) {
            try {
                position.lat = NMEA.Latitude2Decimal(tokens[1], tokens[2]);
                position.lon = NMEA.Longitude2Decimal(tokens[3], tokens[4]);
                position.time = Float.parseFloat(tokens[5]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    class GPRMC
    implements SentenceParser {
        GPRMC() {
        }

        @Override
        public boolean parse(String[] tokens, GPSPosition position) {
            try {
                position.time = Float.parseFloat(tokens[1]);
                position.lat = NMEA.Latitude2Decimal(tokens[3], tokens[4]);
                position.lon = NMEA.Longitude2Decimal(tokens[5], tokens[6]);
                position.velocity = Float.parseFloat(tokens[7]);
                position.dir = Float.parseFloat(tokens[8]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    class GPRMZ
    implements SentenceParser {
        GPRMZ() {
        }

        @Override
        public boolean parse(String[] tokens, GPSPosition position) {
            try {
                position.altitude = Float.parseFloat(tokens[1]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    class GPVTG
    implements SentenceParser {
        GPVTG() {
        }

        @Override
        public boolean parse(String[] tokens, GPSPosition position) {
            try {
                position.dir = Float.parseFloat(tokens[3]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    static interface SentenceParser {
        public boolean parse(String[] var1, GPSPosition var2);
    }
}

