/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.tri;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampEntier;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import java.io.Serializable;
import java.util.Comparator;

public class EvenementTri
implements Comparator<Evenement>,
Serializable {
    private int id;
    private String nature;
    private String composant;
    private int ordre;
    private int sens;
    private EvenementTri subTri;

    public EvenementTri(int id, String nature, String composant, int ordre, int sens) {
        this.id = id;
        this.nature = nature;
        this.composant = composant;
        this.ordre = ordre;
        this.sens = sens;
    }

    public void setSubTri(EvenementTri subTri) {
        this.subTri = subTri;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getComposant() {
        return this.composant;
    }

    public void setComposant(String composant) {
        this.composant = composant;
    }

    public int getOrdre() {
        return this.ordre;
    }

    public void setOrdre(int ordre) {
        this.ordre = ordre;
    }

    public int getSens() {
        return this.sens;
    }

    public void setSens(int sens) {
        this.sens = sens;
    }

    @Override
    public int compare(Evenement evt1, Evenement evt2) {
        String val1 = null;
        String val2 = null;
        for (ValeurChamp valeurChamp : evt1.getValeurNature().getValeurs()) {
            if (!valeurChamp.getChamp().equals(this.composant)) continue;
            val1 = this.generateValeurChampValeu(valeurChamp);
            break;
        }
        for (ValeurChamp valeurChamp : evt2.getValeurNature().getValeurs()) {
            if (!valeurChamp.getChamp().equals(this.composant)) continue;
            val2 = this.generateValeurChampValeu(valeurChamp);
            break;
        }
        if (val1 != null && val2 != null) {
            int res = val1.compareTo(val2);
            if (res == 0 && this.subTri != null) {
                return this.subTri.compare(evt1, evt2);
            }
            return this.sens == 1 ? val1.compareTo(val2) : val2.compareTo(val1);
        }
        return 0;
    }

    private String generateValeurChampValeu(ValeurChamp valeurChamp) {
        if (valeurChamp instanceof ValeurChampTexte) {
            ValeurChampTexte valeurChampText = (ValeurChampTexte)valeurChamp;
            return valeurChampText.getValeur();
        }
        if (valeurChamp instanceof ValeurChampCollectionChoixUnique) {
            ValeurChampCollectionChoixUnique valeurChampText = (ValeurChampCollectionChoixUnique)valeurChamp;
            return valeurChampText.getValeur();
        }
        if (valeurChamp instanceof ValeurChampEntier) {
            ValeurChampEntier valeurChampEntier = (ValeurChampEntier)valeurChamp;
            return String.valueOf(valeurChampEntier.getValeur());
        }
        return null;
    }
}

