/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs.restrictions;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionDefinition;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismcentral.beans.Profil;

public class RestrictionProfil
extends RestrictionAbstrait {
    private static final long serialVersionUID = -3241349570938379277L;
    private String[] valeur;

    public RestrictionProfil(RestrictionDefinition resdef) {
        super(resdef);
        this.initialisationAffichage(resdef);
    }

    @Override
    protected void initialisationAffichage(RestrictionDefinition resdef) {
        this.affichage = MetierCommun.getBoolean((String)resdef.get("affichage"), true);
    }

    public boolean peutAfficherChamp() {
        return this.affichage;
    }

    public boolean accept(Profil p) {
        if (this.equal) {
            return MetierCommun.getIndiceObjetListe(this.valeur, (Object)p.getName()) > -1;
        }
        return MetierCommun.getIndiceObjetListe(this.valeur, (Object)p.getName()) == -1;
    }

    @Override
    public boolean accept(ValeurChamp valeurChamp) {
        return false;
    }

    @Override
    public void initialisationValeur(String valeur) {
        this.valeur = valeur.split(",");
    }

    @Override
    public String toString() {
        String ret = "profil" + (this.isEqual() ? "=" : "\u2260");
        StringBuffer buff = new StringBuffer();
        for (String val : this.valeur) {
            if (buff.length() > 0) {
                buff.append(",");
            }
            buff.append(val);
        }
        return ret + String.valueOf(buff);
    }
}

