/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs.restrictions;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionDefinition;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiCheckBox;

public class RestrictionMultiCheckBox
extends RestrictionAbstrait {
    private static final long serialVersionUID = -3241349570938379277L;
    private String[] valeur;

    public RestrictionMultiCheckBox(RestrictionDefinition resdef) {
        super(resdef);
    }

    @Override
    public boolean accept(ValeurChamp valeurChamp) {
        boolean accept = true;
        ValeurChampMultiCheckBox v = (ValeurChampMultiCheckBox)valeurChamp;
        if (v.getValeursSelectionnee() != null && !v.getValeursSelectionnee().isEmpty()) {
            boolean trouve = false;
            if (this.isEqual()) {
                for (String val : this.valeur) {
                    if (val == null || val.equals("") || MetierCommun.getIndiceObjetListe(v.getValeursSelectionnee(), (Object)val) <= -1) continue;
                    trouve = true;
                }
                accept = trouve;
            } else {
                for (String val : this.valeur) {
                    if (val == null || val.equals("") || MetierCommun.getIndiceObjetListe(v.getValeursSelectionnee(), (Object)val) <= -1) continue;
                    trouve = true;
                }
                accept = !trouve;
            }
        } else {
            accept = false;
        }
        return accept;
    }

    @Override
    public void initialisationValeur(String valeur) {
        this.valeur = valeur.split(",");
    }

    @Override
    public String toString() {
        String ret = this.nomChamp + (this.isEqual() ? "=" : "\u2260");
        StringBuffer buff = new StringBuffer();
        for (String val : this.valeur) {
            if (buff.length() > 0) {
                buff.append(",");
            }
            buff.append(val);
        }
        return ret + String.valueOf(buff);
    }
}

