/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiCheckBox;
import java.util.ArrayList;
import java.util.List;

public class ChampMultiCheckBox
extends ChampAbstrait {
    private static final long serialVersionUID = 7815558627707148962L;
    private String ncValeur;
    private String autreLabel;
    private String valeursSystemes;
    protected List<String> valeurs;
    protected ValeurChampMultiCheckBox valeur;

    public ChampMultiCheckBox(String nom) {
        super(nom);
        this.valeur = new ValeurChampMultiCheckBox(nom);
    }

    public String getNcValeur() {
        return this.ncValeur;
    }

    public void setNcValeur(String ncValeur) {
        this.ncValeur = ncValeur;
    }

    public List<String> getValeurs() {
        return this.valeurs;
    }

    public void setValeurs(List<String> valeurs) {
        this.valeurs = valeurs;
    }

    public boolean isNcSelectionne() {
        return this.valeur.isNcSelectionne();
    }

    public void setNcSelectionne(boolean ncSelectionne) {
        this.valeur.setNcSelectionne(ncSelectionne);
    }

    public List<String> getValeursSelectionnee() {
        return this.valeur.getValeursSelectionnee();
    }

    public void setValeursSelectionnee(List<String> valeursSelectionnee) {
        this.valeur.setValeursSelectionnee(valeursSelectionnee);
    }

    @Override
    public Object getView(IComposantFactory factory) {
        return factory.createView(this);
    }

    @Override
    public ValeurChamp getValeurChamp() {
        return this.valeur;
    }

    @Override
    public void setValeurChamp(ValeurChamp valeur) {
        this.valeur = (ValeurChampMultiCheckBox)valeur;
    }

    @Override
    public List<String[]> valueOf(ValeurChamp valeur) {
        ArrayList<String[]> value = new ArrayList<String[]>();
        ValeurChampMultiCheckBox v = (ValeurChampMultiCheckBox)valeur;
        String autreValeur = v.getAutreValeur();
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(v.getValeursSelectionnee());
        if (autreValeur != null) {
            l.add(autreValeur);
        }
        value.add(ChampMultiCheckBox.valueOf(this.nom, MetierCommun.getString(MetierCommun.trier(l), ";")));
        return value;
    }

    public String getAutreLabel() {
        return this.autreLabel;
    }

    public void setAutreLabel(String autreLabel) {
        this.autreLabel = autreLabel;
    }

    public String getAutreValeur() {
        return this.valeur.getAutreValeur();
    }

    public void setAutreValeur(String autreValeur) {
        this.valeur.setAutreValeur(autreValeur);
    }

    @Override
    public ValeurChamp parseValeur(String valeur) {
        ValeurChampMultiCheckBox valeurChamp = new ValeurChampMultiCheckBox(this.nom);
        List<String> selection = MetierCommun.getListe(valeur, ";");
        if (!MetierCommun.estValeurSysteme(this.getValeursSystemes())) {
            for (int i = selection.size() - 1; i >= 0; --i) {
                if (this.getValeurs().contains(selection.get(i))) continue;
                if (this.getNcValeur() != null && this.getNcValeur().equals(selection.get(i))) {
                    valeurChamp.setNcSelectionne(true);
                    continue;
                }
                valeurChamp.setAutreValeur(selection.get(i));
                selection.remove(i);
            }
        }
        valeurChamp.setValeursSelectionnee(selection);
        return valeurChamp;
    }

    public String getValeursSystemes() {
        return this.valeursSystemes;
    }

    public void setValeursSystemes(String valeursSystemes) {
        this.valeursSystemes = valeursSystemes;
    }
}

