/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import java.util.ArrayList;
import java.util.List;

public class ChampLocalisation
extends ChampAbstrait {
    private static final long serialVersionUID = -5709072379267742644L;
    public static final int SENS_PR_POSITIF = 1;
    public static final int SENS_PR_NEGATIF = 0;
    private ValeurChampLocalisation valeur = new ValeurChampLocalisation("localisation");
    private static final String NOM_CHAMP_LOCALISATION = "localisation";
    private static final String TYPE_SAISIE = "typeSaisie";
    private static final String TYPE_SAISIE_SIMPLE = "simple";
    private static final String TYPE_SAISIE_COMPLEXE = "complexe";
    private boolean pr;
    private boolean alertC;
    private boolean afficherSens;
    protected List<Voie> voies;
    protected List<String> accrochages;
    protected List<String> caracteristiques;
    protected List<String> departements;
    private String type = "lin\u00e9aire";

    public ChampLocalisation() {
        super(NOM_CHAMP_LOCALISATION);
        this.valeur.setDeptDebut(null);
        this.valeur.setPrDebut(-1);
        this.valeur.setAbsPrDebut(-1);
        this.valeur.setAdresseDebut("");
        this.valeur.setAdresseFin("");
        this.valeur.setDeptFin(null);
        this.valeur.setPrFin(-1);
        this.valeur.setAbsPrFin(-1);
        this.valeur.setLocalisationParGps(true);
        this.valeur.setX(new float[0]);
        this.valeur.setY(new float[0]);
        this.valeur.setSensPr(1);
        this.valeur.setVoie("");
        this.valeur.setAccrochage(true);
        this.valeur.setTrafic("");
        this.valeur.setCategorie("");
        this.valeur.setComplexe(false);
        this.valeur.setDirection("");
        this.valeur.setPointParticulier(-1);
        this.valeur.setComplementLocalisation("");
        this.setAffichageSens(true);
    }

    public String getVoie() {
        return this.valeur.getVoie();
    }

    public void setDirection(String direction) {
        this.valeur.setDirection(direction);
    }

    public String getDirection() {
        return this.valeur.getDirection();
    }

    public void setVoie(String voie) {
        this.valeur.setVoie(voie);
    }

    public boolean isTunnel() {
        return Voie.isTunnel(this.valeur.getVoie());
    }

    public boolean isGestionTunnel() {
        for (Voie v : this.voies) {
            if (!Voie.isTunnel(v.getLibelle())) continue;
            return true;
        }
        return false;
    }

    public String getAxe() {
        return this.valeur.getAxe();
    }

    public void setAxe(String axe) {
        this.valeur.setAxe(axe);
    }

    public boolean isPr() {
        return this.pr;
    }

    public boolean isAfficheListeDepartements() {
        return this.departements != null && this.departements.size() > 1;
    }

    public void setPr(boolean pr) {
        this.pr = pr;
    }

    public boolean isAlertC() {
        return this.alertC;
    }

    public void setAlertC(boolean alertC) {
        this.alertC = alertC;
    }

    public String getDeptDebut() {
        return this.valeur.getDeptDebut();
    }

    public int getPrDebut() {
        return this.valeur.getPrDebut();
    }

    public String getAdresseDebut() {
        return this.valeur.getAdresseDebut();
    }

    public String getAdresseFin() {
        return this.valeur.getAdresseFin();
    }

    public void setDeptDebut(String deptDebut) {
        this.valeur.setDeptDebut(deptDebut);
    }

    public void setPrDebut(int prDebut) {
        this.valeur.setPrDebut(prDebut);
    }

    public void setAdresseDebut(String adresseDebut) {
        this.valeur.setAdresseDebut(adresseDebut);
    }

    public void setAdresseFin(String adresseFin) {
        this.valeur.setAdresseFin(adresseFin);
    }

    public int getAbsPrDebut() {
        return this.valeur.getAbsPrDebut();
    }

    public void setAbsPrDebut(int absPrDebut) {
        this.valeur.setAbsPrDebut(absPrDebut);
    }

    public void setDeptFin(String deptFin) {
        this.valeur.setDeptFin(deptFin);
    }

    public String getDeptFin() {
        return this.valeur.getDeptFin();
    }

    public int getPrFin() {
        return this.valeur.getPrFin();
    }

    public void setPrFin(int prFin) {
        this.valeur.setPrFin(prFin);
    }

    public int getAbsPrFin() {
        return this.valeur.getAbsPrFin();
    }

    public void setAbsPrFin(int absPrFin) {
        this.valeur.setAbsPrFin(absPrFin);
    }

    public int getSensPr() {
        return this.valeur.getSensPr();
    }

    public void setSensPr(int sensPr) {
        this.valeur.setSensPr(sensPr);
    }

    public String getLocalisantPrimaire() {
        return this.valeur.getLocalisantPrimaire();
    }

    public void setLocalisantPrimaire(String localisantPrimaire) {
        this.valeur.setLocalisantPrimaire(localisantPrimaire);
    }

    public String getAbsLocalisantPrimaire() {
        return this.valeur.getAbsLocalisantPrimaire();
    }

    public void setAbsLocalisantPrimaire(String absLocalisantPrimaire) {
        this.valeur.setAbsLocalisantPrimaire(absLocalisantPrimaire);
    }

    public String getLocalisantSecondaire() {
        return this.valeur.getLocalisantSecondaire();
    }

    public void setLocalisantSecondaire(String localisantSecondaire) {
        this.valeur.setLocalisantSecondaire(localisantSecondaire);
    }

    public String getAbsLocalisantSecondaire() {
        return this.valeur.getAbsLocalisantSecondaire();
    }

    public void setAbsLocalisantSecondaire(String absLocalisantSecondaire) {
        this.valeur.setAbsLocalisantSecondaire(absLocalisantSecondaire);
    }

    public int getSensAlertC() {
        return this.valeur.getSensAlertC();
    }

    public void setSensAlertC(int sensAlertC) {
        this.valeur.setSensAlertC(sensAlertC);
    }

    @Override
    public Object getView(IComposantFactory factory) {
        return factory.createView(this);
    }

    public int getLongueur() {
        return this.valeur.getLongueur();
    }

    public void setLongueur(int longueur) {
        this.valeur.setLongueur(longueur);
    }

    public String getCommune() {
        return this.valeur.getCommune();
    }

    public void setCommune(String commune) {
        this.valeur.setCommune(commune);
    }

    public Position getPositionDebut() {
        return this.valeur.getPositionDebut();
    }

    public void setPositionDebut(Position positionDebut) {
        this.valeur.setPositionDebut(positionDebut);
    }

    public Position getPositionFin() {
        return this.valeur.getPositionFin();
    }

    public void setPositionFin(Position positionFin) {
        this.valeur.setPositionFin(positionFin);
    }

    public float[] getX() {
        return this.valeur.getX();
    }

    public void setX(float[] x) {
        this.valeur.setX(x);
    }

    public float[] getY() {
        return this.valeur.getY();
    }

    public void setY(float[] y) {
        this.valeur.setY(y);
    }

    @Override
    public ValeurChamp getValeurChamp() {
        return this.valeur;
    }

    @Override
    public void setValeurChamp(ValeurChamp valeur) {
        this.valeur = (ValeurChampLocalisation)valeur;
    }

    public boolean getLocalisationParGps() {
        return this.valeur.getLocalisationParGps();
    }

    public void setLocalisationParGps(boolean localisationParGps) {
        this.valeur.setLocalisationParGps(localisationParGps);
    }

    @Override
    public List<String[]> valueOf(ValeurChamp valeur) {
        ArrayList<String[]> value = new ArrayList<String[]>();
        value.add(ChampLocalisation.valueOf(this.nom, ChampLocalisation.valueOfString(TYPE_SAISIE, this.isComplexe() ? TYPE_SAISIE_COMPLEXE : TYPE_SAISIE_SIMPLE)));
        value.add(ChampLocalisation.valueOf("voie", this.getVoie()));
        value.add(ChampLocalisation.valueOf("axe", this.getAxe()));
        if (this.getPrDebut() >= 0) {
            if (this.getDeptDebut() != null && !"-1".equals(this.getDeptDebut()) && !MetierCommun.estVide(this.getDeptDebut())) {
                value.add(ChampLocalisation.valueOf("deptDebut", this.getDeptDebut()));
            }
            value.add(ChampLocalisation.valueOf("prDebut", "" + this.getPrDebut()));
            value.add(ChampLocalisation.valueOf("absPrDebut", "" + this.getAbsPrDebut()));
        }
        if (this.getPrFin() >= 0) {
            if (this.getDeptFin() != null && !"-1".equals(this.getDeptFin()) && !MetierCommun.estVide(this.getDeptFin())) {
                value.add(ChampLocalisation.valueOf("deptFin", this.getDeptFin()));
            }
            value.add(ChampLocalisation.valueOf("prFin", "" + this.getPrFin()));
            value.add(ChampLocalisation.valueOf("absPrFin", "" + this.getAbsPrFin()));
        }
        if (this.getX() != null && this.getX().length > 0) {
            value.add(ChampLocalisation.valueOf("x", "" + this.getX()[0]));
        }
        if (this.getY() != null && this.getY().length > 0) {
            value.add(ChampLocalisation.valueOf("y", "" + this.getY()[0]));
        }
        value.add(ChampLocalisation.valueOf("direction", this.getDirection()));
        return value;
    }

    @Override
    public ValeurChamp parseValeur(String valeur) {
        ValeurChampLocalisation v = new ValeurChampLocalisation(this.nom);
        MapDescription m = MapDescription.parse(valeur);
        v.setComplexe(m.getString(TYPE_SAISIE, TYPE_SAISIE_SIMPLE).equals(TYPE_SAISIE_COMPLEXE));
        return v;
    }

    public List<Voie> getVoies() {
        return this.voies;
    }

    public void setVoies(List<Voie> voies) {
        this.voies = voies;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getAccrochages() {
        return this.accrochages;
    }

    public void setAccrochages(List<String> accrochages) {
        this.accrochages = accrochages;
    }

    public boolean isAccrochage() {
        return this.valeur.isAccrochage();
    }

    public boolean isAffichageSens() {
        return this.afficherSens;
    }

    public void setAccrochage(boolean accrochage) {
        this.valeur.setAccrochage(accrochage);
    }

    public void setAffichageSens(boolean afficherSens) {
        this.afficherSens = afficherSens;
    }

    public String getTrafic() {
        return this.valeur.getTrafic();
    }

    public boolean isComplexe() {
        return this.valeur.isComplexe();
    }

    public void setComplexe(boolean c) {
        this.valeur.setComplexe(c);
    }

    public String getCategorie() {
        return this.valeur.getCategorie();
    }

    public List<String> getCaracteristiques() {
        return this.caracteristiques;
    }

    public void setCaracteristiques(List<String> caracteristiques) {
        this.caracteristiques = caracteristiques;
    }

    public void setComplementLocalisation(String c) {
        this.valeur.setComplementLocalisation(c);
    }

    public String getComplementLocalisation() {
        return this.valeur.getComplementLocalisation();
    }

    public List<String> getDepartements() {
        return this.departements;
    }

    public void setDepartements(List<String> departements) {
        this.departements = departements;
    }

    public void setPointParticulier(int pp) {
        this.valeur.setPointParticulier(pp);
    }

    public int getPointParticulier() {
        return this.valeur.getPointParticulier();
    }
}

