/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs;

import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampEntier;
import java.util.ArrayList;
import java.util.List;

public class ChampEntier
extends ChampAbstrait {
    private static final long serialVersionUID = 692630123514755339L;
    private ValeurChampEntier valeur;
    private int valeurMin;
    private int valeurMax;
    private int pas;
    private boolean checkbox;

    public ChampEntier(String nom, int valeurMin, int valeurMax, boolean checkbox) {
        super(nom);
        this.valeur = new ValeurChampEntier(nom);
        this.valeurMin = valeurMin;
        this.valeurMax = valeurMax;
        this.checkbox = checkbox;
    }

    public ChampEntier(String nom) {
        super(nom);
        this.valeur = new ValeurChampEntier(nom);
        this.valeurMin = 0;
        this.valeurMax = 50;
        this.pas = 1;
    }

    public int getValeur() {
        return this.valeur.getValeur();
    }

    public void setValeur(int valeur) {
        this.valeur.setValeur(valeur);
    }

    public boolean isChecked() {
        return this.valeur.isChecked();
    }

    public void setChecked(boolean checked) {
        this.valeur.setChecked(checked);
    }

    @Override
    public Object getView(IComposantFactory factory) {
        return factory.createView(this);
    }

    @Override
    public ValeurChamp getValeurChamp() {
        return this.valeur;
    }

    @Override
    public void setValeurChamp(ValeurChamp valeur) {
        this.valeur = (ValeurChampEntier)valeur;
    }

    @Override
    public List<String[]> valueOf(ValeurChamp valeur) {
        ArrayList<String[]> value = new ArrayList<String[]>();
        if (((ValeurChampEntier)valeur).isChecked()) {
            value.add(ChampEntier.valueOf(this.nom, String.valueOf(((ValeurChampEntier)valeur).getValeur())));
        }
        return value;
    }

    public int getValeurMin() {
        return this.valeurMin;
    }

    public void setValeurMin(int valeurMin) {
        this.valeurMin = valeurMin;
    }

    public int getValeurMax() {
        return this.valeurMax;
    }

    public void setValeurMax(int valeurMax) {
        this.valeurMax = valeurMax;
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }

    public void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    @Override
    public ValeurChamp parseValeur(String valeur) {
        ValeurChampEntier valeurChamp = new ValeurChampEntier(this.nom);
        try {
            valeurChamp.setValeur(Integer.parseInt(valeur));
            valeurChamp.setChecked(true);
        }
        catch (NumberFormatException e) {
            valeurChamp.setValeur(this.getValeurMin());
            valeurChamp.setChecked(false);
        }
        return valeurChamp;
    }

    public int getPas() {
        return this.pas;
    }

    public void setPas(int pas) {
        this.pas = pas;
    }
}

