/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements;

import com.geolocsystems.prismandroid.model.evenements.ConteneurDeChamp;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Nature
implements Serializable,
ConteneurDeChamp,
NatureOuRaccourci {
    private static final long serialVersionUID = -287447945275343354L;
    private int codeMM;
    private String code;
    private String label;
    private byte[] image;
    private int duree;
    private boolean active;
    private int indice;
    private List<Champ> champs;
    private ChampLocalisation localisation;
    private ChampDropListe description;

    @Override
    public List<Champ> getChamps() {
        return this.champs;
    }

    public void setChamps(List<Champ> champs) {
        this.champs = champs;
    }

    @Override
    public final String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public byte[] getImage() {
        return this.image;
    }

    @Override
    public void setImage(byte[] image) {
        this.image = image;
    }

    public ChampDropListe getDescription() {
        return this.description;
    }

    public void setDescription(ChampDropListe description) {
        this.description = description;
    }

    public ChampLocalisation getLocalisation() {
        return this.localisation;
    }

    public void setLocalisation(ChampLocalisation localisation) {
        this.localisation = localisation;
    }

    public ValeurNature extraireValeurs() {
        ValeurNature valeur = new ValeurNature();
        valeur.setCode(this.code);
        ArrayList<ValeurChamp> valeurs = new ArrayList<ValeurChamp>();
        for (int i = 0; i < this.champs.size(); ++i) {
            valeurs.add(this.champs.get(i).getValeurChamp());
        }
        valeur.setValeurs(valeurs);
        valeur.setDescription((ValeurChampCollectionChoixUnique)this.description.getValeurChamp());
        valeur.setLocalisation((ValeurChampLocalisation)this.localisation.getValeurChamp());
        return valeur;
    }

    public void chargerValeurs(ValeurNature valeur) {
        HashMap<String, Champ> m = new HashMap<String, Champ>(valeur.getValeurs().size());
        for (Champ c : this.champs) {
            m.put(c.getNom(), c);
        }
        for (ValeurChamp v : valeur.getValeurs()) {
            if (v == null) continue;
            Champ c = (Champ)m.get(v.getChamp());
            try {
                if (c == null) continue;
                c.setValeurChamp(v);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).equals(this.code);
        }
        return super.equals(obj);
    }

    @Override
    public int getCodeMM() {
        return this.codeMM;
    }

    public void setCodeMM(int codeMM) {
        this.codeMM = codeMM;
    }

    @Override
    public String getUniqueId() {
        return this.code;
    }

    @Override
    public int getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
    }

    public int getIndice() {
        return this.indice;
    }

    public void setIndice(int indice) {
        this.indice = indice;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Nature getNature() {
        return this;
    }
}

