/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid;

import java.util.ArrayList;
import java.util.List;

public class TronconMapMatching {
    protected static final double MAX_MAPMATCH_DISTANCE = 30.0;
    protected static final double MAX_BEARING_DEVIATION = 45.0;
    private static TronconMapMatching instance;

    public static TronconMapMatching getInstance() {
        if (instance == null) {
            instance = new TronconMapMatching();
        }
        return instance;
    }

    private TronconMapMatching() {
    }

    public <T> List<MatchResult<T>> match(float xPos, float yPos, double heading, List<TronconUtm<T>> geomsUtm) {
        ArrayList<MatchResult<T>> results = new ArrayList<MatchResult<T>>();
        Point pos = new Point(xPos, yPos);
        for (TronconUtm<T> ldmLane : geomsUtm) {
            MatchResult<T> result = this.match(pos, heading, ldmLane);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    private <T> MatchResult<T> match(Point pos, double heading, TronconUtm<T> geomUtm) {
        double beginOffset = 0.0;
        double bestMatchOffset = 0.0;
        double bestMatchDistance = Double.MAX_VALUE;
        for (int i = 0; i < geomUtm.x.length - 1; ++i) {
            Point a = new Point(geomUtm.x[i], geomUtm.y[i]);
            Point b = new Point(geomUtm.x[i + 1], geomUtm.y[i + 1]);
            Point proj = this.project(a, b, pos);
            if (proj != null) {
                double bearing;
                double bearingDeviation;
                double dist = this.distance(pos, proj);
                double segOffset = this.distance(a, proj);
                if (dist < 30.0 && dist < bestMatchDistance && (bearingDeviation = Math.abs((bearing = TronconMapMatching.bearing(a, b)) - heading)) <= 45.0) {
                    bestMatchOffset = beginOffset + segOffset;
                    bestMatchDistance = dist;
                }
            }
            beginOffset += this.distance(a, b);
        }
        if (bestMatchDistance < 30.0) {
            return new MatchResult<T>(geomUtm, bestMatchDistance, bestMatchOffset);
        }
        return null;
    }

    protected static double bearing(Point p1, Point p2) {
        double rad = -1.0 * (Math.atan2(p2.y - p1.y, p2.x - p1.x) - 1.5707963267948966);
        return Math.toDegrees(rad);
    }

    protected static double bearinglatlon(Point p1, Point p2) {
        double longitude1 = p1.x;
        double longitude2 = p2.x;
        double latitude1 = Math.toRadians(p1.y);
        double latitude2 = Math.toRadians(p2.y);
        double longDiff = Math.toRadians(longitude2 - longitude1);
        double y = Math.sin(longDiff) * Math.cos(latitude2);
        double x = Math.cos(latitude1) * Math.sin(latitude2) - Math.sin(latitude1) * Math.cos(latitude2) * Math.cos(longDiff);
        return (Math.toDegrees(Math.atan2(y, x)) + 360.0) % 360.0;
    }

    protected double distance(Point p1, Point p2) {
        return Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
    }

    protected Point project(Point segA, Point segB, Point pos) {
        if (segA.x == segB.x) {
            Point ret = new Point();
            ret.x = segA.x;
            ret.y = pos.y;
            return this.between(segA.y, segB.y, ret.y) ? ret : null;
        }
        if (segA.y == segB.y) {
            Point ret = new Point();
            ret.y = segA.y;
            ret.x = pos.x;
            return this.between(segA.x, segB.x, ret.x) ? ret : null;
        }
        double m = (segB.y - segA.y) / (segB.x - segA.x);
        double p = segA.y - m * segA.x;
        double m2 = -1.0 / m;
        double p2 = pos.y - m2 * pos.x;
        Point ret = new Point();
        ret.x = (p2 - p) / (m - m2);
        ret.y = m * ret.x + p;
        return this.between(segA.x, segB.x, ret.x) ? ret : null;
    }

    protected boolean between(double a, double b, double nb) {
        return a <= nb && nb <= b || b <= nb && nb <= a;
    }

    private static class Point {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "]";
        }
    }

    public static class TronconUtm<T> {
        public float[] x;
        public float[] y;
        public T object;

        public TronconUtm(float[] x, float[] y, T object) {
            this.x = x;
            this.y = y;
            this.object = object;
        }
    }

    public static class MatchResult<T> {
        private TronconUtm<T> lane;
        private double distance;
        private double offset;

        public TronconUtm<T> getLane() {
            return this.lane;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getOffset() {
            return this.offset;
        }

        public MatchResult(TronconUtm<T> lane, double distance, double offset) {
            this.lane = lane;
            this.distance = distance;
            this.offset = offset;
        }
    }
}

