/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonProfilUtils {
    public static CommonProfilUtils instance;
    private PrismCentralUser u;
    private Map<Integer, Integer> mapMctActionsMm;
    private Map<Integer, Integer> mapMceActionsMm;

    private CommonProfilUtils() {
        this.initActionsMM();
    }

    public static CommonProfilUtils getInstance() {
        if (instance == null) {
            instance = new CommonProfilUtils();
        }
        return instance;
    }

    public int getMctActionMm(int mm) {
        return this.mapMctActionsMm.get(mm);
    }

    public int getMceActionMm(int mm) {
        return this.mapMceActionsMm.get(mm);
    }

    private void initActionsMM() {
        this.mapMctActionsMm = new HashMap<Integer, Integer>();
        this.mapMctActionsMm.put(1000, 2001);
        this.mapMctActionsMm.put(5, 90);
        this.mapMctActionsMm.put(0, 1);
        this.mapMctActionsMm.put(3, 30);
        this.mapMctActionsMm.put(7, 70);
        this.mapMctActionsMm.put(2, 10100);
        this.mapMctActionsMm.put(1, 50);
        this.mapMctActionsMm.put(8, 78);
        this.mapMctActionsMm.put(6, 80);
        this.mapMceActionsMm = new HashMap<Integer, Integer>();
        this.mapMceActionsMm.put(1000, 2000);
        this.mapMceActionsMm.put(5, 36);
        this.mapMceActionsMm.put(0, 34);
        this.mapMceActionsMm.put(3, 41);
        this.mapMceActionsMm.put(7, 38);
        this.mapMceActionsMm.put(2, 48);
        this.mapMceActionsMm.put(4, 445);
        this.mapMceActionsMm.put(9, 901);
        this.mapMceActionsMm.put(1, 46);
        this.mapMceActionsMm.put(8, 7800);
        this.mapMctActionsMm.put(6, 37);
    }

    public void init(PrismCentralUser u) {
        this.u = u;
    }

    public PrismCentralUser getUtilisateurConnecte() {
        return this.u;
    }

    public boolean accesTouteDelegation() {
        return !this.aUneDelegation() && !this.aUnCentre();
    }

    public boolean isSuperAdmin() {
        return this.getUtilisateurConnecte().isSuperAdmin();
    }

    public String getDelegation() {
        return this.getUtilisateurConnecte().getDelegation();
    }

    public String getCentre() {
        return this.getUtilisateurConnecte().getCentre();
    }

    public boolean aUneDelegation() {
        return !MetierCommun.estVide(this.getUtilisateurConnecte().getDelegation());
    }

    public boolean aUnCentre() {
        return !MetierCommun.estVide(this.getUtilisateurConnecte().getCentre());
    }

    public boolean estAdmin() {
        return this.peutModifierProfil();
    }

    public boolean peutModifierProfil() {
        return this.peutModifierProfil(this.getUtilisateurConnecte());
    }

    public boolean peutModifierProfil(PrismCentralUser u) {
        return this.peutModifierProfil(u.getProfil());
    }

    public boolean peutModifierProfil(Profil p) {
        return p != null && PrismCentralUser.canDo(p, 14);
    }

    public boolean canDo(int action) {
        return this.getUtilisateurConnecte().canDo(action);
    }

    public boolean peutModifierChamp(Champ champ) {
        return MetierCommun.peutModifierChamp(this.getUtilisateurConnecte().getProfil(), champ);
    }

    public boolean peutAfficherChamp(Champ champ) {
        return MetierCommun.peutAfficherChamp(this.getUtilisateurConnecte().getProfil(), champ);
    }

    public boolean peutLire() {
        return this.getUtilisateurConnecte().canDo(201);
    }

    public boolean peutViser() {
        return this.getUtilisateurConnecte().canDo(203);
    }

    public boolean peutModifierEvenement(Nature nature) {
        if (nature != null) {
            return this.canDo(2) && this.estNatureAutorisee(2, nature);
        }
        return this.canDo(2);
    }

    public boolean peutPublierEvenement(Nature nature) {
        if (nature != null) {
            return this.canDo(4) && this.estNatureAutorisee(4, nature);
        }
        return this.canDo(4);
    }

    public boolean peutCloturerEvenement(Nature nature) {
        if (nature != null) {
            return this.canDo(3) && this.estNatureAutorisee(3, nature);
        }
        return this.canDo(3);
    }

    public boolean peutModifierEvenementCloture() {
        return this.estOptionAutorisee(2, "evenements-clotures", false);
    }

    public boolean peutAssocierEvenement(Nature nature) {
        return this.canDo(5) && this.estNatureAutorisee(5, nature);
    }

    public boolean peutCreerEvenement(Nature nature) {
        return this.canDo(6) && this.estNatureAutorisee(6, nature);
    }

    public boolean estNatureAutorisee(int action, Nature nature) {
        if (nature != null) {
            return this.estNatureAutorisee(action, nature.getCode()) || this.estModuleAutorise(action, String.valueOf(nature.getCodeMM()));
        }
        return true;
    }

    public boolean estOptionAutorisee(int action, String valeur, boolean autoriserParDefaut) {
        if (valeur != null) {
            boolean optionOk = this.estParametreActionDansListe(action, "options-autorisees", valeur, autoriserParDefaut);
            boolean optionkO = !this.estParametreActionDansListe(action, "options-refusees", valeur, false);
            return optionOk && optionkO;
        }
        return true;
    }

    public boolean estNatureAutorisee(int action, String valeur) {
        if (valeur != null) {
            boolean natOk = this.estParametreActionDansListe(action, "natures-autorisees", valeur, true);
            boolean natkO = !this.estParametreActionDansListe(action, "natures-refusees", valeur, false);
            return natOk && natkO;
        }
        return true;
    }

    public boolean peutAfficherVehicules() {
        return this.canDo(7);
    }

    public boolean peutAfficherVehiculesEnCours() {
        return this.peutAfficherVehicules() && !this.estParametreActionDansListe(7, "options-refusees", "vehicules-en-cours", false);
    }

    public boolean estOptionRefusee(int action, String option) {
        return this.estParametreActionDansListe(action, "options-refusees", option, false);
    }

    public boolean estOptionAutorisee(int action, String option) {
        return this.estParametreActionDansListe(action, "options-autorisees", option, false);
    }

    public boolean estModuleAutorise(int action, String valeur) {
        if (valeur != null) {
            boolean mmOk = this.estParametreActionDansListe(action, "modules-autorises", valeur, true);
            boolean mmKo = !this.estParametreActionDansListe(action, "modules-refuses", valeur, false);
            return mmOk && mmKo;
        }
        return true;
    }

    public List<String> getRestrictionsNatureCreation() {
        MapDescription parametres = this.getParametresActions(6);
        if (parametres != null && parametres.containsKey("natures-refusees")) {
            return parametres.getList("natures-refusees");
        }
        return null;
    }

    public boolean estParametreActionDansListe(int action, String param, String valeur, boolean defaut) {
        MapDescription parametres = this.getParametresActions(action);
        if (parametres != null && parametres.containsKey(param)) {
            return MetierCommun.estDedans(parametres.getList(param), (Object)valeur);
        }
        return defaut;
    }

    public int estParametreActionDansListe(MapDescription parametres, String param, String valeur) {
        if (parametres != null && parametres.containsKey(param)) {
            return MetierCommun.estDedans(parametres.getList(param), (Object)valeur) ? 1 : 0;
        }
        return -1;
    }

    public MapDescription getParametresActions(int action) {
        if (this.getUtilisateurConnecte().getProfil().getParametres() != null && this.getUtilisateurConnecte().getProfil().getParametres().containsKey(action)) {
            return this.getUtilisateurConnecte().getProfil().getParametres().get(action);
        }
        return null;
    }
}

