/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SCPEngine {
    private static final String SCP_COMMAND = "scp";
    private static final char LF = '\n';
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionFactory host;
    private final TransferListener listener;
    private Session.Command scp;
    private int exitStatus;

    SCPEngine(SessionFactory host, TransferListener listener) {
        this.host = host;
        this.listener = listener;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    void check(String what) throws IOException {
        int code = this.scp.getInputStream().read();
        switch (code) {
            case -1: {
                String stderr = IOUtils.readFully(this.scp.getErrorStream()).toString();
                if (!stderr.isEmpty()) {
                    stderr = ". Additional info: `" + stderr + "`";
                }
                throw new SCPException("EOF while expecting response to protocol message" + stderr);
            }
            case 0: {
                this.log.debug(what);
                return;
            }
            case 1: 
            case 2: {
                throw new SCPException("Remote SCP command had error: " + this.readMessage());
            }
        }
        throw new SCPException("Received unknown response code");
    }

    void cleanSlate() {
        this.exitStatus = -1;
    }

    void execSCPWith(List<Arg> args, String path) throws SSHException {
        StringBuilder cmd = new StringBuilder(SCP_COMMAND);
        for (Arg arg : args) {
            cmd.append(" ").append((Object)arg);
        }
        cmd.append(" ");
        if (path == null || path.isEmpty()) {
            cmd.append(".");
        } else {
            cmd.append("'").append(path.replaceAll("'", "\\'")).append("'");
        }
        this.scp = this.host.startSession().exec(cmd.toString());
    }

    void exit() {
        if (this.scp != null) {
            IOUtils.closeQuietly(this.scp);
            if (this.scp.getExitStatus() != null) {
                this.exitStatus = this.scp.getExitStatus();
                if (this.scp.getExitStatus() != 0) {
                    this.log.warn("SCP exit status: {}", (Object)this.scp.getExitStatus());
                }
            } else {
                this.exitStatus = -1;
            }
            if (this.scp.getExitSignal() != null) {
                this.log.warn("SCP exit signal: {}", (Object)this.scp.getExitSignal());
            }
        }
        this.scp = null;
    }

    String readMessage() throws IOException {
        int x;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((x = this.scp.getInputStream().read()) != 10) {
            if (x == -1) {
                if (baos.size() == 0) {
                    return "";
                }
                throw new IOException("EOF while reading message");
            }
            baos.write(x);
        }
        String msg = baos.toString(IOUtils.UTF8.displayName());
        this.log.debug("Read message: `{}`", (Object)msg);
        return msg;
    }

    void sendMessage(String msg) throws IOException {
        this.log.debug("Sending message: {}", (Object)msg);
        this.scp.getOutputStream().write((String.valueOf(msg) + '\n').getBytes(IOUtils.UTF8));
        this.scp.getOutputStream().flush();
        this.check("Message ACK received");
    }

    void signal(String what) throws IOException {
        this.log.debug("Signalling: {}", (Object)what);
        this.scp.getOutputStream().write(0);
        this.scp.getOutputStream().flush();
    }

    long transferToRemote(StreamCopier.Listener listener, InputStream src, long length) throws IOException {
        return new StreamCopier(src, this.scp.getOutputStream()).bufSize(this.scp.getRemoteMaxPacketSize()).length(length).keepFlushing(false).listener(listener).copy();
    }

    long transferFromRemote(StreamCopier.Listener listener, OutputStream dest, long length) throws IOException {
        return new StreamCopier(this.scp.getInputStream(), dest).bufSize(this.scp.getLocalMaxPacketSize()).length(length).keepFlushing(false).listener(listener).copy();
    }

    TransferListener getTransferListener() {
        return this.listener;
    }

    static enum Arg {
        SOURCE('f'),
        SINK('t'),
        RECURSIVE('r'),
        VERBOSE('v'),
        PRESERVE_TIMES('p'),
        QUIET('q');

        private final char a;

        private Arg(char a) {
            this.a = a;
        }

        public String toString() {
            return "-" + this.a;
        }
    }
}

