/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;

public class SFTPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SFTPEngine engine;
    private volatile LocalFileFilter uploadFilter;
    private volatile RemoteResourceFilter downloadFilter;
    private volatile boolean preserveAttributes = true;

    public SFTPFileTransfer(SFTPEngine engine) {
        this.engine = engine;
    }

    public boolean getPreserveAttributes() {
        return this.preserveAttributes;
    }

    public void setPreserveAttributes(boolean preserveAttributes) {
        this.preserveAttributes = preserveAttributes;
    }

    @Override
    public void upload(String source, String dest) throws IOException {
        this.upload(new FileSystemFile(source), dest);
    }

    @Override
    public void download(String source, String dest) throws IOException {
        this.download(source, new FileSystemFile(dest));
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath) throws IOException {
        new Uploader().upload(this.getTransferListener(), localFile, remotePath);
    }

    @Override
    public void download(String source, LocalDestFile dest) throws IOException {
        PathComponents pathComponents = this.engine.getPathHelper().getComponents(source);
        FileAttributes attributes = this.engine.stat(source);
        new Downloader().download(this.getTransferListener(), new RemoteResourceInfo(pathComponents, attributes), dest);
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    public void setDownloadFilter(RemoteResourceFilter downloadFilter) {
        this.downloadFilter = downloadFilter;
    }

    public LocalFileFilter getUploadFilter() {
        return this.uploadFilter;
    }

    public RemoteResourceFilter getDownloadFilter() {
        return this.downloadFilter;
    }

    private class Downloader {
        private Downloader() {
        }

        private void download(TransferListener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjustedFile;
            switch (remote.getAttributes().getType()) {
                case DIRECTORY: {
                    adjustedFile = this.downloadDir(listener.directory(remote.getName()), remote, local);
                    break;
                }
                case UNKNOWN: {
                    SFTPFileTransfer.this.log.warn("Server did not supply information about the type of file at `{}` -- assuming it is a regular file!", (Object)remote.getPath());
                }
                case REGULAR: {
                    adjustedFile = this.downloadFile(listener.file(remote.getName(), remote.getAttributes().getSize()), remote, local);
                    break;
                }
                default: {
                    throw new IOException(remote + " is not a regular file or directory");
                }
            }
            if (SFTPFileTransfer.this.getPreserveAttributes()) {
                this.copyAttributes(remote, adjustedFile);
            }
        }

        private LocalDestFile downloadDir(TransferListener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetDirectory(remote.getName());
            try (RemoteDirectory rd = SFTPFileTransfer.this.engine.openDir(remote.getPath());){
                for (RemoteResourceInfo rri : rd.scan(SFTPFileTransfer.this.getDownloadFilter())) {
                    this.download(listener, rri, adjusted.getChild(rri.getName()));
                }
            }
            return adjusted;
        }

        private LocalDestFile downloadFile(StreamCopier.Listener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetFile(remote.getName());
            try (RemoteFile rf = SFTPFileTransfer.this.engine.open(remote.getPath());){
                RemoteFile.RemoteFileInputStream rfis = rf.new RemoteFile.RemoteFileInputStream();
                OutputStream os = adjusted.getOutputStream();
                try {
                    new StreamCopier(rfis, os).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getLocalMaxPacketSize()).keepFlushing(false).listener(listener).copy();
                }
                finally {
                    rfis.close();
                    os.close();
                }
            }
            return adjusted;
        }

        private void copyAttributes(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            FileAttributes attrs = remote.getAttributes();
            local.setPermissions(attrs.getMode().getPermissionsMask());
            if (attrs.has(FileAttributes.Flag.ACMODTIME)) {
                local.setLastAccessedTime(attrs.getAtime());
                local.setLastModifiedTime(attrs.getMtime());
            }
        }
    }

    private class Uploader {
        private Uploader() {
        }

        private void upload(TransferListener listener, LocalSourceFile local, String remote) throws IOException {
            String adjustedPath;
            if (local.isDirectory()) {
                adjustedPath = this.uploadDir(listener.directory(local.getName()), local, remote);
            } else if (local.isFile()) {
                adjustedPath = this.uploadFile(listener.file(local.getName(), local.getLength()), local, remote);
            } else {
                throw new IOException(local + " is not a file or directory");
            }
            if (SFTPFileTransfer.this.getPreserveAttributes()) {
                SFTPFileTransfer.this.engine.setAttributes(adjustedPath, this.getAttributes(local));
            }
        }

        private String uploadDir(TransferListener listener, LocalSourceFile local, String remote) throws IOException {
            String adjusted = this.prepareDir(local, remote);
            for (LocalSourceFile localSourceFile : local.getChildren(SFTPFileTransfer.this.getUploadFilter())) {
                this.upload(listener, localSourceFile, adjusted);
            }
            return adjusted;
        }

        private String uploadFile(StreamCopier.Listener listener, LocalSourceFile local, String remote) throws IOException {
            String adjusted = this.prepareFile(local, remote);
            try (RemoteFile rf = SFTPFileTransfer.this.engine.open(adjusted, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC));){
                InputStream fis = local.getInputStream();
                RemoteFile remoteFile = rf;
                remoteFile.getClass();
                RemoteFile.RemoteFileOutputStream rfos = remoteFile.new RemoteFile.RemoteFileOutputStream(0L, 16);
                try {
                    new StreamCopier(fis, rfos).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getRemoteMaxPacketSize() - rf.getOutgoingPacketOverhead()).keepFlushing(false).listener(listener).copy();
                }
                finally {
                    fis.close();
                    rfos.close();
                }
            }
            return adjusted;
        }

        private String prepareDir(LocalSourceFile local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.engine.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} does not exist, creating", (Object)remote);
                    SFTPFileTransfer.this.engine.makeDir(remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                if (SFTPFileTransfer.this.engine.getPathHelper().getComponents(remote).getName().equals(local.getName())) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} already exists", (Object)remote);
                    return remote;
                }
                SFTPFileTransfer.this.log.debug("probeDir: {} already exists, path adjusted for {}", (Object)remote, (Object)local.getName());
                return this.prepareDir(local, SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(remote, local.getName()));
            }
            throw new IOException((Object)((Object)attrs.getMode().getType()) + " file already exists at " + remote);
        }

        private String prepareFile(LocalSourceFile local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.engine.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeFile: {} does not exist", (Object)remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                SFTPFileTransfer.this.log.debug("probeFile: {} was directory, path adjusted for {}", (Object)remote, (Object)local.getName());
                return SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(remote, local.getName());
            }
            SFTPFileTransfer.this.log.debug("probeFile: {} is a {} file that will be replaced", (Object)remote, (Object)attrs.getMode().getType());
            return remote;
        }

        private FileAttributes getAttributes(LocalSourceFile local) throws IOException {
            FileAttributes.Builder builder = new FileAttributes.Builder().withPermissions(local.getPermissions());
            if (local.providesAtimeMtime()) {
                builder.withAtimeMtime(local.getLastAccessTime(), local.getLastModifiedTime());
            }
            return builder.build();
        }
    }
}

