/*
 * Decompiled with CFR 0.152.
 */
package eu.datex2.wsdl.supplierPush._2_0;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private X509ExtendedTrustManager defaultTrustManager = null;
    private static final Log LOG = LogFactory.getLog(AuthSSLX509ExtendedTrustManager.class);

    public AuthSSLX509ExtendedTrustManager(X509ExtendedTrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (LOG.isInfoEnabled() && certificates != null) {
            int c = 0;
            while (c < certificates.length) {
                X509Certificate cert = certificates[c];
                LOG.info((Object)(" Client certificate " + (c + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.info((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.info((Object)("  Issuer: " + cert.getIssuerDN()));
                ++c;
            }
        }
        this.defaultTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (LOG.isInfoEnabled() && certificates != null) {
            int c = 0;
            while (c < certificates.length) {
                X509Certificate cert = certificates[c];
                LOG.info((Object)(" Server certificate " + (c + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.info((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.info((Object)("  Issuer: " + cert.getIssuerDN()));
                ++c;
            }
        }
        this.defaultTrustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType, socket);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType, engine);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType, socket);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType, engine);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

