/*
 * Decompiled with CFR 0.152.
 */
package eu.datex2.schema._2._2_0;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.CalendarDeserializer;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.encoding.ser.SimpleSerializer;

public abstract class CalendarBean
extends Calendar
implements Serializable {
    private static TypeDesc typeDesc = new TypeDesc(Calendar.class, true);

    public CalendarBean() {
    }

    public CalendarBean(String _value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        try {
            String temp = String.valueOf(_value.substring(0, 22)) + _value.substring(23);
            Date d1 = sdf.parse(temp);
            Calendar cal = Calendar.getInstance(Locale.FRANCE);
            cal.setTime(d1);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            this.time = cal.getTimeInMillis();
        }
        catch (ParseException e) {
            Calendar cal = (Calendar)new CalendarDeserializer(String.class, Constants.XSD_STRING).makeValue(_value);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            this.time = cal.getTimeInMillis();
        }
    }

    @Override
    public String toString() {
        String str = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        Calendar cal = Calendar.getInstance(Locale.FRANCE);
        str = sdf.format(this.getTime());
        str = String.valueOf(str.substring(0, 22)) + ":" + str.substring(22);
        return str;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new SimpleSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new SimpleDeserializer(_javaType, _xmlType, typeDesc);
    }
}

