/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.updphotos;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import gls.outils.GLS;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class UpdatePhotos {
    IBusinessService serv;
    private PropertiesConfiguration config = new PropertiesConfiguration();
    private Connection co;

    public static void main(String[] args) throws Exception {
        UpdatePhotos update = new UpdatePhotos();
        update.doUpdate();
    }

    public UpdatePhotos() throws IOException, SQLException, ClassNotFoundException {
        Class.forName(this.config.get("jdbc.driver"));
        this.co = DriverManager.getConnection(this.config.get("jdbc.url"), this.config.get("jdbc.username"), this.config.get("jdbc.password"));
    }

    public void doUpdate() throws SQLException {
        this.serv = new BusinessServiceDAO();
        PreparedStatement pst = this.co.prepareStatement("select k_eventid as id,snm,erf, dob, code_evenement, hash, length, size, * from evenement e , (select p.hash as hash, length(data), concat(length(data) / 1048576.0, ' MB') as size from photo p where length(data) > 10000 order by length(data)) photo  where photo.hash = ANY(e.photos)");
        ResultSet rs = pst.executeQuery();
        int cpt = 0;
        while (rs.next()) {
            Evt evt = new Evt();
            evt.id = rs.getInt("id");
            evt.erf = rs.getString("erf");
            evt.dob = rs.getString("dob");
            evt.snm = rs.getString("snm");
            evt.photos = new ArrayList<String>();
            evt.photos.add(rs.getString("hash"));
            this.traiterEvenement(evt);
            ++cpt;
        }
        rs.close();
        pst.close();
        this.co.close();
        System.out.println(cpt + " evenements mis \u00e0 jours");
    }

    private void traiterEvenement(Evt e) {
        for (String photoname : e.photos) {
            int qualiteMaxPhoto;
            int largeurMaxPhoto;
            int tailleMaxPhoto;
            byte[] data = this.serv.getPhoto(photoname);
            if (data.length <= (tailleMaxPhoto = this.getTailleMaxPhotoCompresseeNature(e.dob)) || (data = this.compressPhoto(data, largeurMaxPhoto = this.getLargeurPhotoCompresseeNature(e.dob), (float)(qualiteMaxPhoto = this.getQualitePhotoCompresseeNature(e.dob)) * 0.8f, 0)) == null) continue;
            this.serv.sauvegarderPhoto(photoname, data);
        }
    }

    public int getLargeurPhotoCompresseeNature(String nature) {
        return this.getInt(this.getChampLargeurPhotoCompresseeNature(nature), this.getLargeurPhotoCompresseeDefaut());
    }

    public int getLargeurPhotoCompresseeDefaut() {
        return this.getInt("photo.largeur", 640);
    }

    public String getChampLargeurPhotoCompresseeNature(String nature) {
        if (!GLS.estVide((String)nature)) {
            return nature.concat(".").concat("photo.largeur");
        }
        return "photo.largeur";
    }

    public String getChampQualitePhotoCompresseeNature(String nature) {
        if (!GLS.estVide((String)nature)) {
            return nature.concat(".").concat("photo.qualite");
        }
        return "photo.qualite";
    }

    public String getChampTailleMaxPhotoCompresseeNature(String nature) {
        if (!GLS.estVide((String)nature)) {
            return nature.concat(".").concat("photo.tailleMax");
        }
        return "photo.tailleMax";
    }

    public int getTailleMaxPhotoCompresseeDefaut() {
        return this.getInt("photo.tailleMax", 200000);
    }

    public int getQualitePhotoCompresseeDefaut() {
        return this.getInt("photo.qualite", 40);
    }

    public int getQualitePhotoCompresseeNature(String nature) {
        return this.getInt(this.getChampQualitePhotoCompresseeNature(nature), this.getQualitePhotoCompresseeDefaut());
    }

    public int getTailleMaxPhotoCompresseeNature(String nature) {
        return this.getInt(this.getChampTailleMaxPhotoCompresseeNature(nature), this.getTailleMaxPhotoCompresseeDefaut());
    }

    public int getInt(String config, int defaut) {
        return this.serv.getConfiguration().getInt(config, defaut);
    }

    private byte[] compressPhoto(byte[] data, int largeurMaxPhoto, float qualiteMaxPhoto, int imageType) {
        try {
            BufferedImage src = ImageIO.read(new ByteArrayInputStream(data));
            double ratio = 1.0 * (double)src.getHeight() / (double)src.getWidth();
            int height = (int)((double)largeurMaxPhoto * ratio);
            BufferedImage resizedImage = new BufferedImage(largeurMaxPhoto, height, imageType == 0 ? src.getType() : 5);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(src, 0, 0, largeurMaxPhoto, height, null);
            g.dispose();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(qualiteMaxPhoto / 100.0f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream output = new MemoryCacheImageOutputStream(baos);
            writer.setOutput(output);
            IIOImage image = new IIOImage(resizedImage, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
            output.flush();
            output.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Log.error((Object)"Erreur cr\u00e9ation miniature", (Throwable)e);
            try {
                if (imageType != 5) {
                    return this.compressPhoto(data, largeurMaxPhoto, qualiteMaxPhoto, 5);
                }
                return null;
            }
            catch (Exception e3b) {
                throw new RuntimeException("Erreur cr\u00e9ation miniature", e);
            }
        }
    }

    private class Evt {
        public int id;
        public String snm;
        public String erf;
        public String dob;
        public List<String> photos;

        private Evt() {
        }
    }

    class PropertiesConfiguration {
        private static final String PROPERTIES_FILE = "prismcentral.properties";
        private static final String PRISM_CENTRAL_PROPERTIES = "config.properties";
        private Properties properties;

        public PropertiesConfiguration() throws IOException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream propertiesFile = classLoader.getResourceAsStream(PROPERTIES_FILE);
            this.properties = new Properties();
            this.properties.load(propertiesFile);
        }

        public String get(String key) {
            if (this.properties.containsKey(key)) {
                return this.properties.getProperty(key);
            }
            throw new RuntimeException("Missing key " + key + " in file " + PRISM_CENTRAL_PROPERTIES);
        }

        public String get(String key, boolean mandatory) {
            if (this.properties.containsKey(key)) {
                return this.properties.getProperty(key);
            }
            if (mandatory) {
                throw new RuntimeException("Missing key " + key + " in file " + PRISM_CENTRAL_PROPERTIES);
            }
            return null;
        }

        public int getInt(String key) {
            String val = this.get(key);
            try {
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                throw new RuntimeException("Unparsable int " + val + " for key " + key);
            }
        }

        public double getDouble(String key) {
            String val = this.get(key);
            try {
                return Double.parseDouble(val);
            }
            catch (Exception e) {
                throw new RuntimeException("Unparsable double " + val + " for key " + key);
            }
        }
    }
}

