/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.updphotos;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.BusinessServiceArchiveDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PhotoToArchiveDatabase {
    private boolean deletePhotos = false;
    IBusinessService serv;

    public static void main(String[] args) throws IOException {
        long tref = System.currentTimeMillis();
        new PhotoToArchiveDatabase().run();
        long t = System.currentTimeMillis() - tref;
        System.out.println("Termin\u00e9 en " + t + "ms.");
    }

    public void run() throws IOException {
        this.deletePhotos = ConfigurationFactory.getInstance().getBoolean("photos.delete", false);
        this.serv = new BusinessServiceArchiveDAO();
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byDelegation(null, null);
        filtre.termines = -1;
        filtre.etat = -1;
        List situations = this.serv.getEvenements(filtre, null);
        int cpt = 0;
        for (Situation situation : situations) {
            for (Evenement e : situation.getEvenements()) {
                this.traiterEvenement(e);
                ++cpt;
            }
        }
        System.out.println("nb evt = " + cpt);
    }

    private void traiterEvenement(Evenement e) throws IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        ArrayList<File> photos = new ArrayList<File>();
        if (e.getPhotos() != null && e.getPhotos().size() > 0) {
            File globalDir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
            File situationDir = new File(globalDir, e.getIdSituation());
            File evtDir = new File(situationDir, e.getIdReference());
            System.out.println("dir = " + evtDir.getPath());
            if (!evtDir.exists()) {
                System.err.println(String.valueOf(evtDir.getPath()) + " n'existe pas ! Evenement non modifi\u00e9");
                return;
            }
            for (String photoname : e.getPhotos()) {
                File photoFile = new File(evtDir, photoname);
                if (!photoFile.exists()) {
                    System.err.println("la photo " + photoFile.getPath() + " n'existe pas, elle sera abandonn\u00e9e !");
                    continue;
                }
                byte[] data = Files.readAllBytes(photoFile.toPath());
                String hash = Hashing.md5().hashBytes(data).toString();
                this.serv.sauvegarderPhoto(hash, data);
                hashes.add(hash);
                photos.add(photoFile);
            }
            if (hashes.size() > 0) {
                this.updatePhotosEvenement(e.getkEventid(), hashes);
                if (this.deletePhotos) {
                    this.deletePhotosEvenement(photos);
                }
            } else {
                System.err.println(String.valueOf(evtDir.getPath()) + "aucune photo \u00e0 traiter ! Evenement non modifi\u00e9");
            }
        }
    }

    private void updatePhotosEvenement(int kEventid, List<String> hashes) {
        System.out.println("Mise \u00e0 jour de " + kEventid);
        System.out.println("Photos : " + hashes.toString());
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = DAOFactory.getInstance().getConnection();
                pstm = connection.prepareStatement("UPDATE prism.evenement SET photos=? WHERE k_eventid=?");
                pstm.setArray(1, connection.createArrayOf("text", hashes.toArray(new String[0])));
                pstm.setInt(2, kEventid);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException((Throwable)e);
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close((Connection)connection, pstm);
            throw throwable;
        }
        DAOUtil.close((Connection)connection, (Statement)pstm);
    }

    private void deletePhotosEvenement(List<File> photos) {
        for (File photo : photos) {
            if (!photo.exists()) continue;
            photo.delete();
        }
    }
}

