/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prism.webservices.datex2.fournisseur.FournisseurServices;
import com.geolocsystems.prism.webservices.datex2.metier.pushpull.PushPullServices;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.outils.GLS;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ServicePushPull {
    private static final Logger LOGGER = Logger.getLogger(ServicePushPull.class);
    private static IConfiguration myConfig;
    private static IDatex2Service metierDatex2;

    private ServicePushPull() {
    }

    public static void main(String[] args) {
        int code = ServicePushPull.traitement(args);
        System.exit(code);
    }

    private static boolean estTempoOk(long dateDerniereSynchro, Calendar maintenant, long tempoScrutation) {
        return dateDerniereSynchro + tempoScrutation * 1000L < maintenant.getTimeInMillis();
    }

    protected static int traitement(String[] args) {
        String zone;
        List fournisseurs = null;
        Map corresDatex2 = null;
        metierDatex2 = BusinessServiceFactory.getDatex2Service();
        Calendar maintenant = GregorianCalendar.getInstance();
        try {
            LOGGER.info((Object)"Initialisation du fichier de configuration");
            myConfig = ConfigurationFactory.getInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)"ERREUR FICHIER CONFIG ", (Throwable)e);
            myConfig = null;
        }
        if (myConfig == null) {
            LOGGER.error((Object)"Erreur dans l'initialisation de la configuration");
            System.exit(1);
        }
        try {
            zone = myConfig.get("zoneroutiere");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur plors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((String)zone)) {
            LOGGER.error((Object)"Zone routi\u00e8re vide");
            return 0;
        }
        try {
            fournisseurs = metierDatex2.getFournisseurs(zone);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la lecture des fournisseurs", (Throwable)e);
            return 1;
        }
        try {
            corresDatex2 = metierDatex2.getMapDescriptionPrismDatex2(zone);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((List)fournisseurs)) {
            LOGGER.info((Object)"Pas de fournisseur Datex2");
            return 0;
        }
        LOGGER.info((Object)"Synchronisation PushPull");
        PushPullServices pushPullService = PushPullServices.getInstance();
        String nomFichier = myConfig.get("nom.fichier");
        String repApache = myConfig.get("repertoire.depot");
        boolean soap = "SOAP".equals(myConfig.get("format.fichier"));
        for (FournisseurVO fournisseur : fournisseurs) {
            if (!fournisseur.getEtatClient()) continue;
            FournisseurServices fourSer = new FournisseurServices(fournisseur);
            fourSer.initialisationConvertisseur(corresDatex2);
            try {
                pushPullService.traitementFichiersPush(fourSer, repApache, soap);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Erreur traitementFichiersPush " + fournisseur.getIdentifiant() + " - " + fournisseur.getZoneRoutiere()), (Throwable)e);
            }
            if (ServicePushPull.estTempoOk(fournisseur.getDateSynchro(), maintenant, fournisseur.getTempo())) {
                try {
                    pushPullService.traitementSnapshot(fourSer, repApache, soap, nomFichier);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Erreur traitementSnapshot " + fournisseur.getIdentifiant() + " - " + fournisseur.getZoneRoutiere()), (Throwable)e);
                }
            }
            try {
                metierDatex2.miseAJourDateSynchro(fournisseur);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Erreur mise \u00e0 jour derni\u00e8re date synchro fournisseur " + fournisseur.getIdentifiant() + " - " + fournisseur.getZoneRoutiere()), (Throwable)e);
            }
            return 0;
        }
        return 0;
    }
}

