/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prism.localisation.BouchonCartoService;
import com.geolocsystems.prism.localisation.CartojCartoService;
import com.geolocsystems.prism.localisation.ICartoServiceData;
import com.geolocsystems.prism.localisation.ServletCartoService;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.data.IImportEvenementService;
import com.geolocsystems.prismcentral.data.IMailService;
import com.geolocsystems.prismcentral.data.ISuiviActiviteService;
import com.geolocsystems.prismcentral.service.ImportEvenementGenerique;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import gls.outils.GLS;
import java.util.Iterator;
import java.util.ServiceLoader;

public class BusinessServiceFactory {
    private static IBusinessService businessInstance;
    private static ICartoServiceData cartoInstance;
    private static IExportService exportInstance;
    private static IMailService mailInstance;
    private static IDatex2Service datex2Instance;
    private static ISuiviActiviteService suiviActiviteinstance;
    private static IImportEvenementService importEvenementService;
    private static final String CARTO_TYPE_BOUCHON = "bouchon";
    private static final String CARTO_TYPE_SERVLET = "servlet";
    private static final String CARTO_TYPE_CARTOJ = "cartoj";

    public static IBusinessService getBusinessService() {
        if (businessInstance == null) {
            ServiceLoader<IBusinessService> ldr = ServiceLoader.load(IBusinessService.class);
            String nomClasse = ConfigurationFactory.getInstance().get("businessservice");
            IBusinessService firstBusiness = null;
            Iterator<IBusinessService> iterator = ldr.iterator();
            while (iterator.hasNext()) {
                IBusinessService provider;
                firstBusiness = provider = iterator.next();
                if (!nomClasse.equals(provider.getClass().getName())) continue;
                businessInstance = provider;
                break;
            }
            if (businessInstance == null) {
                if (firstBusiness != null) {
                    businessInstance = firstBusiness;
                } else {
                    throw new PrismConfigurationError("Type de business service inconnu :");
                }
            }
        }
        return businessInstance;
    }

    public static ISuiviActiviteService getSuiviActiviteService() {
        if (suiviActiviteinstance == null) {
            ServiceLoader<ISuiviActiviteService> ldr = ServiceLoader.load(ISuiviActiviteService.class);
            ISuiviActiviteService firstBusiness = null;
            for (ISuiviActiviteService provider : ldr) {
                if (provider.getZonesRoutiere() == null) {
                    firstBusiness = provider;
                    continue;
                }
                try {
                    String zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
                    if (!GLS.estDansLaListe((String[])provider.getZonesRoutiere(), (String)zoneRoutiere)) continue;
                    suiviActiviteinstance = provider;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (suiviActiviteinstance == null) {
                if (firstBusiness != null) {
                    suiviActiviteinstance = firstBusiness;
                } else {
                    throw new PrismConfigurationError("Type de SuiviActiviteService inconnu :");
                }
            }
        }
        return suiviActiviteinstance;
    }

    public static IImportEvenementService getImportEvenementService() {
        if (importEvenementService == null) {
            ServiceLoader<IImportEvenementService> ldr = ServiceLoader.load(IImportEvenementService.class);
            IImportEvenementService firstBusiness = null;
            for (IImportEvenementService provider : ldr) {
                if (provider.getZonesRoutiere() == null) {
                    firstBusiness = provider;
                    continue;
                }
                try {
                    String zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
                    if (!GLS.estDansLaListe((String[])provider.getZonesRoutiere(), (String)zoneRoutiere)) continue;
                    importEvenementService = provider;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (importEvenementService == null) {
                if (firstBusiness != null) {
                    importEvenementService = firstBusiness;
                } else {
                    throw new PrismConfigurationError("Type de ImportEvenementService inconnu :");
                }
            }
        }
        return importEvenementService;
    }

    public static IImportEvenementService getImportEvenementGenerique() {
        if (importEvenementService == null) {
            importEvenementService = new ImportEvenementGenerique();
        }
        return importEvenementService;
    }

    public static IDatex2Service getDatex2Service() {
        if (datex2Instance == null) {
            ServiceLoader<IDatex2Service> ldr = ServiceLoader.load(IDatex2Service.class);
            String nomClasse = ConfigurationFactory.getInstance().get("datex2service");
            IDatex2Service firstBusiness = null;
            Iterator<IDatex2Service> iterator = ldr.iterator();
            while (iterator.hasNext()) {
                IDatex2Service provider;
                firstBusiness = provider = iterator.next();
                if (!nomClasse.equals(provider.getClass().getName())) continue;
                datex2Instance = provider;
                break;
            }
            if (datex2Instance == null) {
                if (firstBusiness != null) {
                    datex2Instance = firstBusiness;
                } else {
                    throw new PrismConfigurationError("Type de business service inconnu :");
                }
            }
        }
        return datex2Instance;
    }

    public static ICartoServiceData getCartoService() {
        block13: {
            String type;
            if (cartoInstance != null) break block13;
            switch (type = ConfigurationFactory.getInstance().get("cartoservice.type")) {
                case "bouchon": {
                    cartoInstance = new BouchonCartoService();
                    break;
                }
                case "cartoj": {
                    cartoInstance = new CartojCartoService(BusinessServiceFactory.getBusinessService().getConfiguration(), BusinessServiceFactory.getBusinessService().getCaracteristiquesRoute());
                    break;
                }
                case "servlet": {
                    cartoInstance = new ServletCartoService();
                    break;
                }
                default: {
                    throw new PrismConfigurationError("Type de business service inconnu : " + type);
                }
            }
        }
        return cartoInstance;
    }
}

