/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2.fournisseur;

import com.geolocsystems.prism.webservices.datex2.ConvertisseurDatex2V2;
import com.geolocsystems.prism.webservices.datex2.D2LogicalModelServices;
import com.geolocsystems.prism.webservices.datex2.D2LogicalModelServicesImpl;
import com.geolocsystems.prism.webservices.datex2.Datex2V2Factory;
import com.geolocsystems.prism.webservices.datex2.Datex2V2Util;
import com.geolocsystems.prism.webservices.datex2.exception.ClientPushException;
import com.geolocsystems.prism.webservices.datex2.fournisseur.FournisseurListener;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import eu.datex2.schema._2._2_0.CountryEnum;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.Exchange;
import eu.datex2.schema._2._2_0.InternationalIdentifier;
import eu.datex2.schema._2._2_0._ExtensionType;
import eu.datex2.schema._2._2_0.holders.D2LogicalModelHolder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FournisseurServices
implements FournisseurListener {
    private static final Logger LOGGER = Logger.getLogger(FournisseurServices.class);
    private FournisseurVO fournisseur = null;
    private ConvertisseurDatex2V2 convertisseurDatex2V2 = null;

    public FournisseurServices() {
        this.fournisseur = new FournisseurVO();
    }

    public FournisseurServices(FournisseurVO fournisseurVO) {
        this.fournisseur = fournisseurVO;
        try {
            this.convertisseurDatex2V2 = Datex2V2Factory.getConvertisseurDatex2V2(this.fournisseur.getClasseConvertisseur());
            this.convertisseurDatex2V2.setNationalIdentifier(fournisseurVO.getIdentifiant());
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Erreur g\u00e9n\u00e9ration Datex2", (Throwable)e);
            this.convertisseurDatex2V2 = null;
        }
    }

    public void initialisationConvertisseur(Map<String, CorrespondanceDatex2> mapPrismDatex2) {
        this.convertisseurDatex2V2.initMapPrism(mapPrismDatex2);
    }

    public final D2LogicalModel convertEvenement(Evenement evenement) throws ClientPushException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":D\u00e9but convertEvenement"));
        }
        D2LogicalModel logicalModel = null;
        ArrayList<Evenement> listeEvenements = new ArrayList<Evenement>();
        listeEvenements.add(evenement);
        try {
            logicalModel = this.convertisseurDatex2V2.genererModelDatex2(true, listeEvenements);
        }
        catch (Exception e) {
            LOGGER.error((Object)"ERREUR CONVERSION LOGICAL MODEL", (Throwable)e);
        }
        if (logicalModel != null) {
            LOGGER.info((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ": Concvertion \u00e9v\u00e8nement"));
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug((Object)Datex2V2Util.serialiserHelper(logicalModel, false));
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Erreur s\u00e9rialisation Datex2", (Throwable)e);
                }
                LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":Fin convertEvenement"));
            }
        }
        return logicalModel;
    }

    public final D2LogicalModel convertEvenements(ArrayList<Evenement> listeEvenements) throws ClientPushException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":D\u00e9but convertEvenement"));
        }
        D2LogicalModel logicalModel = null;
        try {
            logicalModel = this.convertisseurDatex2V2.genererModelDatex2(true, listeEvenements);
        }
        catch (Exception e) {
            LOGGER.error((Object)"ERREUR CONVERSION LOGICAL MODEL", (Throwable)e);
        }
        if (logicalModel != null) {
            LOGGER.info((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ": Concvertion \u00e9v\u00e8nement"));
            if (LOGGER.isInfoEnabled()) {
                try {
                    LOGGER.info((Object)Datex2V2Util.serialiserHelper(logicalModel, false));
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Erreur s\u00e9rialisation Datex2", (Throwable)e);
                }
                LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":Fin convertEvenement"));
            }
        }
        return logicalModel;
    }

    @Override
    public final void pushEvenement(Evenement evenement) throws ClientPushException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":D\u00e9but pushEvenement"));
        }
        D2LogicalModel logicalModel = null;
        ArrayList<Evenement> listeEvenements = new ArrayList<Evenement>();
        listeEvenements.add(evenement);
        try {
            logicalModel = this.convertisseurDatex2V2.genererModelDatex2(true, listeEvenements);
        }
        catch (Exception e) {
            LOGGER.error((Object)"ERREUR CONVERSION LOGICAL MODEL", (Throwable)e);
        }
        if (logicalModel == null) {
            LOGGER.info((Object)"Pas d'\u00e9l\u00e9ments \u00e0 envoyer");
            return;
        }
        LOGGER.info((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ": Envoi d'\u00e9v\u00e8nements"));
        D2LogicalModelHolder holder = new D2LogicalModelHolder(logicalModel);
        D2LogicalModelServicesImpl d2Service = new D2LogicalModelServicesImpl();
        d2Service.appelRealTimeDatex2Data(holder, this.fournisseur.getUrl(), this.fournisseur.getWSDDServiceName(), this.fournisseur.getTimeOutUrl(), this.fournisseur.getUser(), this.fournisseur.getPassword());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":Fin pushEvenement"));
        }
    }

    public final void pushEvenements(ArrayList<Evenement> listeEvenements) throws ClientPushException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":D\u00e9but pushEvenement"));
        }
        D2LogicalModel logicalModel = null;
        try {
            logicalModel = this.convertisseurDatex2V2.genererModelDatex2(true, listeEvenements);
        }
        catch (Exception e) {
            throw new ClientPushException(e);
        }
        if (logicalModel != null) {
            LOGGER.info((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ": Envoi d'\u00e9v\u00e8nements"));
            D2LogicalModelHolder holder = new D2LogicalModelHolder(logicalModel);
            D2LogicalModelServicesImpl d2Service = new D2LogicalModelServicesImpl();
            d2Service.appelRealTimeDatex2Data(holder, this.fournisseur.getUrl(), this.fournisseur.getWSDDServiceName(), this.fournisseur.getTimeOutUrl(), this.fournisseur.getUser(), this.fournisseur.getPassword());
            logicalModel = holder.value;
            if (LOGGER.isDebugEnabled() && logicalModel.getExchange().getResponse() != null) {
                LOGGER.debug((Object)("Response : " + logicalModel.getExchange().getResponse().getValue()));
            }
        } else {
            LOGGER.info((Object)"Pas d'\u00e9l\u00e9ments \u00e0 envoyer");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":Fin pushEvenement"));
        }
    }

    public final void pushEvenement(D2LogicalModel logicalModel) throws ClientPushException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":D\u00e9but pushEvenement"));
        }
        LOGGER.info((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ": Envoi d'\u00e9v\u00e8nements"));
        D2LogicalModelHolder holder = new D2LogicalModelHolder(logicalModel);
        D2LogicalModelServices d2Service = Datex2V2Factory.getD2LogicalModelServices();
        d2Service.appelRealTimeDatex2Data(holder, this.fournisseur.getUrl(), this.fournisseur.getWSDDServiceName(), this.fournisseur.getTimeOutUrl(), this.fournisseur.getUser(), this.fournisseur.getPassword());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.fournisseur.getIdentifiant()) + ":Fin pushEvenement"));
        }
    }

    public final void setFournisseur(FournisseurVO fournisseurVO) {
        this.fournisseur = fournisseurVO;
    }

    public final FournisseurVO getFournisseur() {
        return this.fournisseur;
    }

    @Override
    public final long getPeriod() {
        return this.fournisseur.getPeriod();
    }

    @Override
    public final void setPeriod(long period) {
        this.fournisseur.setPeriod(period);
    }

    public Exchange prepareRequeteKeepAlive(String nomFournisseur, String idFournisseur) {
        Exchange exchange = new Exchange();
        if (nomFournisseur != null) {
            exchange.setSupplierIdentification(new InternationalIdentifier(CountryEnum.fromValue("fr"), nomFournisseur, new _ExtensionType()));
        } else {
            exchange.setSupplierIdentification(new InternationalIdentifier(CountryEnum.fromValue("fr"), "UNKNOWN", new _ExtensionType()));
        }
        exchange.setKeepAlive(true);
        exchange.setClientIdentification(idFournisseur);
        return exchange;
    }
}

